/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StyleInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class LayerGroupHelper {
    private LayerGroupInfo group;

    public LayerGroupHelper(LayerGroupInfo group) {
        this.group = group;
    }

    public List<LayerInfo> allLayers() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerGroupHelper.allLayers(this.group, layers);
        return layers;
    }

    private static void allLayers(LayerGroupInfo group, List<LayerInfo> layers) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            layers.add(group.getRootLayer());
        }
        for (PublishedInfo p : group.getLayers()) {
            if (p instanceof LayerInfo) {
                LayerInfo l = (LayerInfo)p;
                layers.add(l);
                continue;
            }
            LayerGroupHelper.allLayers((LayerGroupInfo)p, layers);
        }
    }

    public List<StyleInfo> allStyles() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        LayerGroupHelper.allStyles(this.group, styles);
        return styles;
    }

    private static void allStyles(LayerGroupInfo group, List<StyleInfo> styles) {
        if (LayerGroupInfo.Mode.EO.equals((Object)group.getMode())) {
            styles.add(group.getRootLayerStyle());
        }
        int size = group.getLayers().size();
        for (int i = 0; i < size; ++i) {
            PublishedInfo p = group.getLayers().get(i);
            if (p instanceof LayerInfo) {
                styles.add(group.getStyles().get(i));
                continue;
            }
            LayerGroupHelper.allStyles((LayerGroupInfo)p, styles);
        }
    }

    public List<LayerInfo> allLayersForRendering() {
        ArrayList<LayerInfo> layers = new ArrayList<LayerInfo>();
        LayerGroupHelper.allLayersForRendering(this.group, layers, true);
        return layers;
    }

    private static void allLayersForRendering(LayerGroupInfo group, List<LayerInfo> layers, boolean root) {
        switch (group.getMode()) {
            case EO: {
                layers.add(group.getRootLayer());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                for (PublishedInfo p : group.getLayers()) {
                    if (p instanceof LayerInfo) {
                        LayerInfo l = (LayerInfo)p;
                        layers.add(l);
                        continue;
                    }
                    LayerGroupHelper.allLayersForRendering((LayerGroupInfo)p, layers, false);
                }
            }
        }
    }

    public List<StyleInfo> allStylesForRendering() {
        ArrayList<StyleInfo> styles = new ArrayList<StyleInfo>();
        LayerGroupHelper.allStylesForRendering(this.group, styles, true);
        return styles;
    }

    private static void allStylesForRendering(LayerGroupInfo group, List<StyleInfo> styles, boolean root) {
        switch (group.getMode()) {
            case EO: {
                styles.add(group.getRootLayerStyle());
                break;
            }
            case CONTAINER: {
                if (root) {
                    throw new UnsupportedOperationException("LayerGroup mode " + LayerGroupInfo.Mode.CONTAINER.getName() + " can not be rendered");
                }
            }
            default: {
                int size = group.getLayers().size();
                for (int i = 0; i < size; ++i) {
                    PublishedInfo p = group.getLayers().get(i);
                    if (p instanceof LayerInfo) {
                        styles.add(group.getStyles().get(i));
                        continue;
                    }
                    LayerGroupHelper.allStylesForRendering((LayerGroupInfo)p, styles, false);
                }
            }
        }
    }

    public void calculateBounds(CoordinateReferenceSystem crs) throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = new ReferencedEnvelope(crs);
        for (int i = 0; i < layers.size(); ++i) {
            l = layers.get(i);
            bounds.expandToInclude((Envelope)LayerGroupHelper.transform(l.getResource().getLatLonBoundingBox(), crs));
        }
        this.group.setBounds(bounds);
    }

    public void calculateBounds() throws Exception {
        List<LayerInfo> layers = this.allLayers();
        if (layers.isEmpty()) {
            return;
        }
        LayerInfo l = layers.get(0);
        ReferencedEnvelope bounds = l.getResource().boundingBox();
        boolean latlon = false;
        if (bounds == null) {
            bounds = l.getResource().getLatLonBoundingBox();
            latlon = true;
        }
        if (bounds == null) {
            throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
        }
        for (int i = 1; i < layers.size(); ++i) {
            ReferencedEnvelope re;
            l = layers.get(i);
            ResourceInfo resource = l.getResource();
            if (latlon) {
                re = resource.getLatLonBoundingBox();
            } else {
                re = resource.boundingBox();
                if (re == null) {
                    re = resource.getLatLonBoundingBox();
                }
            }
            re = LayerGroupHelper.transform(re, bounds.getCoordinateReferenceSystem());
            if (re == null) {
                throw new IllegalArgumentException("Could not calculate bounds from layer with no bounds, " + l.getName());
            }
            bounds.expandToInclude((Envelope)re);
        }
        this.group.setBounds(bounds);
    }

    private static ReferencedEnvelope transform(ReferencedEnvelope e, CoordinateReferenceSystem crs) throws TransformException, FactoryException {
        if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)e.getCoordinateReferenceSystem())) {
            return e.transform(crs, true);
        }
        return e;
    }

    public Stack<LayerGroupInfo> checkLoops() {
        Stack<LayerGroupInfo> path = new Stack<LayerGroupInfo>();
        if (LayerGroupHelper.checkLoops(this.group, path)) {
            return path;
        }
        return null;
    }

    public String getLoopAsString(Stack<LayerGroupInfo> path) {
        if (path == null) {
            return "";
        }
        StringBuilder s = new StringBuilder();
        for (LayerGroupInfo g : path) {
            s.append("/").append(g.getName());
        }
        return s.toString();
    }

    private static boolean checkLoops(LayerGroupInfo group, Stack<LayerGroupInfo> path) {
        path.push(group);
        if (group.getLayers() != null) {
            for (PublishedInfo child : group.getLayers()) {
                if (!(child instanceof LayerGroupInfo)) continue;
                if (LayerGroupHelper.isGroupInStack((LayerGroupInfo)child, path)) {
                    path.push((LayerGroupInfo)child);
                    return true;
                }
                if (!LayerGroupHelper.checkLoops((LayerGroupInfo)child, path)) continue;
                return true;
            }
        }
        path.pop();
        return false;
    }

    private static boolean isGroupInStack(LayerGroupInfo group, Stack<LayerGroupInfo> path) {
        for (LayerGroupInfo groupInPath : path) {
            if (groupInPath.getId() == null || !groupInPath.getId().equals(group.getId())) continue;
            return true;
        }
        return false;
    }
}

