/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.media.jai.ImageLayout;
import javax.media.jai.RasterFactory;
import org.geoserver.catalog.CoverageDimensionCustomizerReader;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageView;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geoserver.catalog.StructuredCoverageViewReader;
import org.geoserver.catalog.impl.CoverageDimensionImpl;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.coverage.processing.CoverageProcessor;
import org.geotools.data.DataSourceException;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.jaitools.imageutils.ImageLayout2;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.filter.FilterFactory2;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;

public class CoverageViewReader
implements GridCoverage2DReader {
    public static final FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2();
    private static final CoverageProcessor PROCESSOR = CoverageProcessor.getInstance();
    CoverageView coverageView;
    String referenceName;
    private String coverageName;
    private GridCoverage2DReader delegate;
    private Hints hints;
    private CoverageInfo coverageInfo;
    private GridCoverageFactory coverageFactory;
    private ImageLayout imageLayout;

    public CoverageViewReader(GridCoverage2DReader delegate, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        Object factory;
        this.coverageName = coverageView.getName();
        this.delegate = delegate;
        this.coverageView = coverageView;
        this.coverageInfo = coverageInfo;
        this.hints = hints;
        this.referenceName = coverageView.getBand(0).getInputCoverageBands().get(0).getCoverageName();
        if (this.hints != null && this.hints.containsKey((Object)Hints.GRID_COVERAGE_FACTORY) && (factory = this.hints.get((Object)Hints.GRID_COVERAGE_FACTORY)) != null && factory instanceof GridCoverageFactory) {
            this.coverageFactory = (GridCoverageFactory)factory;
        }
        if (this.coverageFactory == null) {
            this.coverageFactory = CoverageFactoryFinder.getGridCoverageFactory((Hints)this.hints);
        }
        try {
            ImageLayout layout = delegate.getImageLayout(this.referenceName);
            List<CoverageView.CoverageBand> bands = coverageView.getCoverageBands();
            SampleModel originalSampleModel = layout.getSampleModel(null);
            SampleModel sampleModel = RasterFactory.createBandedSampleModel((int)originalSampleModel.getDataType(), (int)originalSampleModel.getWidth(), (int)originalSampleModel.getHeight(), (int)bands.size());
            ColorModel colorModel = ImageIOUtilities.createColorModel((SampleModel)sampleModel);
            this.imageLayout = new ImageLayout2(layout.getMinX(null), layout.getMinY(null), originalSampleModel.getWidth(), originalSampleModel.getHeight());
            this.imageLayout.setSampleModel(sampleModel);
            this.imageLayout.setColorModel(colorModel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        List<CoverageView.CoverageBand> bands = this.coverageView.getCoverageBands();
        ArrayList<GridCoverage2D> coverages = new ArrayList<GridCoverage2D>();
        ArrayList<GridSampleDimension> dims = new ArrayList<GridSampleDimension>();
        CoveragesConsistencyChecker checker = null;
        for (CoverageView.CoverageBand band : bands) {
            GridCoverage2D coverage;
            CoverageView.InputCoverageBand inputBand = band.getInputCoverageBands().get(0);
            String coverageName = inputBand.getCoverageName();
            GridCoverage2DReader reader = CoverageViewReader.wrap(this.delegate, coverageName, this.coverageInfo);
            if (checker == null) {
                checker = new CoveragesConsistencyChecker(reader);
            } else {
                checker.checkConsistency(reader);
            }
            if ((coverage = reader.read(parameters)) == null) continue;
            String selectedBand = inputBand.getBand();
            ParameterValueGroup param = PROCESSOR.getOperation("SelectSampleDimension").getParameters();
            param.parameter("Source").setValue((Object)coverage);
            param.parameter("SampleDimensions").setValue((Object)new int[]{Integer.valueOf(selectedBand)});
            coverage = (GridCoverage2D)PROCESSOR.doOperation(param, this.hints);
            coverages.add(coverage);
            dims.addAll(Arrays.asList(coverage.getSampleDimensions()));
        }
        if (coverages.isEmpty()) {
            return null;
        }
        GridCoverage2D sampleCoverage = (GridCoverage2D)coverages.get(0);
        RenderedImage image = null;
        Map properties = null;
        if (coverages.size() > 1) {
            ParameterValueGroup param = PROCESSOR.getOperation("BandMerge").getParameters();
            param.parameter("sources").setValue(coverages);
            GridCoverage2D merge = (GridCoverage2D)PROCESSOR.doOperation(param, this.hints);
            image = merge.getRenderedImage();
            properties = merge.getProperties();
        } else {
            properties = sampleCoverage.getProperties();
            image = sampleCoverage.getRenderedImage();
        }
        GridSampleDimension[] sampleDimensions = dims.toArray(new GridSampleDimension[dims.size()]);
        GridCoverage2D mergedCoverage = this.coverageFactory.create((CharSequence)this.coverageInfo.getName(), image, sampleCoverage.getGridGeometry(), sampleDimensions, null, properties);
        return new CoverageDimensionCustomizerReader.GridCoverageWrapper(this.coverageInfo.getName(), mergedCoverage, sampleDimensions, mergedCoverage.getProperties());
    }

    protected void checkCoverageName(String coverageName) {
        if (!this.coverageName.equalsIgnoreCase(coverageName)) {
            throw new IllegalArgumentException("The specified coverageName isn't the one of this coverageView");
        }
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    private static GridCoverage2DReader wrap(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
        GridCoverage2DReader reader = delegate;
        if (coverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(delegate, coverageName);
        }
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new CoverageDimensionCustomizerViewStructuredReader((GridCoverage2DReader)((StructuredGridCoverage2DReader)reader), coverageName, info);
        }
        return new CoverageDimensionCustomizerViewReader(reader, coverageName, info);
    }

    public static GridCoverage2DReader wrap(GridCoverage2DReader reader, CoverageView coverageView, CoverageInfo coverageInfo, Hints hints) {
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new StructuredCoverageViewReader((StructuredGridCoverage2DReader)reader, coverageView, coverageInfo, hints);
        }
        return new CoverageViewReader(reader, coverageView, coverageInfo, hints);
    }

    public Format getFormat() {
        return this.delegate.getFormat();
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public String[] listSubNames() throws IOException {
        return this.delegate.listSubNames();
    }

    public String[] getGridCoverageNames() throws IOException {
        return this.delegate.getGridCoverageNames();
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public String getCurrentSubname() throws IOException {
        return this.delegate.getCurrentSubname();
    }

    public boolean hasMoreGridCoverages() throws IOException {
        return this.delegate.hasMoreGridCoverages();
    }

    public void skip() throws IOException {
        this.delegate.skip();
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalEnvelope(this.referenceName);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridRange(this.referenceName);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridToWorld(this.referenceName, pixInCell);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IOException {
        this.checkCoverageName(coverageName);
        return this.read(parameters);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(this.referenceName, policy, requestedResolution);
    }

    public int getNumOverviews(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getNumOverviews(this.referenceName);
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.imageLayout;
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.imageLayout;
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getResolutionLevels(this.referenceName);
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames(this.referenceName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(this.referenceName, name);
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.delegate.getOriginalEnvelope(this.referenceName);
    }

    public GridEnvelope getOriginalGridRange() {
        return this.delegate.getOriginalGridRange(this.referenceName);
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.delegate.getOriginalGridToWorld(this.referenceName, pixInCell);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem(this.referenceName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters(this.referenceName);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.delegate.getReadingResolutions(this.referenceName, policy, requestedResolution);
    }

    public int getNumOverviews() {
        return this.delegate.getNumOverviews(this.referenceName);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.delegate.getResolutionLevels(this.referenceName);
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.delegate.getDatasetLayout(coverageName);
    }

    static class CoverageDimensionCustomizerViewStructuredReader
    extends CoverageDimensionCustomizerViewReader {
        public CoverageDimensionCustomizerViewStructuredReader(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
            super(delegate, coverageName, info);
        }
    }

    static class CoverageDimensionCustomizerViewReader
    extends CoverageDimensionCustomizerReader {
        public CoverageDimensionCustomizerViewReader(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
            super(delegate, coverageName, info);
        }

        @Override
        protected GridSampleDimension[] wrapDimensions(SampleDimension[] dims) {
            GridSampleDimension[] wrappedDims = null;
            CoverageInfo info = this.getInfo();
            if (info != null) {
                List<CoverageDimensionInfo> storedDimensions = info.getDimensions();
                MetadataMap map = info.getMetadata();
                if (map.containsKey(CoverageView.COVERAGE_VIEW)) {
                    CoverageView coverageView = (CoverageView)map.get(CoverageView.COVERAGE_VIEW);
                    List<CoverageView.CoverageBand> coverageBands = coverageView.getBands(this.getCoverageName());
                    wrappedDims = coverageBands != null && !coverageBands.isEmpty() ? new GridSampleDimension[coverageBands.size()] : null;
                    int i = 0;
                    for (CoverageView.CoverageBand band : coverageBands) {
                        CoverageDimensionInfo dimensionInfo;
                        if (storedDimensions != null && storedDimensions.size() > 0) {
                            dimensionInfo = storedDimensions.get(band.getIndex());
                            wrappedDims[i] = new CoverageDimensionCustomizerReader.WrappedSampleDimension((GridSampleDimension)dims[i], dimensionInfo);
                        } else {
                            dimensionInfo = new CoverageDimensionImpl();
                            dimensionInfo.setName(band.getDefinition());
                            wrappedDims[i] = new CoverageDimensionCustomizerReader.WrappedSampleDimension((GridSampleDimension)dims[i], dimensionInfo);
                        }
                        ++i;
                    }
                } else {
                    super.wrapDimensions((SampleDimension[])wrappedDims);
                }
            }
            return wrappedDims;
        }
    }

    static class CoveragesConsistencyChecker {
        private static double DELTA = 1.0E-10;
        private Set<ParameterDescriptor<List>> dynamicParameters;
        private String[] metadataNames;
        private GridEnvelope gridRange;
        private GeneralEnvelope envelope;
        private CoordinateReferenceSystem crs;
        private ImageLayout layout;

        public CoveragesConsistencyChecker(GridCoverage2DReader reader) throws IOException {
            this.envelope = reader.getOriginalEnvelope();
            this.gridRange = reader.getOriginalGridRange();
            this.crs = reader.getCoordinateReferenceSystem();
            this.metadataNames = reader.getMetadataNames();
            this.dynamicParameters = reader.getDynamicParameters();
            this.layout = reader.getImageLayout();
        }

        public void checkConsistency(GridCoverage2DReader reader) throws IOException {
            Rectangle thatRectangle;
            GeneralEnvelope envelope = reader.getOriginalEnvelope();
            GridEnvelope gridRange = reader.getOriginalGridRange();
            CoordinateReferenceSystem crs = reader.getCoordinateReferenceSystem();
            String[] metadataNames = reader.getMetadataNames();
            Set dynamicParameters = reader.getDynamicParameters();
            if (!envelope.equals((Envelope)this.envelope, DELTA, true)) {
                throw new IllegalArgumentException("The coverage envelope must be the same");
            }
            Rectangle thisRectangle = new Rectangle(this.gridRange.getLow(0), this.gridRange.getLow(1), this.gridRange.getSpan(0), this.gridRange.getSpan(1));
            if (!thisRectangle.equals(thatRectangle = new Rectangle(gridRange.getLow(0), gridRange.getLow(1), gridRange.getSpan(0), gridRange.getSpan(1)))) {
                throw new IllegalArgumentException("The coverage gridRange should be the same");
            }
            if (metadataNames.length != this.metadataNames.length) {
                throw new IllegalArgumentException("The coverage metadataNames should have the same size");
            }
            HashSet<String> metadataSet = new HashSet<String>(Arrays.asList(metadataNames));
            for (String metadataName : this.metadataNames) {
                if (metadataSet.contains(metadataName)) continue;
                throw new IllegalArgumentException("The coverage metadata are different");
            }
            MathTransform destinationToSourceTransform = null;
            if (!CRS.equalsIgnoreMetadata((Object)crs, (Object)this.crs)) {
                try {
                    destinationToSourceTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)this.crs, (boolean)true);
                }
                catch (FactoryException e) {
                    throw new DataSourceException("Unable to inspect request CRS", (Throwable)e);
                }
            }
            if (destinationToSourceTransform != null && !destinationToSourceTransform.isIdentity()) {
                throw new IllegalArgumentException("The coverage coordinateReferenceSystem should be the same");
            }
            if (this.layout.getSampleModel(null).getDataType() != this.layout.getSampleModel(null).getDataType()) {
                throw new IllegalArgumentException("The coverage dataType should be the same");
            }
        }
    }
}

