/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.util.Utilities;

public class CoverageView
implements Serializable {
    private static final long serialVersionUID = 5504720319141832424L;
    public static final String BAND_SEPARATOR = "@";
    public static String COVERAGE_VIEW = "COVERAGE_VIEW";
    private List<CoverageBand> coverageBands;
    private String name;

    public String toString() {
        StringBuilder output = new StringBuilder("CoverageView name=").append(this.name);
        output.append("\n\tBands");
        for (CoverageBand band : this.coverageBands) {
            output.append("\t").append(band.toString());
        }
        return output.toString();
    }

    public CoverageView() {
    }

    public CoverageView(String name, List<CoverageBand> coverageBands) {
        this.name = name;
        this.coverageBands = coverageBands;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<CoverageBand> getCoverageBands() {
        return this.coverageBands;
    }

    public void setCoverageBands(List<CoverageBand> coverageBands) {
        this.coverageBands = coverageBands;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.coverageBands == null ? 0 : this.coverageBands.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CoverageView other = (CoverageView)obj;
        if (this.coverageBands == null ? other.coverageBands != null : !this.coverageBands.equals(other.coverageBands)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    private CoverageInfo buildCoverageInfo(CatalogBuilder builder, CoverageStoreInfo storeInfo, CoverageInfo cinfo, String name) throws Exception {
        Catalog catalog = storeInfo.getCatalog();
        cinfo.setStore(storeInfo);
        cinfo.getMetadata().put(COVERAGE_VIEW, this);
        cinfo.setName(name);
        cinfo.setNativeCoverageName(name);
        GridCoverage2DReader reader = (GridCoverage2DReader)catalog.getResourcePool().getGridCoverageReader(cinfo, name, null);
        builder.setStore(storeInfo);
        return builder.buildCoverage(reader, name, null);
    }

    public CoverageInfo createCoverageInfo(String name, CoverageStoreInfo storeInfo, CatalogBuilder builder) throws Exception {
        Catalog catalog = storeInfo.getCatalog();
        CoverageInfo coverageInfo = catalog.getFactory().createCoverage();
        CoverageInfo info = this.buildCoverageInfo(builder, storeInfo, coverageInfo, name);
        info.getMetadata().put(COVERAGE_VIEW, this);
        info.setName(name);
        info.setNativeCoverageName(name);
        return info;
    }

    public void updateCoverageInfo(String name, CoverageStoreInfo storeInfo, CatalogBuilder builder, CoverageInfo coverageInfo) throws Exception {
        Utilities.ensureNonNull((String)"coverageInfo", (Object)coverageInfo);
        coverageInfo.getDimensions().clear();
        CoverageInfo info = this.buildCoverageInfo(builder, storeInfo, coverageInfo, name);
        coverageInfo.getMetadata().put(COVERAGE_VIEW, this);
        coverageInfo.getDimensions().addAll(info.getDimensions());
    }

    public CoverageBand getBand(int index) {
        return this.coverageBands.get(index);
    }

    public List<CoverageBand> getBands(String coverageName) {
        ArrayList<CoverageBand> bands = new ArrayList<CoverageBand>();
        for (CoverageBand coverageBand : this.coverageBands) {
            for (InputCoverageBand inputBand : coverageBand.getInputCoverageBands()) {
                if (!inputBand.getCoverageName().equalsIgnoreCase(coverageName)) continue;
                bands.add(coverageBand);
            }
        }
        return bands;
    }

    public int getSize() {
        return this.coverageBands != null ? this.coverageBands.size() : 0;
    }

    public static class CoverageBand
    implements Serializable {
        private static final long serialVersionUID = -7223081117287911988L;
        private List<InputCoverageBand> inputCoverageBands;
        private String definition;
        private int index;
        private CompositionType compositionType;

        public CoverageBand() {
        }

        public CoverageBand(List<InputCoverageBand> inputCoverageBands, String definition, int index, CompositionType compositionType) {
            this.inputCoverageBands = inputCoverageBands;
            this.definition = definition;
            this.index = index;
            this.compositionType = compositionType;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.compositionType == null ? 0 : this.compositionType.hashCode());
            result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CoverageBand other = (CoverageBand)obj;
            if (this.compositionType != other.compositionType) {
                return false;
            }
            return !(this.definition == null ? other.definition != null : !this.definition.equals(other.definition));
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("OutputBand\n   inputCoverageBands=");
            for (InputCoverageBand inputBand : this.inputCoverageBands) {
                sb.append("[").append(inputBand).append("]");
            }
            sb.append(", definition=").append(this.definition).append(", index=").append(this.index).append(", compositionType=").append((Object)this.compositionType);
            return sb.toString();
        }

        public String getDefinition() {
            return this.definition;
        }

        public void setDefinition(String definition) {
            this.definition = definition;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public CompositionType getCompositionType() {
            return this.compositionType;
        }

        public void setCompositionType(CompositionType compositionType) {
            this.compositionType = compositionType;
        }

        public List<InputCoverageBand> getInputCoverageBands() {
            return this.inputCoverageBands;
        }

        public void setInputCoverageBands(List<InputCoverageBand> inputCoverageBands) {
            this.inputCoverageBands = inputCoverageBands;
        }
    }

    public static class InputCoverageBand
    implements Serializable {
        private static final long serialVersionUID = -2200641260788001394L;
        private String coverageName;
        private String band;

        public InputCoverageBand() {
        }

        public String toString() {
            return "InputCoverageBand [coverageName=" + this.coverageName + ", band=" + this.band + "]";
        }

        public InputCoverageBand(String coverageName, String band) {
            this.coverageName = coverageName;
            this.band = band;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.band == null ? 0 : this.band.hashCode());
            result = 31 * result + (this.coverageName == null ? 0 : this.coverageName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            InputCoverageBand other = (InputCoverageBand)obj;
            if (this.band == null ? other.band != null : !this.band.equals(other.band)) {
                return false;
            }
            return !(this.coverageName == null ? other.coverageName != null : !this.coverageName.equals(other.coverageName));
        }

        public String getCoverageName() {
            return this.coverageName;
        }

        public void setCoverageName(String coverageName) {
            this.coverageName = coverageName;
        }

        public String getBand() {
            return this.band;
        }

        public void setBand(String band) {
            this.band = band;
        }
    }

    public static enum CompositionType {
        BAND_SELECT{

            @Override
            public String displayValue() {
                return CompositionType.BAND_SELECTION_STRING;
            }
        };

        static final String BAND_SELECTION_STRING = "Band Selection";

        public static CompositionType getDefault() {
            return BAND_SELECT;
        }

        public abstract String displayValue();

        public String toValue() {
            return this.toString();
        }
    }
}

