/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import it.geosolutions.imageio.maskband.DatasetLayout;
import it.geosolutions.jaiext.range.NoDataContainer;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.measure.unit.Unit;
import javax.media.jai.ImageLayout;
import javax.media.jai.PropertySource;
import javax.media.jai.PropertySourceImpl;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageDimensionInfo;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.SingleGridCoverage2DReader;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.io.DimensionDescriptor;
import org.geotools.coverage.grid.io.GranuleSource;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.HarvestedSource;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.coverage.grid.io.StructuredGridCoverage2DReader;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.resources.Classes;
import org.geotools.resources.coverage.CoverageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.Utilities;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.ColorInterpretation;
import org.opengis.coverage.PaletteInterpretation;
import org.opengis.coverage.SampleDimension;
import org.opengis.coverage.SampleDimensionType;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageReader;
import org.opengis.coverage.grid.GridEnvelope;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.InternationalString;

public class CoverageDimensionCustomizerReader
implements GridCoverage2DReader {
    private static Logger LOGGER = Logging.getLogger(CoverageDimensionCustomizerReader.class);
    static final String LINE_SEPARATOR = System.getProperty("line.separator", "\n");
    private CoverageInfo info;
    private GridCoverage2DReader delegate;
    private String coverageName;

    public static GridCoverageReader wrap(GridCoverage2DReader delegate, String coverageName, CoverageStoreInfo info) {
        GridCoverage2DReader reader = delegate;
        if (coverageName != null) {
            reader = SingleGridCoverage2DReader.wrap(delegate, coverageName);
        }
        if (reader instanceof StructuredGridCoverage2DReader) {
            return new CoverageDimensionCustomizerStructuredReader((StructuredGridCoverage2DReader)reader, coverageName, info);
        }
        return new CoverageDimensionCustomizerReader(reader, coverageName, info);
    }

    public CoverageDimensionCustomizerReader(GridCoverage2DReader delegate, String coverageName, CoverageStoreInfo storeInfo) {
        this.delegate = delegate;
        this.coverageName = coverageName;
        this.info = this.getCoverageInfo(storeInfo);
    }

    public CoverageDimensionCustomizerReader(GridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
        this.delegate = delegate;
        this.coverageName = coverageName;
        this.info = info;
    }

    private CoverageInfo getCoverageInfo(CoverageStoreInfo storeInfo) {
        Utilities.ensureNonNull((String)"storeInfo", (Object)storeInfo);
        Catalog catalog = storeInfo.getCatalog();
        if (this.coverageName != null) {
            this.info = catalog.getCoverageByName(this.coverageName);
        }
        if (this.info == null) {
            List<CoverageInfo> coverages = catalog.getCoveragesByStore(storeInfo);
            if (this.coverageName != null) {
                for (CoverageInfo coverage : coverages) {
                    if (!coverage.getNativeName().equalsIgnoreCase(this.coverageName)) continue;
                    this.info = coverage;
                    break;
                }
            }
            if (this.info == null && coverages != null && coverages.size() == 1) {
                this.info = coverages.get(0);
            }
        }
        return this.info;
    }

    public String getCoverageName() {
        return this.coverageName;
    }

    public CoverageInfo getInfo() {
        return this.info;
    }

    public GridCoverage2D read(GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        return this.read(this.coverageName, parameters);
    }

    public GridCoverage2D read(String coverageName, GeneralParameterValue[] parameters) throws IllegalArgumentException, IOException {
        double[] wrappedNoDataValues;
        GridCoverage2D coverage;
        GridCoverage2D gridCoverage2D = coverage = coverageName != null ? this.delegate.read(coverageName, parameters) : this.delegate.read(parameters);
        if (coverage == null) {
            return coverage;
        }
        Map properties = coverage.getProperties();
        GridSampleDimension[] dims = coverage.getSampleDimensions();
        GridSampleDimension[] wrappedDims = this.wrapDimensions((SampleDimension[])dims);
        NoDataContainer noDataProperty = CoverageUtilities.getNoDataProperty((GridCoverage2D)coverage);
        if (wrappedDims == null) {
            wrappedDims = dims;
        } else if (properties != null && noDataProperty != null && (wrappedNoDataValues = wrappedDims[0].getNoDataValues()) != null && wrappedNoDataValues.length > 0) {
            CoverageUtilities.setNoDataProperty((Map)properties, (Object)wrappedNoDataValues[0]);
        }
        return new GridCoverageWrapper(coverageName, coverage, wrappedDims, properties);
    }

    protected GridSampleDimension[] wrapDimensions(SampleDimension[] dims) {
        GridSampleDimension[] wrappedDims = null;
        if (this.info != null) {
            List<CoverageDimensionInfo> storedDimensions = this.info.getDimensions();
            MetadataMap map = this.info.getMetadata();
            if (storedDimensions != null && storedDimensions.size() > 0) {
                int i = 0;
                int inputDims = storedDimensions.size();
                int outputDims = dims.length;
                wrappedDims = new GridSampleDimension[outputDims];
                for (SampleDimension dim : dims) {
                    wrappedDims[i] = new WrappedSampleDimension((GridSampleDimension)dim, storedDimensions.get(outputDims != inputDims ? (i > inputDims - 1 ? inputDims - 1 : i) : i));
                    ++i;
                }
            }
        }
        return wrappedDims;
    }

    public Format getFormat() {
        return this.delegate.getFormat();
    }

    public Object getSource() {
        return this.delegate.getSource();
    }

    public String[] getMetadataNames() throws IOException {
        return this.delegate.getMetadataNames();
    }

    public String[] getMetadataNames(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataNames(coverageName);
    }

    public String getMetadataValue(String name) throws IOException {
        return this.delegate.getMetadataValue(name);
    }

    public String getMetadataValue(String coverageName, String name) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getMetadataValue(coverageName, name);
    }

    public String[] listSubNames() throws IOException {
        return this.delegate.listSubNames();
    }

    public String getCurrentSubname() throws IOException {
        return this.delegate.getCurrentSubname();
    }

    public boolean hasMoreGridCoverages() throws IOException {
        return this.delegate.hasMoreGridCoverages();
    }

    public void skip() throws IOException {
        this.delegate.skip();
    }

    public void dispose() throws IOException {
        this.delegate.dispose();
    }

    public GeneralEnvelope getOriginalEnvelope() {
        return this.delegate.getOriginalEnvelope();
    }

    public GeneralEnvelope getOriginalEnvelope(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalEnvelope(coverageName);
    }

    public GridEnvelope getOriginalGridRange() {
        return this.delegate.getOriginalGridRange();
    }

    public GridEnvelope getOriginalGridRange(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridRange(coverageName);
    }

    public MathTransform getOriginalGridToWorld(PixelInCell pixInCell) {
        return this.delegate.getOriginalGridToWorld(pixInCell);
    }

    public MathTransform getOriginalGridToWorld(String coverageName, PixelInCell pixInCell) {
        this.checkCoverageName(coverageName);
        return this.delegate.getOriginalGridToWorld(coverageName, pixInCell);
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem() {
        return this.delegate.getCoordinateReferenceSystem();
    }

    public CoordinateReferenceSystem getCoordinateReferenceSystem(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getCoordinateReferenceSystem(coverageName);
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters() throws IOException {
        return this.delegate.getDynamicParameters();
    }

    public Set<ParameterDescriptor<List>> getDynamicParameters(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getDynamicParameters(coverageName);
    }

    public double[] getReadingResolutions(OverviewPolicy policy, double[] requestedResolution) throws IOException {
        return this.delegate.getReadingResolutions(policy, requestedResolution);
    }

    public double[] getReadingResolutions(String coverageName, OverviewPolicy policy, double[] requestedResolution) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getReadingResolutions(coverageName, policy, requestedResolution);
    }

    public String[] getGridCoverageNames() throws IOException {
        return this.delegate.getGridCoverageNames();
    }

    public int getGridCoverageCount() throws IOException {
        return this.delegate.getGridCoverageCount();
    }

    public int getNumOverviews() {
        return this.delegate.getNumOverviews();
    }

    public int getNumOverviews(String coverageName) {
        this.checkCoverageName(coverageName);
        return this.delegate.getNumOverviews(coverageName);
    }

    public ImageLayout getImageLayout() throws IOException {
        return this.delegate.getImageLayout();
    }

    public ImageLayout getImageLayout(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getImageLayout(coverageName);
    }

    public double[][] getResolutionLevels() throws IOException {
        return this.delegate.getResolutionLevels();
    }

    public double[][] getResolutionLevels(String coverageName) throws IOException {
        this.checkCoverageName(coverageName);
        return this.delegate.getResolutionLevels(coverageName);
    }

    protected void checkCoverageName(String coverageName) {
        if (this.coverageName != null && !this.coverageName.equals(coverageName)) {
            throw new IllegalArgumentException("Unkonwn coverage named " + coverageName + ", the only valid value is: " + this.coverageName);
        }
    }

    public DatasetLayout getDatasetLayout() {
        return this.delegate.getDatasetLayout();
    }

    public DatasetLayout getDatasetLayout(String coverageName) {
        return this.delegate.getDatasetLayout(coverageName);
    }

    static class WrappedSampleDimension
    extends GridSampleDimension
    implements SampleDimension {
        private GridSampleDimension sampleDim;
        private List<Category> customCategories;
        private double[] configuredNoDataValues;
        private Unit<?> configuredUnit;
        private NumberRange<? extends Number> configuredRange;
        private String name;
        private InternationalString configuredDescription;

        public SampleDimensionType getSampleDimensionType() {
            return this.sampleDim.getSampleDimensionType();
        }

        public InternationalString getDescription() {
            return this.configuredDescription;
        }

        public InternationalString[] getCategoryNames() throws IllegalStateException {
            return this.sampleDim.getCategoryNames();
        }

        public List<Category> getCategories() {
            return this.customCategories;
        }

        public Category getCategory(double sample) {
            return this.sampleDim.getCategory(sample);
        }

        public double[] getNoDataValues() throws IllegalStateException {
            return this.configuredNoDataValues;
        }

        public double getMinimumValue() {
            NumberRange<? extends Number> range = this.getRange();
            if (range != null) {
                return range.getMinimum();
            }
            return this.sampleDim.getMinimumValue();
        }

        public double getMaximumValue() {
            NumberRange<? extends Number> range = this.getRange();
            if (range != null) {
                return range.getMaximum();
            }
            return this.sampleDim.getMaximumValue();
        }

        public NumberRange<? extends Number> getRange() {
            return this.configuredRange;
        }

        public String getLabel(double value, Locale locale) {
            return this.sampleDim.getLabel(value, locale);
        }

        public Unit<?> getUnits() {
            return this.configuredUnit;
        }

        public double getOffset() throws IllegalStateException {
            return this.sampleDim.getOffset();
        }

        public double getScale() {
            return this.sampleDim.getScale();
        }

        public int[][] getPalette() {
            return this.sampleDim.getPalette();
        }

        public PaletteInterpretation getPaletteInterpretation() {
            return this.sampleDim.getPaletteInterpretation();
        }

        public ColorInterpretation getColorInterpretation() {
            return this.sampleDim.getColorInterpretation();
        }

        public ColorModel getColorModel() {
            return this.sampleDim.getColorModel();
        }

        public ColorModel getColorModel(int visibleBand, int numBands) {
            return this.sampleDim.getColorModel(visibleBand, numBands);
        }

        public ColorModel getColorModel(int visibleBand, int numBands, int type) {
            return this.sampleDim.getColorModel(visibleBand, numBands, type);
        }

        public int hashCode() {
            return this.sampleDim.hashCode();
        }

        public boolean equals(Object object) {
            return this.sampleDim.equals(object);
        }

        private StringBuilder formatRange(StringBuilder builder, Locale locale) {
            NumberRange<? extends Number> range = this.getRange();
            builder.append('[');
            if (range != null) {
                builder.append(range.getMinimum()).append(" ... ").append(range.getMaximum());
            } else {
                Unit<?> unit = this.getUnits();
                if (unit != null) {
                    builder.append(unit);
                }
            }
            builder.append(']');
            return builder;
        }

        public String toString() {
            if (this.customCategories != null) {
                StringBuilder builder = new StringBuilder(Classes.getShortClassName((Object)((Object)this)));
                builder.append('(');
                builder = this.formatRange(builder, null);
                builder.append(')').append(LINE_SEPARATOR);
                for (Category category : this.customCategories) {
                    builder.append("  ").append(' ').append(' ').append(category).append(LINE_SEPARATOR);
                }
                return builder.toString();
            }
            return this.sampleDim.toString();
        }

        public WrappedSampleDimension(GridSampleDimension sampleDim, CoverageDimensionInfo info) {
            boolean nodataConfigured;
            Unit unit;
            List categories;
            block9: {
                Unit defaultUnit;
                super(sampleDim);
                this.name = info.getName();
                InternationalString sampleDimDescription = sampleDim.getDescription();
                this.configuredDescription = sampleDimDescription == null || !sampleDimDescription.toString().equalsIgnoreCase(this.name) ? new SimpleInternationalString(this.name) : sampleDimDescription;
                this.sampleDim = sampleDim;
                categories = sampleDim.getCategories();
                this.configuredRange = info.getRange();
                this.customCategories = categories;
                String uom = info.getUnit();
                unit = defaultUnit = sampleDim.getUnits();
                try {
                    if (uom != null) {
                        unit = Unit.valueOf((CharSequence)uom);
                    }
                }
                catch (IllegalArgumentException iae) {
                    if (!LOGGER.isLoggable(Level.WARNING) || defaultUnit == null) break block9;
                    LOGGER.warning("Unable to parse the specified unit (" + uom + "). Using the previous one: " + defaultUnit.toString());
                }
            }
            this.configuredUnit = unit;
            List<Double> nullValues = info.getNullValues();
            if (nullValues != null && nullValues.size() > 0) {
                int size = nullValues.size();
                this.configuredNoDataValues = new double[size];
                for (int i = 0; i < size; ++i) {
                    this.configuredNoDataValues[i] = nullValues.get(i);
                }
            } else {
                this.configuredNoDataValues = sampleDim.getNoDataValues();
            }
            boolean bl = nodataConfigured = this.configuredNoDataValues != null && this.configuredNoDataValues.length > 0;
            if (categories != null) {
                this.customCategories = new ArrayList<Category>(categories.size());
                Category wrapped = null;
                Iterator i$ = categories.iterator();
                while (i$.hasNext()) {
                    Category category;
                    wrapped = category = (Category)i$.next();
                    if (Category.NODATA.getName().equals(category.getName()) && category.isQuantitative()) {
                        double minimum = nodataConfigured ? this.configuredNoDataValues[0] : category.getRange().getMinimum();
                        double maximum = nodataConfigured ? this.configuredNoDataValues[0] : category.getRange().getMaximum();
                        wrapped = Double.isNaN(minimum) && Double.isNaN(maximum) ? new Category((CharSequence)Category.NODATA.getName(), category.getColors()[0], minimum) : new Category((CharSequence)Category.NODATA.getName(), category.getColors(), NumberRange.create((double)minimum, (double)maximum));
                    }
                    this.customCategories.add(wrapped);
                }
            }
        }

        private void parseUOM(StringBuilder label, Unit uom) {
            String uomString = uom.toString();
            uomString = uomString.replaceAll("\u00b2", "^2");
            uomString = uomString.replaceAll("\u00b3", "^3");
            uomString = uomString.replaceAll("\u212b", "A");
            uomString = uomString.replaceAll("\ufffd", "");
            label.append(uomString);
        }

        private void buildDescription() {
            StringBuilder label = new StringBuilder("GridSampleDimension".intern());
            Unit uom = this.sampleDim.getUnits();
            String uName = this.name.toUpperCase();
            if (uom != null) {
                label.append("(".intern());
                this.parseUOM(label, uom);
                label.append(")".intern());
            }
            label.append("[".intern());
            label.append(this.getMinimumValue());
            label.append(",".intern());
            label.append(this.getMaximumValue());
            label.append("]".intern());
            this.configuredDescription = new SimpleInternationalString(label.toString());
        }
    }

    public static class GridCoverageWrapper
    extends GridCoverage2D {
        private PropertySourceImpl wrappedPropertySource;
        private GridSampleDimension[] wrappedSampleDimensions;

        public GridCoverageWrapper(String name, GridCoverage2D coverage, GridSampleDimension[] sampleDimensions, Map properties) {
            super((CharSequence)name, coverage);
            this.wrappedSampleDimensions = sampleDimensions;
            this.wrappedPropertySource = new PropertySourceImpl(properties, (PropertySource)(coverage instanceof PropertySource ? coverage : null));
        }

        public GridSampleDimension getSampleDimension(int index) {
            return this.wrappedSampleDimensions[index];
        }

        public GridSampleDimension[] getSampleDimensions() {
            return (GridSampleDimension[])this.wrappedSampleDimensions.clone();
        }

        public Map getProperties() {
            return this.wrappedPropertySource.getProperties();
        }

        public Object getProperty(String arg0) {
            return this.wrappedPropertySource.getProperty(arg0);
        }

        public static GridCoverage2D wrapCoverage(GridCoverage2D coverage, GridCoverage2D sourceCoverage, GridSampleDimension[] wrappedDimensions, Map properties, boolean forceWrapping) {
            if (coverage instanceof GridCoverageWrapper || forceWrapping) {
                return new GridCoverageWrapper(coverage.getName().toString(), coverage, wrappedDimensions == null ? coverage.getSampleDimensions() : wrappedDimensions, properties == null ? sourceCoverage.getProperties() : properties);
            }
            return coverage;
        }
    }

    static class CoverageDimensionCustomizerStructuredReader
    extends CoverageDimensionCustomizerReader
    implements StructuredGridCoverage2DReader {
        private StructuredGridCoverage2DReader structuredDelegate;

        public CoverageDimensionCustomizerStructuredReader(StructuredGridCoverage2DReader delegate, String coverageName, CoverageInfo info) {
            super((GridCoverage2DReader)delegate, coverageName, info);
            this.structuredDelegate = delegate;
        }

        public CoverageDimensionCustomizerStructuredReader(StructuredGridCoverage2DReader delegate, String coverageName, CoverageStoreInfo storeInfo) {
            super((GridCoverage2DReader)delegate, coverageName, storeInfo);
            this.structuredDelegate = delegate;
        }

        public GranuleSource getGranules(String coverageName, boolean readOnly) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.getGranules(coverageName, readOnly);
        }

        public boolean isReadOnly() {
            return this.structuredDelegate.isReadOnly();
        }

        public void createCoverage(String coverageName, SimpleFeatureType schema) throws IOException, UnsupportedOperationException {
            this.structuredDelegate.createCoverage(coverageName, schema);
        }

        public boolean removeCoverage(String coverageName) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.removeCoverage(coverageName);
        }

        public boolean removeCoverage(String coverageName, boolean delete) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.removeCoverage(coverageName, delete);
        }

        public void delete(boolean deleteData) throws IOException {
            this.structuredDelegate.delete(deleteData);
        }

        public List<HarvestedSource> harvest(String defaultTargetCoverage, Object source, Hints hints) throws IOException, UnsupportedOperationException {
            return this.structuredDelegate.harvest(defaultTargetCoverage, source, hints);
        }

        public List<DimensionDescriptor> getDimensionDescriptors(String coverageName) throws IOException {
            return this.structuredDelegate.getDimensionDescriptors(coverageName);
        }
    }
}

