/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.jaiext.interpolators;

import it.geosolutions.jaiext.interpolators.InterpolationNoData;
import it.geosolutions.jaiext.range.Range;
import java.awt.Rectangle;
import javax.media.jai.Interpolation;
import javax.media.jai.RasterAccessor;
import javax.media.jai.iterator.RandomIter;

public class InterpolationBilinear
extends Interpolation
implements InterpolationNoData {
    private static final long serialVersionUID = 5238694001611785385L;
    private int round;
    private int subsampleBits;
    private int shift2;
    private int round2;
    private Range noDataRange;
    private Rectangle roiBounds;
    private RandomIter roiIter;
    private boolean useROIAccessor;
    private double destinationNoData;
    private int black;
    private int dataType;
    private boolean isNotPointRange;
    public static final int DEFAULT_SUBSAMPLE_BITS = 8;

    public int interpolateH(int[] arg0, int xfrac) {
        return (arg0[1] - arg0[0]) * xfrac + (arg0[0] << this.subsampleBits) + this.round >> this.subsampleBits;
    }

    public float interpolateH(float[] arg0, float xfrac) {
        return (arg0[1] - arg0[0]) * xfrac + arg0[0];
    }

    public double interpolateH(double[] arg0, float xfrac) {
        return (arg0[1] - arg0[0]) * (double)xfrac + arg0[0];
    }

    public InterpolationBilinear(int subsampleBits, Range noDataRange, boolean useROIAccessor, double destinationNoData, int dataType) {
        super(2, 2, 0, 1, 0, 1, subsampleBits, subsampleBits);
        this.subsampleBits = subsampleBits;
        this.round = 1 << subsampleBits - 1;
        this.shift2 = 2 * subsampleBits;
        this.round2 = 1 << this.shift2 - 1;
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
        this.useROIAccessor = useROIAccessor;
        this.destinationNoData = destinationNoData;
        this.black = (int)destinationNoData & 1;
        this.dataType = dataType;
    }

    public void setROIdata(Rectangle roiBounds, RandomIter roiIter) {
        if (roiBounds != null && roiIter != null) {
            this.roiBounds = roiBounds;
            this.roiIter = roiIter;
        } else if (roiBounds == null && roiIter != null || roiBounds != null && roiIter == null) {
            throw new IllegalArgumentException("If roiBounds or roiIter are not null, so even the other must be not null");
        }
    }

    public double getDestinationNoData() {
        return this.destinationNoData;
    }

    public void setDestinationNoData(double destinationNoData) {
        this.destinationNoData = destinationNoData;
    }

    public boolean getUseROIAccessor() {
        return this.useROIAccessor;
    }

    public void setUseROIAccessor(boolean useROIAccessor) {
        this.useROIAccessor = useROIAccessor;
    }

    public Range getNoDataRange() {
        return this.noDataRange;
    }

    public void setNoDataRange(Range noDataRange) {
        if (noDataRange != null) {
            this.noDataRange = noDataRange;
            this.isNotPointRange = !noDataRange.isPoint();
        }
    }

    public int getDataType() {
        return this.dataType;
    }

    public Number interpolate(RasterAccessor src, int bandIndex, int dnumbands, int posX, int posY, Number[] fracValues, Integer yValueROI, RasterAccessor roi, boolean setNoData) {
        double w11d;
        double w10d;
        double w01d;
        double w00d;
        float w11f;
        float w10f;
        float w01f;
        float w00f;
        int w11;
        int w10;
        int w01;
        int w00;
        double yfracd;
        double xfracd;
        float yfracf;
        float xfracf;
        int yfrac;
        int xfrac;
        double s11d;
        double s10d;
        double s01d;
        double s00d;
        float s11f;
        float s10f;
        float s01f;
        float s00f;
        int s11;
        int s10;
        int s01;
        int s00;
        block64: {
            block65: {
                int y0;
                int posYlow;
                int posXlow;
                int srcBandOffset;
                int srcPixelStride;
                int srcScanLineStride;
                block63: {
                    int baseIndex;
                    if (setNoData) {
                        return this.destinationNoData;
                    }
                    srcScanLineStride = src.getScanlineStride();
                    srcPixelStride = src.getPixelStride();
                    srcBandOffset = src.getBandOffset(bandIndex);
                    posXlow = posX;
                    posYlow = posY;
                    int posXhigh = posX + srcPixelStride;
                    int posYhigh = posY + srcScanLineStride;
                    s00 = 0;
                    s01 = 0;
                    s10 = 0;
                    s11 = 0;
                    s00f = 0.0f;
                    s01f = 0.0f;
                    s10f = 0.0f;
                    s11f = 0.0f;
                    s00d = 0.0;
                    s01d = 0.0;
                    s10d = 0.0;
                    s11d = 0.0;
                    xfrac = 0;
                    yfrac = 0;
                    xfracf = 0.0f;
                    yfracf = 0.0f;
                    xfracd = 0.0;
                    yfracd = 0.0;
                    switch (this.dataType) {
                        case 0: {
                            byte[] srcDataByte = src.getByteDataArray(bandIndex);
                            s00 = srcDataByte[posXlow + posYlow] & 0xFF;
                            s01 = srcDataByte[posXhigh + posYlow] & 0xFF;
                            s10 = srcDataByte[posXlow + posYhigh] & 0xFF;
                            s11 = srcDataByte[posXhigh + posYhigh] & 0xFF;
                            xfrac = fracValues[0].intValue();
                            yfrac = fracValues[1].intValue();
                            break;
                        }
                        case 1: {
                            short[] srcDataShort = src.getShortDataArray(bandIndex);
                            s00 = srcDataShort[posXlow + posYlow] & 0xFFFF;
                            s01 = srcDataShort[posXhigh + posYlow] & 0xFFFF;
                            s10 = srcDataShort[posXlow + posYhigh] & 0xFFFF;
                            s11 = srcDataShort[posXhigh + posYhigh] & 0xFFFF;
                            xfrac = fracValues[0].intValue();
                            yfrac = fracValues[1].intValue();
                            break;
                        }
                        case 2: {
                            short[] srcDataShort = src.getShortDataArray(bandIndex);
                            s00 = srcDataShort[posXlow + posYlow];
                            s01 = srcDataShort[posXhigh + posYlow];
                            s10 = srcDataShort[posXlow + posYhigh];
                            s11 = srcDataShort[posXhigh + posYhigh];
                            xfrac = fracValues[0].intValue();
                            yfrac = fracValues[1].intValue();
                            break;
                        }
                        case 3: {
                            int[] srcDataInt = src.getIntDataArray(bandIndex);
                            s00 = srcDataInt[posXlow + posYlow];
                            s01 = srcDataInt[posXhigh + posYlow];
                            s10 = srcDataInt[posXlow + posYhigh];
                            s11 = srcDataInt[posXhigh + posYhigh];
                            xfrac = fracValues[0].intValue();
                            yfrac = fracValues[1].intValue();
                            break;
                        }
                        case 4: {
                            float[] srcDataFloat = src.getFloatDataArray(bandIndex);
                            s00f = srcDataFloat[posXlow + posYlow];
                            s01f = srcDataFloat[posXhigh + posYlow];
                            s10f = srcDataFloat[posXlow + posYhigh];
                            s11f = srcDataFloat[posXhigh + posYhigh];
                            xfracf = fracValues[0].floatValue();
                            yfracf = fracValues[1].floatValue();
                            break;
                        }
                        case 5: {
                            double[] srcDataDouble = src.getDoubleDataArray(bandIndex);
                            s00d = srcDataDouble[posXlow + posYlow];
                            s01d = srcDataDouble[posXhigh + posYlow];
                            s10d = srcDataDouble[posXlow + posYhigh];
                            s11d = srcDataDouble[posXhigh + posYhigh];
                            xfracd = fracValues[0].doubleValue();
                            yfracd = fracValues[1].doubleValue();
                            break;
                        }
                    }
                    w00 = 1;
                    w01 = 1;
                    w10 = 1;
                    w11 = 1;
                    w00f = 1.0f;
                    w01f = 1.0f;
                    w10f = 1.0f;
                    w11f = 1.0f;
                    w00d = 1.0;
                    w01d = 1.0;
                    w10d = 1.0;
                    w11d = 1.0;
                    if (!this.useROIAccessor) break block63;
                    if (yValueROI == null || roi == null) {
                        throw new IllegalArgumentException("If rasterAccessor is set, ROI value must be provided");
                    }
                    int roiScanLineStride = roi.getScanlineStride();
                    int w00index = baseIndex = posXlow / dnumbands + yValueROI;
                    int w01index = baseIndex + 1;
                    int w10index = baseIndex + roiScanLineStride;
                    int w11index = baseIndex + 1 + roiScanLineStride;
                    int roiDataLength = 0;
                    byte[] roiDataArrayByte = roi.getByteDataArray(0);
                    roiDataLength = roiDataArrayByte.length;
                    if (baseIndex > roiDataLength || roiDataArrayByte[w00index] == 0) {
                        return this.destinationNoData;
                    }
                    switch (this.dataType) {
                        case 0: {
                            w00 = w00index < roiDataLength ? roiDataArrayByte[w00index] & 0xFF : 0;
                            w01 = w01index < roiDataLength ? roiDataArrayByte[w01index] & 0xFF : 0;
                            w10 = w10index < roiDataLength ? roiDataArrayByte[w10index] & 0xFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArrayByte[w11index] & 0xFF : 0;
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                            return this.destinationNoData;
                        }
                        case 1: {
                            w00 = w00index < roiDataLength ? roiDataArrayByte[w00index] & 0xFFFF : 0;
                            w01 = w01index < roiDataLength ? roiDataArrayByte[w01index] & 0xFFFF : 0;
                            w10 = w10index < roiDataLength ? roiDataArrayByte[w10index] & 0xFFFF : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArrayByte[w11index] & 0xFFFF : 0;
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                            return this.destinationNoData;
                        }
                        case 2: 
                        case 3: {
                            w00 = w00index < roiDataLength ? roiDataArrayByte[w00index] : 0;
                            w01 = w01index < roiDataLength ? roiDataArrayByte[w01index] : 0;
                            w10 = w10index < roiDataLength ? roiDataArrayByte[w10index] : 0;
                            int n = w11 = w11index < roiDataLength ? roiDataArrayByte[w11index] : 0;
                            if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                            return this.destinationNoData;
                        }
                        case 4: {
                            w00f = w00index < roiDataLength ? (float)roiDataArrayByte[w00index] : 0.0f;
                            w01f = w01index < roiDataLength ? (float)roiDataArrayByte[w01index] : 0.0f;
                            w10f = w10index < roiDataLength ? (float)roiDataArrayByte[w10index] : 0.0f;
                            float f = w11f = w11index < roiDataLength ? (float)roiDataArrayByte[w11index] : 0.0f;
                            if (w00f != 0.0f || w01f != 0.0f || w10f != 0.0f || w11f != 0.0f) break;
                            return this.destinationNoData;
                        }
                        case 5: {
                            w00d = w00index < roiDataLength ? (double)roiDataArrayByte[w00index] : 0.0;
                            w01d = w01index < roiDataLength ? (double)roiDataArrayByte[w01index] : 0.0;
                            w10d = w10index < roiDataLength ? (double)roiDataArrayByte[w10index] : 0.0;
                            double d = w11d = w11index < roiDataLength ? (double)roiDataArrayByte[w11index] : 0.0;
                            if (w00d != 0.0 || w01d != 0.0 || w10d != 0.0 || w11d != 0.0) break;
                            return this.destinationNoData;
                        }
                    }
                    break block64;
                }
                if (this.roiBounds == null) break block64;
                int x0 = src.getX() + posXlow / srcPixelStride;
                if (!this.roiBounds.contains(x0, y0 = src.getY() + (posYlow - srcBandOffset) / srcScanLineStride)) break block65;
                switch (this.dataType) {
                    case 0: {
                        w00 = this.roiIter.getSample(x0, y0, 0) & 0xFF;
                        w01 = this.roiIter.getSample(x0 + 1, y0, 0) & 0xFF;
                        w10 = this.roiIter.getSample(x0, y0 + 1, 0) & 0xFF;
                        w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            return this.destinationNoData;
                        }
                        break block64;
                    }
                    case 1: {
                        w00 = this.roiIter.getSample(x0, y0, 0) & 0xFFFF;
                        w01 = this.roiIter.getSample(x0 + 1, y0, 0) & 0xFFFF;
                        w10 = this.roiIter.getSample(x0, y0 + 1, 0) & 0xFFFF;
                        w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0) & 0xFFFF;
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            return this.destinationNoData;
                        }
                        break block64;
                    }
                    case 2: 
                    case 3: {
                        w00 = this.roiIter.getSample(x0, y0, 0);
                        w01 = this.roiIter.getSample(x0 + 1, y0, 0);
                        w10 = this.roiIter.getSample(x0, y0 + 1, 0);
                        w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
                            return this.destinationNoData;
                        }
                        break block64;
                    }
                    case 4: {
                        w00f = this.roiIter.getSample(x0, y0, 0);
                        w01f = this.roiIter.getSample(x0 + 1, y0, 0);
                        w10f = this.roiIter.getSample(x0, y0 + 1, 0);
                        w11f = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                        if (w00f == 0.0f && w01f == 0.0f && w10f == 0.0f && w11f == 0.0f) {
                            return this.destinationNoData;
                        }
                        break block64;
                    }
                    case 5: {
                        w00d = this.roiIter.getSample(x0, y0, 0);
                        w01d = this.roiIter.getSample(x0 + 1, y0, 0);
                        w10d = this.roiIter.getSample(x0, y0 + 1, 0);
                        w11d = this.roiIter.getSample(x0 + 1, y0 + 1, 0);
                        if (w00d == 0.0 && w01d == 0.0 && w10d == 0.0 && w11d == 0.0) {
                            return this.destinationNoData;
                        }
                        break block64;
                    }
                }
                break block64;
            }
            return this.destinationNoData;
        }
        w00 = 1;
        w01 = 1;
        w10 = 1;
        w11 = 1;
        w00f = 1.0f;
        w01f = 1.0f;
        w10f = 1.0f;
        w11f = 1.0f;
        w00d = 1.0;
        w01d = 1.0;
        w10d = 1.0;
        w11d = 1.0;
        if (this.noDataRange != null) {
            switch (this.dataType) {
                case 0: {
                    Range rangeB = this.noDataRange;
                    if (rangeB.contains((byte)s00)) {
                        w00 *= 0;
                    }
                    if (rangeB.contains((byte)s01)) {
                        w01 *= 0;
                    }
                    if (rangeB.contains((byte)s10)) {
                        w10 *= 0;
                    }
                    if (rangeB.contains((byte)s11)) {
                        w11 *= 0;
                    }
                    if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                    return this.destinationNoData;
                }
                case 1: 
                case 2: {
                    Range rangeS = this.noDataRange;
                    if (rangeS.contains((short)s00)) {
                        w00 *= 0;
                    }
                    if (rangeS.contains((short)s01)) {
                        w01 *= 0;
                    }
                    if (rangeS.contains((short)s10)) {
                        w10 *= 0;
                    }
                    if (rangeS.contains((short)s11)) {
                        w11 *= 0;
                    }
                    if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                    return this.destinationNoData;
                }
                case 3: {
                    Range rangeI = this.noDataRange;
                    if (rangeI.contains(s00)) {
                        w00 *= 0;
                    }
                    if (rangeI.contains(s01)) {
                        w01 *= 0;
                    }
                    if (rangeI.contains(s10)) {
                        w10 *= 0;
                    }
                    if (rangeI.contains(s11)) {
                        w11 *= 0;
                    }
                    if (w00 != 0 || w01 != 0 || w10 != 0 || w11 != 0) break;
                    return this.destinationNoData;
                }
                case 4: {
                    Range rangeF = this.noDataRange;
                    if (rangeF.contains(s00f) || this.isNotPointRange && Float.isNaN(s00f)) {
                        w00f *= 0.0f;
                    }
                    if (rangeF.contains(s01f) || this.isNotPointRange && Float.isNaN(s01f)) {
                        w01f *= 0.0f;
                    }
                    if (rangeF.contains(s10f) || this.isNotPointRange && Float.isNaN(s10f)) {
                        w10f *= 0.0f;
                    }
                    if (rangeF.contains(s11f) || this.isNotPointRange && Float.isNaN(s11f)) {
                        w11f *= 0.0f;
                    }
                    if (w00f != 0.0f || w01f != 0.0f || w10f != 0.0f || w11f != 0.0f) break;
                    return this.destinationNoData;
                }
                case 5: {
                    Range rangeD = this.noDataRange;
                    if (rangeD.contains(s00d) || this.isNotPointRange && Double.isNaN(s00d)) {
                        w00d *= 0.0;
                    }
                    if (rangeD.contains(s01d) || this.isNotPointRange && Double.isNaN(s01d)) {
                        w01d *= 0.0;
                    }
                    if (rangeD.contains(s10d) || this.isNotPointRange && Double.isNaN(s10d)) {
                        w10d *= 0.0;
                    }
                    if (rangeD.contains(s11d) || this.isNotPointRange && Double.isNaN(s11d)) {
                        w11d *= 0.0;
                    }
                    if (w00d != 0.0 || w01d != 0.0 || w10d != 0.0 || w11d != 0.0) break;
                    return this.destinationNoData;
                }
            }
        }
        Number s = null;
        switch (this.dataType) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac);
                break;
            }
            case 4: {
                s = this.computeValueDouble(s00f, s01f, s10f, s11f, w00f, w01f, w10f, w11f, xfracf, yfracf, this.dataType);
                break;
            }
            case 5: {
                s = this.computeValueDouble(s00d, s01d, s10d, s11d, w00d, w01d, w10d, w11d, xfracd, yfracd, this.dataType);
                break;
            }
        }
        return s;
    }

    public int interpolateBinary(int xNextBitNo, Number[] sourceData, int xfrac, int yfrac, int sourceYOffset, int sourceScanlineStride, int[] coordinates, int[] roiDataArray, int roiYOffset, int roiScanlineStride) {
        int xNextShiftNo = 0;
        int s00 = 0;
        int s01 = 0;
        int s10 = 0;
        int s11 = 0;
        int sshift = 0;
        int sbitnum = xNextBitNo - 1;
        int w00index = 0;
        int w01index = 0;
        int w10index = 0;
        int w11index = 0;
        int w00 = 1;
        int w01 = 1;
        int w10 = 1;
        int w11 = 1;
        if (coordinates != null && this.roiBounds != null && !this.useROIAccessor) {
            int x0 = coordinates[0];
            int y0 = coordinates[1];
            if (this.roiBounds.contains(x0, y0)) {
                w00 = this.roiIter.getSample(x0, y0, 0) & 1;
                w01 = this.roiIter.getSample(x0 + 1, y0, 0) & 1;
                w10 = this.roiIter.getSample(x0, y0 + 1, 0) & 1;
                w11 = this.roiIter.getSample(x0 + 1, y0 + 1, 0) & 1;
            } else {
                return this.black;
            }
        }
        switch (this.dataType) {
            case 0: {
                sshift = 7 - (sbitnum & 7);
                int sbytenum = sbitnum >> 3;
                int xNextByteNo = xNextBitNo >> 3;
                xNextShiftNo = 7 - (xNextBitNo & 7);
                s00 = sourceData[sourceYOffset + sbytenum].byteValue() >> sshift & 1;
                s01 = sourceData[sourceYOffset + xNextByteNo].byteValue() >> xNextShiftNo & 1;
                s10 = sourceData[sourceYOffset + sourceScanlineStride + sbytenum].byteValue() >> sshift & 1;
                s11 = sourceData[sourceYOffset + sourceScanlineStride + xNextByteNo].byteValue() >> xNextShiftNo & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sbytenum;
                int roiDataLength = roiDataArray.length;
                if (w00index > roiDataLength || (roiDataArray[w00index] >> sshift & 1) == 0) {
                    return this.black;
                }
                w01index = roiYOffset + xNextByteNo;
                w10index = roiYOffset + roiScanlineStride + sbytenum;
                w11index = roiYOffset + roiScanlineStride + xNextByteNo;
                w00 = w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                w01 = w01index < roiDataLength ? roiDataArray[w01index] >> xNextShiftNo & 1 : 0;
                w10 = w10index < roiDataLength ? roiDataArray[w10index] >> sshift & 1 : 0;
                w11 = w11index < roiDataLength ? roiDataArray[w11index] >> xNextShiftNo & 1 : 0;
                break;
            }
            case 1: 
            case 2: {
                int xNextShortNo = xNextBitNo >> 4;
                xNextShiftNo = 15 - (xNextBitNo & 0xF);
                int sshortnum = sbitnum >> 4;
                sshift = 15 - (sbitnum & 0xF);
                s00 = sourceData[sourceYOffset + sshortnum].shortValue() >> sshift & 1;
                s01 = sourceData[sourceYOffset + xNextShortNo].shortValue() >> xNextShiftNo & 1;
                s10 = sourceData[sourceYOffset + sourceScanlineStride + sshortnum].shortValue() >> sshift & 1;
                s11 = sourceData[sourceYOffset + sourceScanlineStride + xNextShortNo].shortValue() >> xNextShiftNo & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sshortnum;
                int roiDataLength = roiDataArray.length;
                if (w00index > roiDataLength || (roiDataArray[w00index] >> sshift & 1) == 0) {
                    return this.black;
                }
                w01index = roiYOffset + xNextShortNo;
                w10index = roiYOffset + roiScanlineStride + sshortnum;
                w11index = roiYOffset + roiScanlineStride + xNextShortNo;
                w00 = w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                w01 = w01index < roiDataLength ? roiDataArray[w01index] >> xNextShiftNo & 1 : 0;
                w10 = w10index < roiDataLength ? roiDataArray[w10index] >> sshift & 1 : 0;
                w11 = w11index < roiDataLength ? roiDataArray[w11index] >> xNextShiftNo & 1 : 0;
                break;
            }
            case 3: {
                int xNextIntNo = xNextBitNo >> 5;
                xNextShiftNo = 31 - (xNextBitNo & 0x1F);
                int sintnum = sbitnum >> 5;
                sshift = 31 - (sbitnum & 0x1F);
                s00 = sourceData[sourceYOffset + sintnum].intValue() >> sshift & 1;
                s01 = sourceData[sourceYOffset + xNextIntNo].intValue() >> xNextShiftNo & 1;
                s10 = sourceData[sourceYOffset + sourceScanlineStride + sintnum].intValue() >> sshift & 1;
                s11 = sourceData[sourceYOffset + sourceScanlineStride + xNextIntNo].intValue() >> xNextShiftNo & 1;
                if (!this.useROIAccessor) break;
                w00index = roiYOffset + sintnum;
                int roiDataLength = roiDataArray.length;
                if (w00index > roiDataLength || (roiDataArray[w00index] >> sshift & 1) == 0) {
                    return this.black;
                }
                w01index = roiYOffset + xNextIntNo;
                w10index = roiYOffset + roiScanlineStride + sintnum;
                w11index = roiYOffset + roiScanlineStride + xNextIntNo;
                w00 = w00index < roiDataLength ? roiDataArray[w00index] >> sshift & 1 : 0;
                w01 = w01index < roiDataLength ? roiDataArray[w01index] >> xNextShiftNo & 1 : 0;
                w10 = w10index < roiDataLength ? roiDataArray[w10index] >> sshift & 1 : 0;
                w11 = w11index < roiDataLength ? roiDataArray[w11index] >> xNextShiftNo & 1 : 0;
                break;
            }
        }
        int sumWeight = w00 + w01 + w10 + w11;
        if (sumWeight == 0) {
            return this.black;
        }
        int s = this.computeValue(s00, s01, s10, s11, w00, w01, w10, w11, xfrac, yfrac);
        return s;
    }

    private int computeValue(int s00, int s01, int s10, int s11, int w00, int w01, int w10, int w11, int xfrac, int yfrac) {
        boolean s1Long;
        int s0 = 0;
        int s1 = 0;
        int s = 0;
        long s0L = 0L;
        long s1L = 0L;
        int xfracCompl = (int)Math.pow(2.0, this.subsampleBits) - xfrac;
        int yfracCompl = (int)Math.pow(2.0, this.subsampleBits) - yfrac;
        int shift = 29 - this.subsampleBits;
        boolean s0Long = (s00 | s10) >>> shift == 0;
        boolean bl = s1Long = (s01 | s11) >>> shift == 0;
        if (w00 == 0 && w01 == 0 && w10 == 0 && w11 == 0) {
            return (int)this.destinationNoData;
        }
        if (w00 == 0 || w01 == 0 || w10 == 0 || w11 == 0) {
            if (this.dataType == 3) {
                s0L = w00 == 0 && w01 == 0 ? 0L : (w00 == 0 ? (s1Long ? (long)(-s01 * xfracCompl + (s01 << this.subsampleBits)) : (long)(-s01 * xfracCompl) + ((long)s01 << this.subsampleBits)) : (w01 == 0 ? (s0Long ? (long)(-s00 * xfrac + (s00 << this.subsampleBits)) : (long)(-s00 * xfrac) + ((long)s00 << this.subsampleBits)) : (s0Long ? (s1Long ? (long)((s01 - s00) * xfrac + (s00 << this.subsampleBits)) : ((long)s01 - (long)s00) * (long)xfrac + (long)(s00 << this.subsampleBits)) : ((long)s01 - (long)s00) * (long)xfrac + ((long)s00 << this.subsampleBits))));
                s1L = w10 == 0 && w11 == 0 ? 0L : (w10 == 0 ? (s1Long ? (long)(-s11 * xfracCompl + (s11 << this.subsampleBits)) : (long)(-s11 * xfracCompl) + ((long)s11 << this.subsampleBits)) : (w11 == 0 ? (s0Long ? (long)(-s10 * xfrac + (s10 << this.subsampleBits)) : (long)(-s10 * xfrac) + ((long)s10 << this.subsampleBits)) : (s0Long ? (s1Long ? (long)((s11 - s10) * xfrac + (s10 << this.subsampleBits)) : ((long)s11 - (long)s10) * (long)xfrac + (long)(s10 << this.subsampleBits)) : ((long)s11 - (long)s10) * (long)xfrac + ((long)s10 << this.subsampleBits))));
                s = w00 == 0 && w01 == 0 ? (int)(-s1L * (long)yfracCompl + ((s1L << this.subsampleBits) + (long)this.round2) >> this.shift2) : (w10 == 0 && w11 == 0 ? (int)(-s0L * (long)yfrac + ((s0L << this.subsampleBits) + (long)this.round2) >> this.shift2) : (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2));
            } else {
                s0 = w00 == 0 && w01 == 0 ? 0 : (w00 == 0 ? -s01 * xfracCompl + (s01 << this.subsampleBits) : (w01 == 0 ? -s00 * xfrac + (s00 << this.subsampleBits) : (s01 - s00) * xfrac + (s00 << this.subsampleBits)));
                s1 = w10 == 0 && w11 == 0 ? 0 : (w10 == 0 ? -s11 * xfracCompl + (s11 << this.subsampleBits) : (w11 == 0 ? -s10 * xfrac + (s10 << this.subsampleBits) : (s11 - s10) * xfrac + (s10 << this.subsampleBits)));
                s = w00 == 0 && w01 == 0 ? -s1 * yfracCompl + (s1 << this.subsampleBits) + this.round2 >> this.shift2 : (w10 == 0 && w11 == 0 ? -s0 * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2 : (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2);
            }
        } else if (this.dataType == 3) {
            if (s0Long) {
                if (s1Long) {
                    s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
                    s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
                    s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
                } else {
                    s0L = ((long)s01 - (long)s00) * (long)xfrac + (long)(s00 << this.subsampleBits);
                    s1L = ((long)s11 - (long)s10) * (long)xfrac + (long)(s10 << this.subsampleBits);
                    s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
                }
            } else {
                s0L = ((long)s01 - (long)s00) * (long)xfrac + ((long)s00 << this.subsampleBits);
                s1L = ((long)s11 - (long)s10) * (long)xfrac + ((long)s10 << this.subsampleBits);
                s = (int)((s1L - s0L) * (long)yfrac + (s0L << this.subsampleBits) + (long)this.round2 >> this.shift2);
            }
        } else {
            s0 = (s01 - s00) * xfrac + (s00 << this.subsampleBits);
            s1 = (s11 - s10) * xfrac + (s10 << this.subsampleBits);
            s = (s1 - s0) * yfrac + (s0 << this.subsampleBits) + this.round2 >> this.shift2;
        }
        switch (this.dataType) {
            case 0: {
                s = (byte)s & 0xFF;
                break;
            }
            case 1: {
                s = (short)s & 0xFFFF;
                break;
            }
            case 2: {
                s = (short)s;
                break;
            }
        }
        return s;
    }

    private Number computeValueDouble(double s00, double s01, double s10, double s11, double w00, double w01, double w10, double w11, double xfrac, double yfrac, int dataType) {
        double s0 = 0.0;
        double s1 = 0.0;
        double s = 0.0;
        double xfracCompl = 1.0 - xfrac;
        double yfracCompl = 1.0 - yfrac;
        if (w00 == 0.0 && w01 == 0.0 && w10 == 0.0 && w11 == 0.0) {
            return this.destinationNoData;
        }
        if (w00 == 0.0 || w01 == 0.0 || w10 == 0.0 || w11 == 0.0) {
            s0 = w00 == 0.0 && w01 == 0.0 ? 0.0 : (w00 == 0.0 ? s01 * xfrac : (w01 == 0.0 ? s00 * xfracCompl : (s01 - s00) * xfrac + s00));
            s1 = w10 == 0.0 && w11 == 0.0 ? 0.0 : (w10 == 0.0 ? s11 * xfrac : (w11 == 0.0 ? s10 * xfracCompl : (s11 - s10) * xfrac + s10));
            s = w00 == 0.0 && w01 == 0.0 ? s1 * yfrac : (w10 == 0.0 && w11 == 0.0 ? s0 * yfracCompl : (s1 - s0) * yfrac + s0);
        } else {
            s0 = (s01 - s00) * xfrac + s00;
            s1 = (s11 - s10) * xfrac + s10;
            s = (s1 - s0) * yfrac + s0;
        }
        if (dataType == 4) {
            return Float.valueOf((float)s);
        }
        return s;
    }
}

