/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.georss;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.georss.GeoRSSPollTask;
import org.geowebcache.georss.PollDef;
import org.geowebcache.grid.GridSubset;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.layer.updatesource.GeoRSSFeedDefinition;
import org.geowebcache.layer.updatesource.UpdateSourceDefinition;
import org.geowebcache.seed.TileBreeder;
import org.springframework.scheduling.concurrent.CustomizableThreadFactory;

public class GeoRSSPoller {
    private static final Log logger = LogFactory.getLog(GeoRSSPoller.class);
    private final TileBreeder seeder;
    private final ScheduledExecutorService schedulingPollExecutorService;
    private final List<PollDef> scheduledPolls;
    private final List<GeoRSSPollTask> scheduledTasks;

    public GeoRSSPoller(final TileBreeder seeder, final int startUpDelaySecs) {
        this.seeder = seeder;
        this.scheduledPolls = new ArrayList<PollDef>();
        this.scheduledTasks = new ArrayList<GeoRSSPollTask>();
        boolean corePoolSize = true;
        CustomizableThreadFactory tf = new CustomizableThreadFactory("GWC GeoRSS Poll Tasks-");
        tf.setDaemon(true);
        tf.setThreadPriority(2);
        this.schedulingPollExecutorService = Executors.newScheduledThreadPool(1, (ThreadFactory)tf);
        this.schedulingPollExecutorService.submit(new Runnable(){

            @Override
            public void run() {
                logger.info((Object)"Initializing GeoRSS poller in a background job...");
                GeoRSSPoller.this.findEnabledPolls();
                if (GeoRSSPoller.this.pollCount() > 0) {
                    TimeUnit seconds = TimeUnit.SECONDS;
                    for (PollDef poll : GeoRSSPoller.this.scheduledPolls) {
                        GeoRSSPollTask command = new GeoRSSPollTask(poll, seeder);
                        GeoRSSFeedDefinition pollDef = poll.getPollDef();
                        long period = pollDef.getPollInterval();
                        logger.info((Object)("Scheduling layer " + poll.getLayer().getName() + " to poll the GeoRSS feed " + pollDef.getFeedUrl() + " every " + pollDef.getPollIntervalStr()));
                        GeoRSSPoller.this.schedulingPollExecutorService.scheduleAtFixedRate(command, startUpDelaySecs, period, seconds);
                        GeoRSSPoller.this.scheduledTasks.add(command);
                    }
                    logger.info((Object)("Will wait " + startUpDelaySecs + " seconds before launching the " + GeoRSSPoller.this.pollCount() + " GeoRSS polls found"));
                } else {
                    logger.info((Object)"No enabled GeoRSS feeds found, poller will not run.");
                }
            }
        });
    }

    private void findEnabledPolls() {
        Iterable layers = this.seeder.getLayers();
        for (TileLayer layer : layers) {
            if (layer.getUpdateSources().size() == 0) continue;
            if (!layer.isEnabled()) {
                logger.info((Object)("Ignoring polling GeoRSS update sources for layer '" + layer.getName() + "' as the layer is disabled"));
            }
            for (UpdateSourceDefinition usd : layer.getUpdateSources()) {
                if (!(usd instanceof GeoRSSFeedDefinition)) continue;
                GeoRSSFeedDefinition georssDef = (GeoRSSFeedDefinition)usd;
                String gridSetId = georssDef.getGridSetId();
                GridSubset gridSubset = layer.getGridSubset(gridSetId);
                if (gridSubset == null) {
                    throw new IllegalStateException("Layer " + layer.getName() + " has no grid subset " + gridSetId + " as configured by its GeoRSS seeding feed " + georssDef);
                }
                if (georssDef.getPollInterval() > 0) {
                    logger.info((Object)("Scheduling GeoRSS feed for layer " + layer.getName() + ":" + georssDef));
                    this.scheduledPolls.add(new PollDef(layer, georssDef));
                    continue;
                }
                logger.info((Object)("Feed disabled for layer " + layer.getName() + ", ignoring: " + georssDef));
            }
        }
    }

    public int pollCount() {
        return this.scheduledPolls.size();
    }

    public void destroy() {
        logger.info((Object)"destroy() invoked");
        if (this.schedulingPollExecutorService != null) {
            this.schedulingPollExecutorService.shutdown();
        }
        for (GeoRSSPollTask task : this.scheduledTasks) {
            task.stopSeeding(false);
        }
    }
}

