/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gml2.simple;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Point;
import org.geotools.gml2.simple.GMLWriter;
import org.geotools.gml2.simple.GeometryEncoder;
import org.geotools.gml2.simple.QualifiedName;
import org.geotools.xml.Encoder;
import org.xml.sax.helpers.AttributesImpl;

class PointEncoder
extends GeometryEncoder<Point> {
    static final QualifiedName POINT = new QualifiedName("http://www.opengis.net/gml", "Point", "gml");
    static final QualifiedName COORD = new QualifiedName("http://www.opengis.net/gml", "coord", "gml");
    static final QualifiedName X = new QualifiedName("http://www.opengis.net/gml", "X", "gml");
    static final QualifiedName Y = new QualifiedName("http://www.opengis.net/gml", "Y", "gml");
    QualifiedName point;
    QualifiedName coord;
    QualifiedName x;
    QualifiedName y;
    QualifiedName multiPolygon;

    protected PointEncoder(Encoder encoder, String gmlPrefix) {
        super(encoder);
        this.point = POINT.derive(gmlPrefix);
        this.coord = COORD.derive(gmlPrefix);
        this.x = X.derive(gmlPrefix);
        this.y = Y.derive(gmlPrefix);
    }

    @Override
    public void encode(Point geometry, AttributesImpl atts, GMLWriter handler) throws Exception {
        handler.startElement(this.point, atts);
        handler.startElement(this.coord, null);
        Coordinate c = geometry.getCoordinate();
        handler.startElement(this.x, null);
        handler.ordinate(c.x);
        handler.endElement(this.x);
        handler.startElement(this.y, null);
        handler.ordinate(c.y);
        handler.endElement(this.y);
        handler.endElement(this.coord);
        handler.endElement(this.point);
    }
}

