/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.gce.gtopo30;

import com.sun.media.imageio.stream.RawImageInputStream;
import com.sun.media.imageioimpl.plugins.raw.RawImageReaderSpi;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.awt.image.renderable.ParameterBlock;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteOrder;
import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.stream.ImageInputStream;
import javax.measure.unit.Unit;
import javax.measure.unit.UnitFormat;
import javax.media.jai.ImageLayout;
import javax.media.jai.JAI;
import javax.media.jai.RenderedOp;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridEnvelope2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridCoverage2DReader;
import org.geotools.coverage.grid.io.OverviewPolicy;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.factory.Hints;
import org.geotools.gce.gtopo30.GT30Header;
import org.geotools.gce.gtopo30.GT30Stats;
import org.geotools.gce.gtopo30.GTopo30Format;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.ReferencingFactoryFinder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.cs.DefaultCartesianCS;
import org.geotools.referencing.factory.ReferencingFactoryContainer;
import org.geotools.referencing.operation.builder.GridToEnvelopeMapper;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.resources.image.ImageUtilities;
import org.geotools.util.NumberRange;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.ProjectedCRS;
import org.opengis.referencing.cs.CartesianCS;
import org.opengis.referencing.datum.PixelInCell;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.TransformException;

public final class GTopo30Reader
extends AbstractGridCoverage2DReader
implements GridCoverage2DReader {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.gce.gtopo30");
    private static final RawImageReaderSpi imageIOSPI = new RawImageReaderSpi();
    private static final String dmext = ".dem";
    private static final String dhext = ".hdr";
    private static final String srext = ".src";
    private static final String shext = ".sch";
    private static final String stext = ".stx";
    private static final String prjext = ".prj";
    private final URL demURL;
    private final URL statsURL;
    private URL prjURL;
    private final GT30Header header;
    private final GT30Stats stats;
    private URL urlToUse;
    private final URL demHeaderURL;

    public GTopo30Reader(Object source) throws IOException {
        this(source, null);
    }

    public GTopo30Reader(Object source, Hints hints) throws IOException {
        super(source, hints);
        if (source instanceof File) {
            this.urlToUse = ((File)source).toURI().toURL();
        } else if (source instanceof URL) {
            this.urlToUse = (URL)source;
        } else if (source instanceof String) {
            try {
                this.urlToUse = new File((String)source).toURI().toURL();
            }
            catch (MalformedURLException e) {
                this.urlToUse = new URL((String)source);
            }
        } else {
            throw new IllegalArgumentException("Illegal input argument!");
        }
        this.source = source;
        this.coverageName = "gtopo30_coverage";
        String filename = DataUtilities.urlToFile(this.urlToUse).getName();
        boolean recognized = false;
        boolean extUpperCase = false;
        if (filename.endsWith(dmext) || filename.endsWith(dhext) || filename.endsWith(srext) || filename.endsWith(shext) || filename.endsWith(stext) || filename.endsWith(prjext)) {
            recognized = true;
        } else if (filename.endsWith(dmext.toUpperCase()) || filename.endsWith(dhext.toUpperCase()) || filename.endsWith(srext.toUpperCase()) || filename.endsWith(shext.toUpperCase()) || filename.endsWith(stext.toUpperCase()) || filename.endsWith(prjext.toUpperCase())) {
            recognized = true;
            extUpperCase = true;
        }
        if (!recognized) {
            throw new IOException("Unrecognized file (file extension doesn't match)");
        }
        this.coverageName = filename.substring(0, filename.length() - 4);
        this.demURL = new URL(this.urlToUse, this.coverageName + (!extUpperCase ? dmext : dmext.toUpperCase()));
        this.prjURL = new URL(this.urlToUse, this.coverageName + (!extUpperCase ? prjext : prjext.toUpperCase()));
        this.demHeaderURL = new URL(this.urlToUse, this.coverageName + (!extUpperCase ? dhext : dhext.toUpperCase()));
        this.statsURL = new URL(this.urlToUse, this.coverageName + (!extUpperCase ? stext : stext.toUpperCase()));
        this.header = new GT30Header(this.demHeaderURL);
        this.originalGridRange = new GridEnvelope2D(new Rectangle(0, 0, this.header.getNCols(), this.header.getNRows()));
        this.stats = new GT30Stats(this.statsURL);
        Object tempCRS = this.hints.get((Object)Hints.DEFAULT_COORDINATE_REFERENCE_SYSTEM);
        if (tempCRS != null) {
            this.crs = (CoordinateReferenceSystem)tempCRS;
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.log(Level.WARNING, "Using forced coordinate reference system ");
            }
        } else {
            this.crs = this.initCRS();
        }
        this.originalEnvelope = this.getBounds(this.crs);
        GridToEnvelopeMapper geMapper = new GridToEnvelopeMapper(this.originalGridRange, (Envelope)this.originalEnvelope);
        geMapper.setPixelAnchor(PixelInCell.CELL_CENTER);
        this.raster2Model = geMapper.createTransform();
        this.highestRes = GTopo30Reader.getResolution((GeneralEnvelope)this.originalEnvelope, (Rectangle2D)new Rectangle(0, 0, this.header.getNCols(), this.header.getNRows()), (CoordinateReferenceSystem)this.crs);
        this.numOverviews = 0;
        this.overViewResolutions = null;
        ComponentColorModel cm = new ComponentColorModel(ColorSpace.getInstance(1003), false, false, 1, 2);
        Dimension tileSize = ImageUtilities.toTileSize((Dimension)new Dimension(this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1)));
        SampleModel sm = ((ColorModel)cm).createCompatibleSampleModel(tileSize.width, tileSize.height);
        ImageLayout il = new ImageLayout(0, 0, this.originalGridRange.getSpan(0), this.originalGridRange.getSpan(1));
        il.setTileGridXOffset(0).setTileGridYOffset(0).setTileWidth(tileSize.width).setTileHeight(tileSize.height);
        il.setColorModel((ColorModel)cm).setSampleModel(sm);
        this.setlayout(il);
    }

    public Format getFormat() {
        return new GTopo30Format();
    }

    public GridCoverage2D read(GeneralParameterValue[] params) throws IllegalArgumentException, IOException {
        GeneralEnvelope requestedEnvelope = null;
        Rectangle dim = null;
        OverviewPolicy overviewPolicy = null;
        if (params != null && params != null) {
            for (int i = 0; i < params.length; ++i) {
                ParameterValue param = (ParameterValue)params[i];
                String name = param.getDescriptor().getName().getCode();
                if (name.equals(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString())) {
                    GridGeometry2D gg = (GridGeometry2D)param.getValue();
                    requestedEnvelope = new GeneralEnvelope((Envelope)gg.getEnvelope2D());
                    dim = gg.getGridRange2D().getBounds();
                    continue;
                }
                if (!name.equals(AbstractGridFormat.OVERVIEW_POLICY.getName().toString())) continue;
                overviewPolicy = (OverviewPolicy)param.getValue();
            }
        }
        return this.getGridCoverage(requestedEnvelope, dim, overviewPolicy);
    }

    private GeneralEnvelope getBounds(CoordinateReferenceSystem crs) throws IOException {
        GeneralEnvelope env = new GeneralEnvelope(new double[]{0.0, 0.0}, new double[]{0.0, 0.0});
        double xULC = this.header.getULXMap();
        double yULC = this.header.getULYMap();
        double xDim = this.header.getXDim();
        double yDim = this.header.getYDim();
        int imageWidth = this.header.getNCols();
        int imageHeight = this.header.getNRows();
        double longMin = xULC - xDim / 2.0;
        double latMax = yULC + yDim / 2.0;
        double longMax = longMin + (double)imageWidth * xDim;
        double latMin = latMax - (double)imageHeight * yDim;
        env.setRange(0, longMin, longMax);
        env.setRange(1, latMin, latMax);
        env.setCoordinateReferenceSystem(crs);
        return env;
    }

    private GridCoverage2D getGridCoverage(GeneralEnvelope requestedEnvelope, Rectangle dim, OverviewPolicy overviewPolicy) throws IOException {
        String ext;
        Integer imageChoice;
        int hrWidth = this.originalGridRange.getSpan(0);
        int hrHeight = this.originalGridRange.getSpan(1);
        ImageReadParam readP = new ImageReadParam();
        try {
            imageChoice = this.setReadParams(overviewPolicy, readP, requestedEnvelope, dim);
        }
        catch (TransformException e) {
            throw new DataSourceException(e);
        }
        int max = this.stats.getMax();
        int min = this.stats.getMin();
        File file = DataUtilities.urlToFile(this.demURL);
        ImageInputStream iis = ImageIO.createImageInputStream(file);
        if (this.header.getByteOrder().compareToIgnoreCase("M") == 0) {
            iis.setByteOrder(ByteOrder.BIG_ENDIAN);
        } else {
            iis.setByteOrder(ByteOrder.LITTLE_ENDIAN);
        }
        ImageLayout layout = this.getImageLayout();
        ImageTypeSpecifier its = new ImageTypeSpecifier(layout.getColorModel(null), layout.getSampleModel(null));
        RawImageInputStream raw = new RawImageInputStream(iis, its, new long[]{0L}, new Dimension[]{new Dimension(hrWidth, hrHeight)});
        ImageLayout il = new ImageLayout(0, 0, hrWidth / readP.getSourceXSubsampling(), hrHeight / readP.getSourceYSubsampling(), 0, 0, layout.getTileWidth(null), layout.getTileHeight(null), layout.getSampleModel(null), layout.getColorModel(null));
        RenderingHints hints = new RenderingHints(JAI.KEY_IMAGE_LAYOUT, il);
        ParameterBlock pbjImageRead = new ParameterBlock();
        pbjImageRead.add(raw);
        pbjImageRead.add(imageChoice);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(Boolean.FALSE);
        pbjImageRead.add(null);
        pbjImageRead.add(null);
        pbjImageRead.add(readP);
        pbjImageRead.add(imageIOSPI.createReaderInstance());
        RenderedOp image = JAI.create((String)"ImageRead", (ParameterBlock)pbjImageRead, (RenderingHints)hints);
        GridSampleDimension band = GTopo30Reader.getSampleDimension(max, min);
        HashMap<String, Double> metadata = new HashMap<String, Double>();
        metadata.put("maximum", Double.valueOf(this.stats.getMax()));
        metadata.put("minimum", Double.valueOf(this.stats.getMin()));
        metadata.put("mean", this.stats.getAverage());
        metadata.put("std_dev", this.stats.getStdDev());
        metadata.put("nodata", -9999.0);
        String coverageName = new File(this.coverageName).getName();
        int extension = coverageName.lastIndexOf(".");
        if (extension != -1 && (dmext.compareToIgnoreCase(ext = coverageName.substring(extension + 1)) == 0 || dhext.compareToIgnoreCase(ext) == 0 || srext.compareToIgnoreCase(ext) == 0 || shext.compareToIgnoreCase(ext) == 0 || stext.compareToIgnoreCase(ext) == 0)) {
            coverageName = coverageName.substring(0, extension);
        }
        return this.coverageFactory.create((CharSequence)coverageName, (RenderedImage)image, (Envelope)new GeneralEnvelope((Envelope)this.originalEnvelope), new GridSampleDimension[]{band}, null, metadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoordinateReferenceSystem initCRS() {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(DataUtilities.urlToFile(this.prjURL)));
            StringBuilder buffer = new StringBuilder(reader.readLine());
            if (buffer != null && !(line = buffer.toString().trim()).endsWith("POLAR") && !line.endsWith("GEOGRAPHIC")) {
                while ((line = reader.readLine()) != null) {
                    buffer.append(line);
                }
            }
            reader.close();
            String crsDescription = buffer.toString().trim();
            DefaultGeographicCRS geoCRS = (DefaultGeographicCRS)CRS.decode((String)"EPSG:4326", (boolean)true);
            if (crsDescription != null) {
                if (crsDescription.endsWith("POLAR")) {
                    DefaultCartesianCS cartCS = DefaultCartesianCS.PROJECTED;
                    MathTransformFactory mtFactory = ReferencingFactoryFinder.getMathTransformFactory(null);
                    ParameterValueGroup parameters = mtFactory.getDefaultParameters("Polar_Stereographic");
                    parameters.parameter("central_meridian").setValue(0.0);
                    parameters.parameter("latitude_of_origin").setValue(-71.0);
                    parameters.parameter("scale_factor").setValue(1);
                    parameters.parameter("false_easting").setValue(0.0);
                    parameters.parameter("false_northing").setValue(0.0);
                    ReferencingFactoryContainer factories = ReferencingFactoryContainer.instance(null);
                    Map<String, String> properties = Collections.singletonMap("name", "WGS 84 / Antartic Polar Stereographic");
                    ProjectedCRS projectedCRS = factories.createProjectedCRS(properties, (GeographicCRS)geoCRS, null, parameters, (CartesianCS)cartCS);
                    return projectedCRS;
                }
                if (crsDescription.endsWith("GEOGRAPHIC")) {
                    DefaultGeographicCRS defaultGeographicCRS = geoCRS;
                    return defaultGeographicCRS;
                }
                CoordinateReferenceSystem coordinateReferenceSystem = CRS.parseWKT((String)crsDescription);
                return coordinateReferenceSystem;
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        catch (FactoryException e) {
            LOGGER.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
        finally {
            block30: {
                if (reader != null) {
                    try {
                        reader.close();
                    }
                    catch (Exception e1) {
                        if (!LOGGER.isLoggable(Level.FINE)) break block30;
                        LOGGER.log(Level.FINE, e1.getLocalizedMessage(), e1);
                    }
                }
            }
        }
        CoordinateReferenceSystem crs = AbstractGridFormat.getDefaultCRS();
        LOGGER.info("PRJ file not found, proceeding with default crs");
        return crs;
    }

    private static GridSampleDimension getSampleDimension(int max, int min) {
        UnitFormat unitFormat = UnitFormat.getInstance();
        Unit uom = null;
        try {
            uom = (Unit)unitFormat.parseObject("m");
        }
        catch (ParseException ex1) {
            uom = null;
        }
        Category nan = new Category((CharSequence)Vocabulary.format((int)147), new Color[]{new Color(0, 0, 0, 0)}, NumberRange.create((int)-9999, (int)-9999));
        GridSampleDimension band = new GridSampleDimension((CharSequence)"digital-elevation", new Category[]{nan}, uom);
        return band;
    }
}

