/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.ZGroupLayer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;

class ZGroupLayerFactory {
    private static StyleFactory STYLE_FACTORY = CommonFactoryFinder.getStyleFactory();

    ZGroupLayerFactory() {
    }

    public static MapContent filter(MapContent mapContent) {
        if (!ZGroupLayerFactory.hasZGroup(mapContent, false)) {
            return mapContent;
        }
        MapContent result = new MapContent();
        result.getViewport().setCoordinateReferenceSystem(mapContent.getViewport().getCoordinateReferenceSystem());
        result.getViewport().setBounds(mapContent.getViewport().getBounds());
        ZGroupLayer currentGroup = null;
        for (Layer layer : mapContent.layers()) {
            if (layer instanceof DirectLayer) {
                result.layers().add(layer);
                currentGroup = null;
                continue;
            }
            if (!ZGroupLayerFactory.hasZGroup(layer, true)) {
                if (currentGroup != null) {
                    result.layers().add(currentGroup);
                    currentGroup = null;
                }
                result.layers().add(layer);
                continue;
            }
            List<Layer> zGroupLayers = ZGroupLayerFactory.arrangeOnZGroups(layer, currentGroup);
            currentGroup = zGroupLayers.get(zGroupLayers.size() - 1) instanceof ZGroupLayer ? (ZGroupLayer)zGroupLayers.remove(zGroupLayers.size() - 1) : null;
            for (Layer l : zGroupLayers) {
                result.layers().add(l);
            }
        }
        if (currentGroup != null) {
            result.layers().add(currentGroup);
        }
        return result;
    }

    private static List<Layer> arrangeOnZGroups(Layer layer, ZGroupLayer previousGroup) {
        ArrayList<Layer> splitLayers = new ArrayList<Layer>();
        if (previousGroup != null) {
            splitLayers.add(previousGroup);
        }
        String currentGroupId = previousGroup != null ? previousGroup.groupId : null;
        ArrayList<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle fts : layer.getStyle().featureTypeStyles()) {
            String groupName = fts.getOptions().get("sortByGroup");
            if (!(groupName == currentGroupId || groupName != null && groupName.equals(currentGroupId) || featureTypeStyles.isEmpty())) {
                ZGroupLayerFactory.addToSplitLayers(layer, previousGroup, splitLayers, currentGroupId, featureTypeStyles);
            }
            featureTypeStyles.add(fts);
            currentGroupId = groupName;
        }
        if (featureTypeStyles != null) {
            ZGroupLayerFactory.addToSplitLayers(layer, previousGroup, splitLayers, currentGroupId, featureTypeStyles);
        }
        return splitLayers;
    }

    private static void addToSplitLayers(Layer layer, ZGroupLayer previousGroup, List<Layer> splitLayers, String groupId, List<FeatureTypeStyle> featureTypeStyles) {
        Style style = STYLE_FACTORY.createStyle();
        style.featureTypeStyles().addAll(featureTypeStyles);
        featureTypeStyles.clear();
        Layer singleGroupLayer = ZGroupLayerFactory.buildNewFeatureLayer(layer, style);
        if (groupId == null) {
            splitLayers.add(singleGroupLayer);
        } else if (previousGroup != null && groupId.equals(previousGroup.groupId)) {
            previousGroup.layers.add(singleGroupLayer);
        } else if (groupId != null) {
            ZGroupLayer newZGroup = new ZGroupLayer(groupId, singleGroupLayer);
            splitLayers.add(newZGroup);
        }
    }

    private static Layer buildNewFeatureLayer(Layer layer, Style style) {
        FeatureLayer singleGroupLayer = new FeatureLayer(layer.getFeatureSource(), style);
        SortBy[] sortBy = SLDStyleFactory.getSortBy(style.featureTypeStyles().get(0).getOptions());
        Query nativeQuery = layer.getQuery();
        Query query = ZGroupLayerFactory.ensureSortProperties(nativeQuery, sortBy);
        singleGroupLayer.setQuery(query);
        singleGroupLayer.setTitle(layer.getTitle());
        return singleGroupLayer;
    }

    private static Query ensureSortProperties(Query nativeQuery, SortBy[] sortBy) {
        LinkedHashSet<PropertyName> sortProperties = new LinkedHashSet<PropertyName>();
        for (SortBy sb : sortBy) {
            PropertyName pn = sb.getPropertyName();
            if (pn == null) continue;
            sortProperties.add(pn);
        }
        List<PropertyName> nativeProperties = nativeQuery.getProperties();
        Query q = new Query(nativeQuery);
        if (nativeProperties == Query.ALL_PROPERTIES) {
            q.setProperties(new ArrayList<PropertyName>(sortProperties));
        } else {
            ArrayList<PropertyName> allProperties = new ArrayList<PropertyName>(nativeProperties);
            for (PropertyName propertyName : sortProperties) {
                if (allProperties.contains(propertyName)) continue;
                allProperties.add(propertyName);
            }
            q.setProperties(allProperties);
        }
        return q;
    }

    private static boolean hasZGroup(MapContent mapContent, boolean checkValid) {
        for (Layer layer : mapContent.layers()) {
            if (!ZGroupLayerFactory.hasZGroup(layer, true)) continue;
            return true;
        }
        return false;
    }

    private static boolean hasZGroup(Layer layer, boolean checkValid) {
        boolean hasGroup = false;
        if (layer.getStyle() != null) {
            for (FeatureTypeStyle fts : layer.getStyle().featureTypeStyles()) {
                Map<String, String> options = fts.getOptions();
                String groupName = options.get("sortByGroup");
                if (groupName == null || groupName.trim().isEmpty()) continue;
                hasGroup = true;
                if (!checkValid) continue;
                if (fts.getTransformation() != null) {
                    throw new IllegalArgumentException("Invalid sortByGroup usage in layer " + layer.getTitle() + ": cannot be mixed with rendering transformations");
                }
                if (options.get("sortBy") != null) continue;
                throw new IllegalArgumentException("Invalid sortByGroup usage in layer " + layer.getTitle() + ": the corresponding sortBy vendor option is missing");
            }
        }
        if (hasGroup && !(layer instanceof FeatureLayer)) {
            throw new IllegalArgumentException("Invalid sortByGroup usage in layer " + layer.getTitle() + ": can only be applied to vector layers");
        }
        return hasGroup;
    }
}

