/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite;

import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.map.DirectLayer;
import org.geotools.map.FeatureLayer;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.renderer.lite.AlphaCompositeVisitor;
import org.geotools.renderer.lite.DelayedBackbufferGraphic;
import org.geotools.renderer.lite.ZGroupLayer;
import org.geotools.renderer.style.SLDStyleFactory;
import org.geotools.styling.FeatureTypeStyle;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.util.logging.Logging;

class CompositingGroup {
    private static final Logger LOGGER = Logging.getLogger(CompositingGroup.class);
    private static StyleFactory STYLE_FACTORY = CommonFactoryFinder.getStyleFactory();
    Graphics2D graphics;
    MapContent mapContent;
    Composite composite;

    public static List<CompositingGroup> splitOnCompositingBase(Graphics2D graphics, Rectangle screenSize, MapContent mc) {
        ArrayList<CompositingGroup> result = new ArrayList<CompositingGroup>();
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (Layer layer : mc.layers()) {
            Style style = layer.getStyle();
            if (layer instanceof DirectLayer) {
                layers.add(layer);
                continue;
            }
            if (layer instanceof ZGroupLayer) {
                LOGGER.severe("REMEMBER TO HANDLE Z-GROUPS IN COMPOSITING!");
                layers.add(layer);
                continue;
            }
            List<Style> styles = CompositingGroup.splitOnCompositingBase(style);
            for (Style s : styles) {
                FeatureTypeStyle firstFts = s.featureTypeStyles().get(0);
                if (CompositingGroup.isCompositingBase(firstFts) && !layers.isEmpty()) {
                    CompositingGroup.addToCompositingMapContents(graphics, screenSize, result, layers);
                }
                if (s == style) {
                    layers.add(layer);
                    continue;
                }
                FeatureLayer clone = new FeatureLayer(layer.getFeatureSource(), s);
                clone.setQuery(layer.getQuery());
                clone.setVisible(layer.isVisible());
                clone.setSelected(layer.isSelected());
                clone.getUserData().putAll(layer.getUserData());
                layers.add(clone);
            }
        }
        if (!layers.isEmpty()) {
            CompositingGroup.addToCompositingMapContents(graphics, screenSize, result, layers);
        }
        return result;
    }

    private static void addToCompositingMapContents(Graphics2D graphics, Rectangle screenSize, List<CompositingGroup> compositingContents, List<Layer> layers) {
        Composite composite = CompositingGroup.getComposite(layers);
        Graphics2D cmcGraphic = compositingContents.size() == 0 && !CompositingGroup.hasAlphaCompositing(layers) ? graphics : new DelayedBackbufferGraphic(graphics, screenSize);
        MapContent current = new MapContent();
        current.addLayers(layers);
        CompositingGroup cmc = new CompositingGroup(cmcGraphic, current, composite);
        compositingContents.add(cmc);
        layers.clear();
    }

    private static Composite getComposite(List<Layer> layers) {
        Style styles = layers.get(0).getStyle();
        List<FeatureTypeStyle> featureTypeStyles = styles.featureTypeStyles();
        if (featureTypeStyles.size() > 0) {
            FeatureTypeStyle firstFts = featureTypeStyles.get(0);
            Composite composite = SLDStyleFactory.getComposite(firstFts.getOptions());
            return composite;
        }
        return null;
    }

    private static boolean hasAlphaCompositing(List<Layer> layers) {
        AlphaCompositeVisitor visitor = new AlphaCompositeVisitor();
        for (Layer layer : layers) {
            Style style = layer.getStyle();
            style.accept(visitor);
            if (!visitor.alphaComposite) continue;
            return true;
        }
        return false;
    }

    private static List<Style> splitOnCompositingBase(Style style) {
        ArrayList<Style> styles = new ArrayList<Style>();
        ArrayList<FeatureTypeStyle> featureTypeStyles = new ArrayList<FeatureTypeStyle>();
        for (FeatureTypeStyle fts : style.featureTypeStyles()) {
            if (CompositingGroup.isCompositingBase(fts)) {
                CompositingGroup.addToStyles(styles, featureTypeStyles);
            }
            featureTypeStyles.add(fts);
        }
        CompositingGroup.addToStyles(styles, featureTypeStyles);
        return styles;
    }

    private static void addToStyles(List<Style> styles, List<FeatureTypeStyle> featureTypeStyles) {
        if (!featureTypeStyles.isEmpty()) {
            Style s = STYLE_FACTORY.createStyle();
            s.featureTypeStyles().addAll(featureTypeStyles);
            styles.add(s);
            featureTypeStyles.clear();
        }
    }

    private static boolean isCompositingBase(FeatureTypeStyle fts) {
        return "true".equalsIgnoreCase(fts.getOptions().get("composite-base"));
    }

    CompositingGroup(Graphics2D graphics, MapContent mapContent, Composite composite) {
        this.graphics = graphics;
        this.mapContent = mapContent;
        this.composite = composite;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public MapContent getMapContent() {
        return this.mapContent;
    }

    public Composite getComposite() {
        return this.composite;
    }
}

