/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.font.GlyphVector;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.util.List;
import javax.swing.Icon;
import org.geotools.geometry.jts.LiteShape2;
import org.geotools.geometry.jts.TransformedShape;
import org.geotools.renderer.label.LabelCacheImpl;
import org.geotools.renderer.label.LabelCacheItem;
import org.geotools.renderer.label.LabelSplitter;
import org.geotools.renderer.label.LineInfo;
import org.geotools.renderer.label.LineStringCursor;
import org.geotools.renderer.label.TransformedIcon;
import org.geotools.renderer.lite.StyledShapePainter;
import org.geotools.renderer.style.GraphicStyle2D;
import org.geotools.renderer.style.IconStyle2D;
import org.geotools.renderer.style.MarkStyle2D;
import org.geotools.renderer.style.Style2D;
import org.geotools.renderer.style.TextStyle2D;

public class LabelPainter {
    static final double EPS = 1.0E-6;
    StyledShapePainter shapePainter = new StyledShapePainter();
    LabelCacheItem labelItem;
    List<LineInfo> lines;
    Graphics2D graphics;
    LabelCacheImpl.LabelRenderingMode labelRenderingMode;
    GeometryFactory gf = new GeometryFactory();
    Rectangle2D labelBounds;
    LabelSplitter splitter = new LabelSplitter();

    public LabelPainter(Graphics2D graphics, LabelCacheImpl.LabelRenderingMode labelRenderingMode) {
        this.graphics = graphics;
        this.labelRenderingMode = labelRenderingMode;
    }

    public void setLabel(LabelCacheItem labelItem) {
        this.labelItem = labelItem;
        TextStyle2D textStyle = labelItem.getTextStyle();
        textStyle.setLabel(labelItem.getLabel());
        this.labelBounds = null;
        this.lines = null;
        this.lines = this.splitter.layout(labelItem, this.graphics);
        double maxWidth = 0.0;
        for (LineInfo line : this.lines) {
            maxWidth = Math.max(line.getWidth(), maxWidth);
        }
        double boundsY = 0.0;
        double labelY = 0.0;
        for (LineInfo info : this.lines) {
            Rectangle2D currBounds = info.getBounds();
            double minX = (maxWidth - currBounds.getWidth()) * textStyle.getAnchorX() - currBounds.getMinX();
            info.setMinX(minX);
            double lineOffset = info.getLineOffset();
            if (this.labelBounds == null) {
                this.labelBounds = currBounds;
                boundsY = currBounds.getMinY() + lineOffset;
            } else {
                Rectangle2D.Double translated = new Rectangle2D.Double(minX, boundsY, currBounds.getWidth(), currBounds.getHeight());
                boundsY += lineOffset;
                labelY += lineOffset;
                this.labelBounds = this.labelBounds.createUnion(translated);
            }
            info.setY(labelY);
        }
        this.normalizeBounds(this.labelBounds);
    }

    void normalizeBounds(Rectangle2D bounds) {
        if (bounds.isEmpty()) {
            bounds.setRect(bounds.getCenterX() - 1.0, bounds.getCenterY() - 1.0, 2.0, 2.0);
        }
    }

    public LabelCacheItem getLabel() {
        return this.labelItem;
    }

    public double getLineHeight() {
        return this.lines.get(0).getLineHeight();
    }

    public double getAscent() {
        return this.lines.get(0).getAscent();
    }

    public int getStraightLabelWidth() {
        return (int)Math.round(this.getLabelBounds().getWidth());
    }

    public int getLineCount() {
        return this.lines.size();
    }

    public Rectangle2D getFullLabelBounds() {
        Rectangle2D bounds = (Rectangle2D)this.getLabelBounds().clone();
        int haloRadius = Math.round(this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f);
        bounds.add(bounds.getMinX() - (double)haloRadius, bounds.getMinY() - (double)haloRadius);
        bounds.add(bounds.getMaxX() + (double)haloRadius, bounds.getMaxY() + (double)haloRadius);
        if (this.labelItem.getTextStyle().getGraphic() != null) {
            Rectangle2D shieldBounds;
            Rectangle area = this.labelItem.getTextStyle().getGraphicDimensions();
            int[] margin = this.labelItem.getGraphicMargin();
            LabelCacheItem.GraphicResize mode = this.labelItem.getGraphicsResize();
            if (mode == LabelCacheItem.GraphicResize.STRETCH) {
                shieldBounds = this.applyMargins(margin, bounds);
            } else if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = 1.0;
                factor = bounds.getWidth() > bounds.getHeight() ? bounds.getWidth() / ((RectangularShape)area).getWidth() : bounds.getHeight() / ((RectangularShape)area).getHeight();
                double width = ((RectangularShape)area).getWidth() * factor;
                double height = ((RectangularShape)area).getHeight() * factor;
                shieldBounds = new Rectangle2D.Double(width / 2.0 + bounds.getMinX() - bounds.getWidth() / 2.0, height / 2.0 + bounds.getMinY() - bounds.getHeight() / 2.0, width, height);
                shieldBounds = this.applyMargins(margin, shieldBounds);
            } else {
                shieldBounds = new Rectangle2D.Double(-((RectangularShape)area).getWidth() / 2.0 + bounds.getMinX() - bounds.getWidth() / 2.0, -((RectangularShape)area).getHeight() / 2.0 + bounds.getMinY() - bounds.getHeight() / 2.0, ((RectangularShape)area).getWidth(), ((RectangularShape)area).getHeight());
            }
            bounds = bounds.createUnion(shieldBounds);
        }
        this.normalizeBounds(bounds);
        return bounds;
    }

    Rectangle2D applyMargins(int[] margin, Rectangle2D bounds) {
        if (bounds != null) {
            double xmin = bounds.getMinX() - (double)margin[3];
            double ymin = bounds.getMinY() - (double)margin[0];
            double width = bounds.getWidth() + (double)margin[1] + (double)margin[3];
            double height = bounds.getHeight() + (double)margin[0] + (double)margin[2];
            return new Rectangle2D.Double(xmin, ymin, width, height);
        }
        return bounds;
    }

    public Rectangle2D getLabelBounds() {
        return this.labelBounds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintStraightLabel(AffineTransform transform) throws Exception {
        AffineTransform oldTransform = this.graphics.getTransform();
        try {
            AffineTransform newTransform = new AffineTransform(oldTransform);
            newTransform.concatenate(transform);
            this.graphics.setTransform(newTransform);
            Style2D graphic = this.labelItem.getTextStyle().getGraphic();
            if (graphic != null) {
                double offsetY = 0.0;
                double offsetX = 0.0;
                int[] margin = this.labelItem.getGraphicMargin();
                if (margin != null) {
                    offsetX = margin[1] - margin[3];
                    offsetY = margin[2] - margin[0];
                }
                LiteShape2 tempShape = new LiteShape2((Geometry)this.gf.createPoint(new Coordinate(this.labelBounds.getWidth() / 2.0 + offsetX, -1.0 * this.labelBounds.getHeight() / 2.0 + offsetY)), null, null, false, false);
                graphic = this.resizeGraphic(graphic);
                AffineTransform graphicTx = new AffineTransform(transform);
                LineInfo lastLine = this.lines.get(this.lines.size() - 1);
                graphicTx.translate(lastLine.getComponents().get(0).getX(), lastLine.getY());
                this.graphics.setTransform(graphicTx);
                this.shapePainter.paint(this.graphics, tempShape, graphic, graphic.getMaxScale());
            }
            if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
                return;
            }
            if (this.lines.size() == 1 && this.lines.get(0).getComponents().size() == 1) {
                this.drawGlyphVector(this.lines.get(0).getComponents().get(0).getGlyphVector());
            } else {
                AffineTransform lineTx = new AffineTransform(transform);
                for (LineInfo line : this.lines) {
                    for (LineInfo.LineComponent component : line.getComponents()) {
                        lineTx.setTransform(transform);
                        lineTx.translate(component.getX(), line.getY());
                        this.graphics.setTransform(lineTx);
                        this.drawGlyphVector(component.getGlyphVector());
                    }
                }
            }
        }
        finally {
            this.graphics.setTransform(oldTransform);
        }
    }

    private Style2D resizeGraphic(Style2D graphic) {
        LabelCacheItem.GraphicResize mode = this.labelItem.graphicsResize;
        if (mode == LabelCacheItem.GraphicResize.NONE || mode == null) {
            return graphic;
        }
        double width = this.labelBounds.getWidth();
        double height = this.labelBounds.getHeight();
        int[] margin = this.labelItem.graphicMargin;
        if (margin != null) {
            width += (double)(margin[1] + margin[3]);
            height += (double)(margin[0] + margin[2]);
        }
        width = Math.round(width);
        height = Math.round(height);
        if (width <= 0.0 || height <= 0.0) {
            return null;
        }
        if (graphic instanceof MarkStyle2D) {
            MarkStyle2D mark = (MarkStyle2D)graphic;
            Shape original = mark.getShape();
            Rectangle2D bounds = original.getBounds2D();
            MarkStyle2D resized = (MarkStyle2D)mark.clone();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                if (width > height) {
                    resized.setSize(Math.round(bounds.getHeight() * width / bounds.getWidth()));
                } else {
                    resized.setSize(height);
                }
            } else {
                TransformedShape tss = new TransformedShape();
                tss.shape = original;
                tss.setTransform(AffineTransform.getScaleInstance(width / bounds.getWidth(), height / bounds.getHeight()));
                resized.setShape(tss);
                resized.setSize(height);
            }
            return resized;
        }
        if (graphic instanceof IconStyle2D) {
            AffineTransform at;
            IconStyle2D iconStyle = (IconStyle2D)graphic;
            IconStyle2D resized = (IconStyle2D)iconStyle.clone();
            Icon icon = iconStyle.getIcon();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = width > height ? width / (double)icon.getIconWidth() : height / (double)icon.getIconHeight();
                at = AffineTransform.getScaleInstance(factor, factor);
            } else {
                at = AffineTransform.getScaleInstance(width / (double)icon.getIconWidth(), height / (double)icon.getIconHeight());
            }
            resized.setIcon(new TransformedIcon(icon, at));
            return resized;
        }
        if (graphic instanceof GraphicStyle2D) {
            AffineTransform at;
            GraphicStyle2D gstyle = (GraphicStyle2D)graphic;
            GraphicStyle2D resized = (GraphicStyle2D)graphic.clone();
            BufferedImage image = gstyle.getImage();
            if (mode == LabelCacheItem.GraphicResize.PROPORTIONAL) {
                double factor = width > height ? width / (double)image.getWidth() : height / (double)image.getHeight();
                at = AffineTransform.getScaleInstance(factor, factor);
            } else {
                at = AffineTransform.getScaleInstance(width / (double)image.getWidth(), height / (double)image.getHeight());
            }
            AffineTransformOp ato = new AffineTransformOp(at, 2);
            image = ato.filter(image, null);
            resized.setImage(image);
            return resized;
        }
        return graphic;
    }

    private void drawGlyphVector(GlyphVector gv) {
        Shape outline = gv.getOutline();
        if (this.labelItem.getTextStyle().getHaloFill() != null) {
            this.configureHalo();
            this.graphics.draw(outline);
        }
        this.configureLabelStyle();
        if (this.labelRenderingMode == LabelCacheImpl.LabelRenderingMode.STRING) {
            this.graphics.drawGlyphVector(gv, 0.0f, 0.0f);
        } else if (this.labelRenderingMode == LabelCacheImpl.LabelRenderingMode.OUTLINE) {
            this.graphics.fill(outline);
        } else {
            AffineTransform tx = this.graphics.getTransform();
            if (Math.abs(tx.getShearX()) >= 1.0E-6 || Math.abs(tx.getShearY()) > 1.0E-6) {
                this.graphics.fill(outline);
            } else {
                this.graphics.drawGlyphVector(gv, 0.0f, 0.0f);
            }
        }
    }

    private void configureHalo() {
        this.graphics.setPaint(this.labelItem.getTextStyle().getHaloFill());
        this.graphics.setComposite(this.labelItem.getTextStyle().getHaloComposite());
        float haloRadius = this.labelItem.getTextStyle().getHaloFill() != null ? this.labelItem.getTextStyle().getHaloRadius() : 0.0f;
        this.graphics.setStroke(new BasicStroke(2.0f * haloRadius, 1, 1));
    }

    private void configureLabelStyle() {
        Paint fill = this.labelItem.getTextStyle().getFill();
        Composite comp = this.labelItem.getTextStyle().getComposite();
        if (fill == null) {
            fill = Color.BLACK;
            comp = AlphaComposite.getInstance(3, 1.0f);
        }
        this.graphics.setPaint(fill);
        this.graphics.setComposite(comp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintCurvedLabel(LineStringCursor cursor) {
        if (this.labelItem.getTextStyle().getFont().getSize() == 0) {
            return;
        }
        AffineTransform oldTransform = this.graphics.getTransform();
        LineInfo line = this.lines.get(0);
        if (!this.isLabelUpwards(cursor) && this.labelItem.isForceLeftToRightEnabled()) {
            LineStringCursor reverse = cursor.reverse();
            reverse.moveTo(cursor.getLineStringLength() - cursor.getCurrentOrdinate());
            cursor = reverse;
        }
        double anchorY = this.getLinePlacementYAnchor();
        double mid = cursor.getCurrentOrdinate();
        Coordinate c = new Coordinate();
        c = cursor.getCurrentPosition(c);
        this.graphics.setPaint(Color.BLACK);
        double startOrdinate = mid - (double)(this.getStraightLabelWidth() / 2);
        if (startOrdinate < 0.0) {
            startOrdinate = 0.0;
        }
        cursor.moveTo(startOrdinate);
        for (LineInfo.LineComponent component : line.getComponents()) {
            GlyphVector glyphVector = component.getGlyphVector();
            try {
                int i;
                int numGlyphs = glyphVector.getNumGlyphs();
                float nextAdvance = glyphVector.getGlyphMetrics(0).getAdvance() * 0.5f;
                double start = cursor.getCurrentOrdinate();
                Shape[] outlines = new Shape[numGlyphs];
                AffineTransform[] transforms = new AffineTransform[numGlyphs];
                for (i = 0; i < numGlyphs; ++i) {
                    outlines[i] = glyphVector.getGlyphOutline(i);
                    Point2D p = glyphVector.getGlyphPosition(i);
                    float advance = nextAdvance;
                    nextAdvance = i < numGlyphs - 1 ? glyphVector.getGlyphMetrics(i + 1).getAdvance() * 0.5f : 0.0f;
                    c = cursor.getCurrentPosition(c);
                    AffineTransform t = new AffineTransform();
                    t.setToTranslation(c.x, c.y);
                    t.rotate(cursor.getCurrentAngle());
                    t.translate(-p.getX() - (double)advance, -p.getY() + this.getLineHeight() * anchorY);
                    transforms[i] = t;
                    cursor.moveTo(cursor.getCurrentOrdinate() + (double)advance + (double)nextAdvance);
                }
                if (this.labelItem.getTextStyle().getHaloFill() != null) {
                    this.configureHalo();
                    for (i = 0; i < numGlyphs; ++i) {
                        this.graphics.setTransform(transforms[i]);
                        this.graphics.draw(outlines[i]);
                    }
                }
                this.configureLabelStyle();
                for (i = 0; i < numGlyphs; ++i) {
                    this.graphics.setTransform(transforms[i]);
                    this.graphics.fill(outlines[i]);
                }
                cursor.moveTo(start + glyphVector.getGlyphPosition(numGlyphs).getX());
            }
            finally {
                this.graphics.setTransform(oldTransform);
            }
        }
    }

    public double getLinePlacementYAnchor() {
        TextStyle2D textStyle = this.getLabel().getTextStyle();
        LineMetrics lm = textStyle.getFont().getLineMetrics(textStyle.getLabel(), this.graphics.getFontRenderContext());
        if (lm.getHeight() > 0.0f) {
            return (Math.abs(lm.getStrikethroughOffset()) + lm.getDescent() + lm.getLeading()) / lm.getHeight();
        }
        return 0.0;
    }

    boolean isLabelUpwards(LineStringCursor cursor) {
        double labelAngle = cursor.getCurrentAngle() + 1.5707963267948966;
        return (labelAngle %= Math.PI * 2) >= 0.0 && labelAngle < Math.PI;
    }
}

