/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.label;

import com.vividsolutions.jts.geom.Coordinate;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import org.geotools.renderer.label.GlyphProcessor;
import org.geotools.renderer.label.LabelPainter;
import org.geotools.renderer.label.LineInfo;
import org.geotools.renderer.label.LineStringCursor;

abstract class GlyphVectorProcessor {
    List<AffineTransform> transforms = new ArrayList<AffineTransform>();
    LabelPainter painter;

    public GlyphVectorProcessor(LabelPainter painter) {
        this.painter = painter;
    }

    public boolean process(GlyphProcessor processor) {
        return this.process(processor, false);
    }

    public boolean process(GlyphProcessor processor, boolean stopIfTrue) {
        int glyphCount = 0;
        boolean ret = false;
        for (LineInfo lineInfo : this.painter.lines) {
            for (LineInfo.LineComponent lineComponent : lineInfo.getComponents()) {
                GlyphVector glyphVector = lineComponent.getGlyphVector();
                int g = 0;
                while (g < glyphVector.getNumGlyphs()) {
                    char c = this.getChar(lineComponent, glyphVector, g);
                    boolean bl = ret = processor.process(glyphVector, g, this.transforms.get(glyphCount), c) || ret;
                    if (ret && stopIfTrue) {
                        return true;
                    }
                    ++g;
                    ++glyphCount;
                }
            }
        }
        return ret;
    }

    public char getChar(LineInfo.LineComponent component, GlyphVector glyphVector, int g) {
        return component.getText().charAt(glyphVector.getGlyphCharIndex(g));
    }

    public static class Curved
    extends GlyphVectorProcessor {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Curved(LabelPainter painter, LineStringCursor cursor) {
            super(painter);
            AffineTransform oldTransform = painter.graphics.getTransform();
            LineInfo lineInfo = painter.lines.get(0);
            if (!painter.isLabelUpwards(cursor) && painter.getLabel().isForceLeftToRightEnabled()) {
                LineStringCursor reverse = cursor.reverse();
                reverse.moveTo(cursor.getLineStringLength() - cursor.getCurrentOrdinate());
                cursor = reverse;
            }
            double anchorY = painter.getLinePlacementYAnchor();
            double mid = cursor.getCurrentOrdinate();
            Coordinate c = new Coordinate();
            c = cursor.getCurrentPosition(c);
            double startOrdinate = mid - (double)(painter.getStraightLabelWidth() / 2);
            if (startOrdinate < 0.0) {
                startOrdinate = 0.0;
            }
            cursor.moveTo(startOrdinate);
            for (LineInfo.LineComponent lineComponent : lineInfo.getComponents()) {
                GlyphVector gv = lineComponent.getGlyphVector();
                try {
                    int numGlyphs = gv.getNumGlyphs();
                    float nextAdvance = gv.getGlyphMetrics(0).getAdvance() * 0.5f;
                    double start = cursor.getCurrentOrdinate();
                    for (int i = 0; i < numGlyphs; ++i) {
                        Point2D p = gv.getGlyphPosition(i);
                        float advance = nextAdvance;
                        nextAdvance = i < numGlyphs - 1 ? gv.getGlyphMetrics(i + 1).getAdvance() * 0.5f : 0.0f;
                        c = cursor.getCurrentPosition(c);
                        AffineTransform t = new AffineTransform();
                        t.setToTranslation(c.x, c.y);
                        t.rotate(cursor.getCurrentAngle());
                        t.translate(-p.getX() - (double)advance, -p.getY() + painter.getLineHeight() * anchorY);
                        this.transforms.add(t);
                        cursor.moveTo(cursor.getCurrentOrdinate() + (double)advance + (double)nextAdvance);
                    }
                    cursor.moveTo(start + gv.getGlyphPosition(numGlyphs).getX());
                }
                finally {
                    painter.graphics.setTransform(oldTransform);
                }
            }
        }
    }

    public static class Straight
    extends GlyphVectorProcessor {
        public Straight(LabelPainter painter, AffineTransform tx) {
            super(painter);
            for (LineInfo lineInfo : painter.lines) {
                for (LineInfo.LineComponent lineComponent : lineInfo.getComponents()) {
                    AffineTransform componentTx = new AffineTransform(tx);
                    componentTx.translate(lineComponent.getX(), lineInfo.getY());
                    for (int i = 0; i < lineComponent.getGlyphVector().getNumGlyphs(); ++i) {
                        this.transforms.add(componentTx);
                    }
                }
            }
        }
    }
}

