/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.geom.prep.PreparedGeometry;
import com.vividsolutions.jts.geom.prep.PreparedGeometryFactory;
import com.vividsolutions.jts.precision.EnhancedPrecisionOp;
import com.vividsolutions.jts.precision.GeometryPrecisionReducer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.transform.ConcatenatedTransform;
import org.geotools.referencing.operation.transform.GeocentricTransform;
import org.geotools.renderer.crs.GeographicOffsetWrapper;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.util.logging.Logging;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.crs.GeographicCRS;
import org.opengis.referencing.crs.SingleCRS;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class ProjectionHandler {
    protected static final double EPS = 1.0E-6;
    protected static final Logger LOGGER = Logging.getLogger(ProjectionHandler.class);
    protected ReferencedEnvelope renderingEnvelope;
    protected final ReferencedEnvelope validAreaBounds;
    protected final Geometry validArea;
    protected final PreparedGeometry validaAreaTester;
    protected final CoordinateReferenceSystem sourceCRS;
    protected final CoordinateReferenceSystem targetCRS;
    protected double datelineX = Double.NaN;
    protected double radius = Double.NaN;
    protected boolean queryAcrossDateline;

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Envelope validAreaBounds, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        this.renderingEnvelope = renderingEnvelope;
        this.sourceCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)sourceCRS);
        this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        this.validAreaBounds = validAreaBounds != null ? new ReferencedEnvelope(validAreaBounds, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84) : null;
        this.validArea = null;
        this.validaAreaTester = null;
        this.queryAcrossDateline = !CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)renderingEnvelope.getCoordinateReferenceSystem());
    }

    public ProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
        if (validArea.isRectangle()) {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = new ReferencedEnvelope(validArea.getEnvelopeInternal(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.validArea = null;
            this.validaAreaTester = null;
        } else {
            this.renderingEnvelope = renderingEnvelope;
            this.sourceCRS = sourceCRS;
            this.targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
            this.validAreaBounds = new ReferencedEnvelope(validArea.getEnvelopeInternal(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            this.validArea = validArea;
            this.validaAreaTester = PreparedGeometryFactory.prepare(validArea);
        }
    }

    public ReferencedEnvelope getRenderingEnvelope() {
        return this.renderingEnvelope;
    }

    public CoordinateReferenceSystem getSourceCRS() {
        return this.sourceCRS;
    }

    public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
        CoordinateReferenceSystem renderingCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
        if (!this.queryAcrossDateline) {
            return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
        }
        if (renderingCRS instanceof GeographicCRS && !CRS.equalsIgnoreMetadata((Object)renderingCRS, (Object)DefaultGeographicCRS.WGS84)) {
            ReferencedEnvelope re = this.renderingEnvelope;
            ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
            envelopes.add(re);
            if (CRS.getAxisOrder((CoordinateReferenceSystem)renderingCRS) == CRS.AxisOrder.NORTH_EAST) {
                if (re.getMinY() >= -180.0 && re.getMaxY() <= 180.0) {
                    return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
                }
                if (re.getMinY() < -180.0) {
                    envelopes.add(new ReferencedEnvelope(re.getMinY() + 360.0, 180.0, re.getMinX(), re.getMaxX(), re.getCoordinateReferenceSystem()));
                }
                if (re.getMaxY() > 180.0) {
                    envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxY() - 360.0, re.getMinX(), re.getMaxX(), re.getCoordinateReferenceSystem()));
                }
            } else {
                if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
                    return Collections.singletonList(this.transformEnvelope(this.renderingEnvelope, this.sourceCRS));
                }
                if (re.getMinX() < -180.0) {
                    envelopes.add(new ReferencedEnvelope(re.getMinX() + 360.0, 180.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
                }
                if (re.getMaxX() > 180.0) {
                    envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxX() - 360.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
                }
            }
            this.mergeEnvelopes(envelopes);
            this.reprojectEnvelopes(this.sourceCRS, envelopes);
            return envelopes;
        }
        if (!Double.isNaN(this.datelineX) && this.renderingEnvelope.getMinX() < this.datelineX && this.renderingEnvelope.getMaxX() > this.datelineX && this.renderingEnvelope.getWidth() < this.radius) {
            double minX = this.renderingEnvelope.getMinX();
            double minY = this.renderingEnvelope.getMinY();
            double maxX = this.renderingEnvelope.getMaxX();
            double maxY = this.renderingEnvelope.getMaxY();
            ReferencedEnvelope re1 = new ReferencedEnvelope(minX, this.datelineX - 1.0E-6, minY, maxY, renderingCRS);
            ReferencedEnvelope tx1 = this.transformEnvelope(re1, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            tx1.expandToInclude(180.0, tx1.getMinY());
            ReferencedEnvelope re2 = new ReferencedEnvelope(this.datelineX + 1.0E-6, maxX, minY, maxY, renderingCRS);
            ReferencedEnvelope tx2 = this.transformEnvelope(re2, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (tx2.getMinX() > 180.0) {
                tx2.translate(-360.0, 0.0);
            }
            tx2.expandToInclude(-180.0, tx1.getMinY());
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            result.add(tx1);
            result.add(tx2);
            this.mergeEnvelopes(result);
            return result;
        }
        return this.getSourceEnvelopes(this.renderingEnvelope);
    }

    protected List<ReferencedEnvelope> getSourceEnvelopes(ReferencedEnvelope renderingEnvelope) throws TransformException, FactoryException {
        ReferencedEnvelope re = this.transformEnvelope(renderingEnvelope, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
        if (re.getMinX() >= -180.0 && re.getMaxX() <= 180.0) {
            return Collections.singletonList(this.transformEnvelope(renderingEnvelope, this.sourceCRS));
        }
        ArrayList<ReferencedEnvelope> envelopes = new ArrayList<ReferencedEnvelope>();
        envelopes.add(re);
        if (re.getMinX() < -180.0) {
            envelopes.add(new ReferencedEnvelope(re.getMinX() + 360.0, 180.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        if (re.getMaxX() > 180.0) {
            envelopes.add(new ReferencedEnvelope(-180.0, re.getMaxX() - 360.0, re.getMinY(), re.getMaxY(), re.getCoordinateReferenceSystem()));
        }
        this.mergeEnvelopes(envelopes);
        this.reprojectEnvelopes(this.sourceCRS, envelopes);
        return envelopes;
    }

    protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
        try {
            return envelope.transform(targetCRS, true, 10);
        }
        catch (Exception e) {
            GeographicBoundingBox bbox;
            LOGGER.fine("Failed to reproject the envelope " + envelope + " to " + targetCRS + " trying an area restriction");
            ReferencedEnvelope envWGS84 = envelope.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(envelope, envelope.getCoordinateReferenceSystem(), false);
            if (handler != null && handler.validAreaBounds != null) {
                ReferencedEnvelope intersection = envWGS84.intersection(this.validAreaBounds);
                if (intersection.isNull()) {
                    return null;
                }
                try {
                    return ReferencedEnvelope.reference((Envelope)intersection).transform(targetCRS, true);
                }
                catch (Exception e2) {
                    LOGGER.fine("Failed to reproject the restricted envelope " + intersection + " to " + targetCRS);
                }
            }
            if ((bbox = CRS.getGeographicBoundingBox((CoordinateReferenceSystem)targetCRS)) != null) {
                ReferencedEnvelope restriction = new ReferencedEnvelope(bbox.getEastBoundLongitude(), bbox.getWestBoundLongitude(), bbox.getSouthBoundLatitude(), bbox.getNorthBoundLatitude(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
                ReferencedEnvelope intersection = envWGS84.intersection(restriction);
                if (intersection.isNull()) {
                    return null;
                }
                try {
                    return ReferencedEnvelope.reference((Envelope)intersection).transform(targetCRS, true);
                }
                catch (Exception e2) {
                    LOGGER.fine("Failed to reproject the restricted envelope " + intersection + " to " + targetCRS);
                }
            }
            throw new TransformException("All attemptsto reproject the envelope " + envelope + " to " + targetCRS + " failed");
        }
    }

    protected void reprojectEnvelopes(CoordinateReferenceSystem queryCRS, List<ReferencedEnvelope> envelopes) throws TransformException, FactoryException {
        for (int i = 0; i < envelopes.size(); ++i) {
            envelopes.set(i, this.transformEnvelope(envelopes.get(i), queryCRS));
        }
    }

    protected void mergeEnvelopes(List<ReferencedEnvelope> envelopes) {
        boolean merged = true;
        while (merged && envelopes.size() > 1) {
            merged = false;
            for (int i = 0; i < envelopes.size() - 1; ++i) {
                ReferencedEnvelope curr = envelopes.get(i);
                int j = i + 1;
                while (j < envelopes.size()) {
                    ReferencedEnvelope next = envelopes.get(j);
                    if (curr.intersects(next)) {
                        curr.expandToInclude(next);
                        envelopes.remove(j);
                        merged = true;
                        continue;
                    }
                    ++j;
                }
            }
        }
    }

    public boolean requiresProcessing(Geometry geometry) {
        if (this.validAreaBounds == null) {
            return false;
        }
        return !CRS.equalsIgnoreMetadata((Object)this.sourceCRS, (Object)this.renderingEnvelope.getCoordinateReferenceSystem());
    }

    public Geometry preProcess(Geometry geometry) throws TransformException, FactoryException {
        Geometry mask;
        if (this.validAreaBounds == null) {
            return geometry;
        }
        SingleCRS geometryCRS = CRS.getHorizontalCRS((CoordinateReferenceSystem)this.sourceCRS);
        if (geometryCRS == null || CRS.findMathTransform((CoordinateReferenceSystem)geometryCRS, (CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem()).isIdentity()) {
            return geometry;
        }
        ReferencedEnvelope ge = new ReferencedEnvelope(geometry.getEnvelopeInternal(), (CoordinateReferenceSystem)geometryCRS);
        ReferencedEnvelope geWGS84 = ge.transform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, true);
        if (geWGS84.getWidth() < 1.0E-6 || geWGS84.getHeight() < 1.0E-6) {
            geWGS84.expandBy(1.0E-6);
        }
        if (this.validArea == null) {
            if (this.validAreaBounds.contains(geWGS84)) {
                return geometry;
            }
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.isEmpty()) {
                return null;
            }
            ReferencedEnvelope envInt = envIntWgs84.transform((CoordinateReferenceSystem)geometryCRS, true);
            mask = JTS.toGeometry((Envelope)envInt);
        } else {
            if (this.validaAreaTester.contains(JTS.toGeometry(geWGS84))) {
                return geometry;
            }
            ReferencedEnvelope envIntWgs84 = new ReferencedEnvelope(this.validAreaBounds.intersection(geWGS84), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
            if (envIntWgs84.isEmpty()) {
                return null;
            }
            Polygon polyIntWgs84 = JTS.toGeometry(envIntWgs84);
            Geometry maskWgs84 = this.intersect(this.validArea, polyIntWgs84, (CoordinateReferenceSystem)geometryCRS);
            if (maskWgs84 == null || maskWgs84.isEmpty()) {
                return null;
            }
            mask = JTS.transform(maskWgs84, CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)geometryCRS));
        }
        return this.intersect(geometry, mask, (CoordinateReferenceSystem)geometryCRS);
    }

    protected Geometry intersect(Geometry geometry, Geometry mask, CoordinateReferenceSystem geometryCRS) {
        Geometry result;
        block19: {
            if (geometry instanceof GeometryCollection) {
                int numGeometries = geometry.getNumGeometries();
                if (numGeometries == 1) {
                    geometry = geometry.getGeometryN(0);
                } else {
                    ArrayList<Geometry> elements = new ArrayList<Geometry>();
                    String geometryType = numGeometries > 0 ? geometry.getGeometryN(0).getGeometryType() : null;
                    for (int i = 0; i < numGeometries; ++i) {
                        Geometry intersected;
                        Geometry g = geometry.getGeometryN(i);
                        if (!g.getEnvelopeInternal().intersects(mask.getEnvelopeInternal()) || (intersected = this.intersect(g, mask, geometryCRS)) == null) continue;
                        if (intersected.getGeometryType().equals(geometryType)) {
                            elements.add(intersected);
                            continue;
                        }
                        if (!(intersected instanceof GeometryCollection)) continue;
                        this.addGeometries(elements, (GeometryCollection)intersected, geometryType);
                    }
                    if (elements.size() == 0) {
                        return null;
                    }
                    if (geometry instanceof MultiPoint) {
                        Point[] array = elements.toArray(new Point[elements.size()]);
                        return geometry.getFactory().createMultiPoint(array);
                    }
                    if (geometry instanceof MultiLineString) {
                        LineString[] array = elements.toArray(new LineString[elements.size()]);
                        return geometry.getFactory().createMultiLineString(array);
                    }
                    if (geometry instanceof MultiPolygon) {
                        Polygon[] array = elements.toArray(new Polygon[elements.size()]);
                        return geometry.getFactory().createMultiPolygon(array);
                    }
                    Geometry[] array = elements.toArray(new Geometry[elements.size()]);
                    return geometry.getFactory().createGeometryCollection(array);
                }
            }
            result = null;
            try {
                result = geometry.intersection(mask);
            }
            catch (Exception e1) {
                double precision = CRS.getProjectedCRS((CoordinateReferenceSystem)geometryCRS) != null ? 0.001 : 1.0E-8;
                for (int i = 0; i < 6; ++i) {
                    GeometryPrecisionReducer reducer = new GeometryPrecisionReducer(new PrecisionModel(1.0 / precision));
                    Geometry reduced = reducer.reduce(geometry);
                    try {
                        if (LOGGER.isLoggable(Level.FINE)) {
                            LOGGER.log(Level.FINE, "Failed to intersect the geometry with the projection area of validity mask, trying a precision reduction approach with a precision of " + precision);
                        }
                        result = reduced.intersection(mask);
                        break;
                    }
                    catch (Exception e3) {
                        precision *= 10.0;
                        continue;
                    }
                }
                if (result != null) break block19;
                LOGGER.log(Level.WARNING, "Failed to intersect the geometry with the projection area of validity mask, returning the original geometry: " + geometry);
                result = geometry;
            }
        }
        if (result.isEmpty() && geometry.intersects(mask)) {
            try {
                result = EnhancedPrecisionOp.intersection(geometry, mask);
            }
            catch (Exception e2) {
                result = geometry;
            }
        }
        if (result.isEmpty()) {
            return null;
        }
        return result;
    }

    public MathTransform getRenderingTransform(MathTransform mt) throws FactoryException {
        ArrayList<MathTransform> elements = new ArrayList<MathTransform>();
        this.accumulateTransforms(mt, elements);
        ArrayList<MathTransform> wrapped = new ArrayList<MathTransform>();
        ArrayList<MathTransform> datumShiftChain = null;
        boolean datumShiftDetected = false;
        for (MathTransform element : elements) {
            if (datumShiftChain != null) {
                datumShiftChain.add(element);
                if (!element.getClass().getName().equals(GeocentricTransform.class.getName() + "$Inverse")) continue;
                datumShiftDetected = true;
                MathTransform combined = this.concatenateTransforms(datumShiftChain);
                GeographicOffsetWrapper wrapper = new GeographicOffsetWrapper(combined);
                wrapped.add(wrapper);
                datumShiftChain = null;
                continue;
            }
            if (element instanceof GeocentricTransform) {
                datumShiftChain = new ArrayList<MathTransform>();
                datumShiftChain.add(element);
                continue;
            }
            wrapped.add(element);
        }
        if (datumShiftDetected) {
            if (datumShiftChain != null) {
                wrapped.addAll(datumShiftChain);
            }
            return this.concatenateTransforms(wrapped);
        }
        return mt;
    }

    protected MathTransform concatenateTransforms(List<MathTransform> datumShiftChain) {
        if (datumShiftChain.size() == 1) {
            return datumShiftChain.get(0);
        }
        MathTransform mt = ConcatenatedTransform.create((MathTransform)datumShiftChain.get(0), (MathTransform)datumShiftChain.get(1));
        for (int i = 2; i < datumShiftChain.size(); ++i) {
            MathTransform curr = datumShiftChain.get(i);
            mt = ConcatenatedTransform.create((MathTransform)mt, (MathTransform)curr);
        }
        return mt;
    }

    protected void accumulateTransforms(MathTransform mt, List<MathTransform> elements) {
        if (mt instanceof ConcatenatedTransform) {
            ConcatenatedTransform ct = (ConcatenatedTransform)mt;
            this.accumulateTransforms(ct.transform1, elements);
            this.accumulateTransforms(ct.transform2, elements);
        } else {
            elements.add(mt);
        }
    }

    public Geometry postProcess(MathTransform mt, Geometry geometry) {
        return geometry;
    }

    public ReferencedEnvelope getValidAreaBounds() {
        return this.validAreaBounds;
    }

    protected void setCentralMeridian(double centralMeridian) {
        MathTransform mt;
        try {
            CoordinateReferenceSystem targetCRS = this.renderingEnvelope.getCoordinateReferenceSystem();
            mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)targetCRS, (boolean)true);
            double[] src = new double[]{centralMeridian, 0.0, 180.0 + centralMeridian, 0.0};
            double[] dst = new double[4];
            mt.transform(src, 0, dst, 0, 2);
            this.radius = CRS.getAxisOrder((CoordinateReferenceSystem)targetCRS) == CRS.AxisOrder.NORTH_EAST ? Math.abs(dst[3] - dst[1]) : Math.abs(dst[2] - dst[0]);
            if (this.radius <= 0.0) {
                throw new RuntimeException("Computed Earth radius is 0, what is going on?");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error computing the Earth radius in the current projection", e);
        }
        try {
            double[] ordinates = new double[]{180.0, -80.0, 180.0, 80.0};
            mt = CRS.findMathTransform((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (CoordinateReferenceSystem)this.renderingEnvelope.getCoordinateReferenceSystem());
            mt.transform(ordinates, 0, ordinates, 0, 2);
            this.datelineX = ordinates[0];
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void addGeometries(List<Geometry> geoms, GeometryCollection collection, String geometryType) {
        if (geoms == null) {
            return;
        }
        if (geometryType == null || geometryType.isEmpty()) {
            return;
        }
        if (collection == null || collection.getNumGeometries() <= 0) {
            return;
        }
        int numGeometries = collection.getNumGeometries();
        for (int i = 0; i < numGeometries; ++i) {
            Geometry geo = collection.getGeometryN(i);
            if (geo.getGeometryType().equals(geometryType)) {
                geoms.add(geo);
                continue;
            }
            if (!(geo instanceof GeometryCollection)) continue;
            this.addGeometries(geoms, (GeometryCollection)geo, geometryType);
        }
    }
}

