/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.property;

import com.vividsolutions.jts.geom.CoordinateSequenceFactory;
import com.vividsolutions.jts.geom.GeometryFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Set;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureReader;
import org.geotools.data.Query;
import org.geotools.data.QueryCapabilities;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.property.PropertyFeatureReader;
import org.geotools.data.store.ContentEntry;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.factory.Hints;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.geometry.jts.WKTReader2;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

public class PropertyFeatureSource
extends ContentFeatureSource {
    String typeName;
    SimpleFeatureType featureType;
    PropertyDataStore store;

    public PropertyFeatureSource(ContentEntry entry, Query query) {
        super(entry, query);
        this.store = (PropertyDataStore)entry.getDataStore();
        this.typeName = entry.getTypeName();
    }

    @Override
    protected void addHints(Set<Hints.Key> hints) {
        hints.add(Hints.FEATURE_DETACHED);
    }

    @Override
    public PropertyDataStore getDataStore() {
        return (PropertyDataStore)super.getDataStore();
    }

    @Override
    protected QueryCapabilities buildQueryCapabilities() {
        return new QueryCapabilities(){

            @Override
            public boolean isUseProvidedFIDSupported() {
                return true;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ReferencedEnvelope getBoundsInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            ReferencedEnvelope bounds = ReferencedEnvelope.create(this.getSchema().getCoordinateReferenceSystem());
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
                while (featureReader.hasNext()) {
                    SimpleFeature feature = featureReader.next();
                    bounds.include(feature.getBounds());
                }
            }
            return bounds;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected int getCountInternal(Query query) throws IOException {
        if (query.getFilter() == Filter.INCLUDE) {
            int count = 0;
            try (FeatureReader<SimpleFeatureType, SimpleFeature> featureReader = this.getReaderInternal(query);){
                while (featureReader.hasNext()) {
                    featureReader.next();
                    ++count;
                }
            }
            return count;
        }
        return -1;
    }

    @Override
    protected SimpleFeatureType buildFeatureType() throws IOException {
        String typeName = this.getEntry().getTypeName();
        String namespace = this.getEntry().getName().getNamespaceURI();
        String typeSpec = this.property("_");
        try {
            return DataUtilities.createType(namespace, typeName, typeSpec);
        }
        catch (SchemaException e) {
            e.printStackTrace();
            throw new DataSourceException(typeName + " schema not available", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String property(String key) throws IOException {
        File file = new File(this.store.dir, this.typeName + ".properties");
        try (BufferedReader reader = new BufferedReader(new FileReader(file));){
            String line = reader.readLine();
            while (line != null) {
                if (line.startsWith(key + "=")) {
                    String string = line.substring(key.length() + 1);
                    return string;
                }
                line = reader.readLine();
            }
        }
        return null;
    }

    @Override
    protected FeatureReader<SimpleFeatureType, SimpleFeature> getReaderInternal(Query query) throws IOException {
        File file = new File(this.store.dir, this.typeName + ".properties");
        PropertyFeatureReader reader = new PropertyFeatureReader(this.store.getNamespaceURI(), file, this.getGeometryFactory(query));
        Double tolerance = (Double)query.getHints().get((Object)Hints.LINEARIZATION_TOLERANCE);
        if (tolerance != null) {
            reader.setWKTReader(new WKTReader2(tolerance));
        }
        return reader;
    }

    private GeometryFactory getGeometryFactory(Query query) {
        Hints hints = query.getHints();
        GeometryFactory geometryFactory = (GeometryFactory)hints.get((Object)Hints.JTS_GEOMETRY_FACTORY);
        if (geometryFactory == null) {
            CoordinateSequenceFactory csFactory = (CoordinateSequenceFactory)hints.get((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY);
            geometryFactory = csFactory != null ? new GeometryFactory(csFactory) : new GeometryFactory();
        }
        return geometryFactory;
    }

    @Override
    protected boolean handleVisitor(Query query, FeatureVisitor visitor) throws IOException {
        return super.handleVisitor(query, visitor);
    }
}

