/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

import org.geowebcache.diskquota.storage.SystemUtils;

public class TilePage {
    private long id;
    private String tileSetId;
    private String key;
    private byte pageZ;
    private int pageY;
    private int pageX;
    private int creationTimeMinutes;

    public TilePage() {
    }

    public TilePage(String tileSetId, int pageX, int pageY, int zoomLevel, int creationTimeMinutes) {
        this.tileSetId = tileSetId;
        this.pageX = pageX;
        this.pageY = pageY;
        this.pageZ = (byte)zoomLevel;
        this.creationTimeMinutes = creationTimeMinutes;
        StringBuilder sb = new StringBuilder(128);
        TilePage.computeId(tileSetId, pageX, pageY, zoomLevel, sb);
        this.key = sb.toString();
    }

    public TilePage(String tileSetId, int pageX, int pageY, int zoomLevel) {
        this(tileSetId, pageX, pageY, zoomLevel, SystemUtils.get().currentTimeMinutes());
    }

    public static void computeId(String tileSetId, int pageX, int pageY, int pageZ, StringBuilder target) {
        target.append(tileSetId).append('@').append(pageX).append(',').append(pageY).append(',').append(pageZ).toString();
    }

    public long getId() {
        return this.id;
    }

    public String getKey() {
        return this.key;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TilePage)) {
            return false;
        }
        TilePage t = (TilePage)o;
        return this.key.equals(t.key);
    }

    public int hashCode() {
        return 17 * this.key.hashCode();
    }

    public String getTileSetId() {
        return this.tileSetId;
    }

    public byte getZoomLevel() {
        return this.pageZ;
    }

    public int getPageY() {
        return this.pageY;
    }

    public int getPageX() {
        return this.pageX;
    }

    public int getCreationTimeMinutes() {
        return this.creationTimeMinutes;
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.key + ']';
    }
}

