/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.util.concurrent.BlockingQueue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.DiskQuotaConfig;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdate;
import org.geowebcache.storage.BlobStoreListener;
import org.springframework.util.Assert;

class QueuedQuotaUpdatesProducer
implements BlobStoreListener {
    private static final Log log = LogFactory.getLog(QueuedQuotaUpdatesProducer.class);
    private final DiskQuotaConfig quotaConfig;
    private final BlockingQueue<QuotaUpdate> queuedUpdates;
    private boolean cancelled;
    private final QuotaStore quotaStore;

    public QueuedQuotaUpdatesProducer(DiskQuotaConfig quotaConfig, BlockingQueue<QuotaUpdate> queuedUpdates, QuotaStore quotaStore) {
        Assert.notNull((Object)quotaConfig, (String)"quotaConfig can't be null");
        Assert.notNull(queuedUpdates, (String)"queuedUpdates can't be null");
        this.quotaConfig = quotaConfig;
        this.queuedUpdates = queuedUpdates;
        this.quotaStore = quotaStore;
    }

    public void tileStored(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize) {
        if (blobSize == 0L) {
            return;
        }
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, blobSize, new long[]{x, y, z});
    }

    public void tileDeleted(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize) {
        long actualSizeFreed = -1L * blobSize;
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, actualSizeFreed, new long[]{x, y, z});
    }

    public void tileUpdated(String layerName, String gridSetId, String blobFormat, String parametersId, long x, long y, int z, long blobSize, long oldSize) {
        long delta = blobSize - oldSize;
        if (delta == 0L) {
            return;
        }
        long[] tileIndex = new long[]{x, y, z};
        this.quotaUpdate(layerName, gridSetId, blobFormat, parametersId, delta, tileIndex);
    }

    public void layerDeleted(String layerName) {
        this.quotaStore.deleteLayer(layerName);
    }

    public void gridSubsetDeleted(String layerName, String gridSetId) {
        this.quotaStore.deleteGridSubset(layerName, gridSetId);
    }

    public void layerRenamed(String oldLayerName, String newLayerName) {
        try {
            this.quotaStore.renameLayer(oldLayerName, newLayerName);
        }
        catch (InterruptedException e) {
            log.error((Object)("Can't rename " + oldLayerName + " to " + newLayerName + " in quota store"), (Throwable)e);
        }
    }

    private void quotaUpdate(String layerName, String gridSetId, String blobFormat, String parametersId, long amount, long[] tileIndex) {
        if (this.cancelled(layerName)) {
            return;
        }
        QuotaUpdate payload = new QuotaUpdate(layerName, gridSetId, blobFormat, parametersId, amount, tileIndex);
        try {
            this.queuedUpdates.put(payload);
        }
        catch (InterruptedException e) {
            if (this.cancelled(layerName)) {
                return;
            }
            log.info((Object)("Quota updates on " + layerName + " abruptly interrupted on thread " + Thread.currentThread().getName() + "."));
        }
    }

    private boolean cancelled(String layerName) {
        if (this.cancelled) {
            log.debug((Object)("Quota updates listener cancelled. Avoiding adding update for layer " + layerName + " to quota information queue"));
        }
        return this.cancelled;
    }

    public void setCancelled(boolean cancelled) {
        this.cancelled = cancelled;
    }
}

