/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota;

import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geowebcache.diskquota.QuotaStore;
import org.geowebcache.diskquota.QuotaUpdate;
import org.geowebcache.diskquota.storage.PageStatsPayload;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.diskquota.storage.TilePage;
import org.geowebcache.diskquota.storage.TilePageCalculator;
import org.geowebcache.diskquota.storage.TileSet;
import org.springframework.util.Assert;

public class QueuedQuotaUpdatesConsumer
implements Callable<Long>,
Serializable {
    private static final Log log = LogFactory.getLog(QueuedQuotaUpdatesConsumer.class);
    private static final long serialVersionUID = -625181087112272266L;
    private static final long DEFAULT_SYNC_TIMEOUT = 2000L;
    private static final int MAX_AGGREGATES_BEFORE_COMMIT = 1000;
    private final QuotaStore quotaStore;
    private final TilePageCalculator tilePageCalculator;
    private final BlockingQueue<QuotaUpdate> queue;
    private Map<TileSet, TimedQuotaUpdate> aggregatedDelayedUpdates;

    public QueuedQuotaUpdatesConsumer(QuotaStore quotaStore, BlockingQueue<QuotaUpdate> queue) {
        Assert.notNull((Object)quotaStore, (String)"quotaStore can't be null");
        Assert.notNull(queue, (String)"queue can't be null");
        this.quotaStore = quotaStore;
        this.tilePageCalculator = quotaStore.getTilePageCalculator();
        this.queue = queue;
        this.aggregatedDelayedUpdates = new HashMap<TileSet, TimedQuotaUpdate>();
    }

    @Override
    public Long call() {
        while (true) {
            if (Thread.interrupted()) {
                log.debug((Object)("Job " + this.getClass().getSimpleName() + " finished due to interrupted thread."));
                break;
            }
            try {
                QuotaUpdate updateData = this.queue.poll(2000L, TimeUnit.MILLISECONDS);
                if (updateData != null) {
                    this.performAggregatedUpdate(updateData);
                }
                this.checkAggregatedTimeouts();
                continue;
            }
            catch (InterruptedException e) {
                log.info((Object)"Shutting down quota update background task due to InterruptedException");
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
        return null;
    }

    private void performAggregatedUpdate(QuotaUpdate updateData) throws InterruptedException {
        TileSet tileSet = updateData.getTileSet();
        TimedQuotaUpdate accumulatedUpdate = this.aggregatedDelayedUpdates.get(tileSet);
        if (accumulatedUpdate == null) {
            accumulatedUpdate = new TimedQuotaUpdate(tileSet, this.tilePageCalculator);
            this.aggregatedDelayedUpdates.put(tileSet, accumulatedUpdate);
        }
        accumulatedUpdate.add(updateData);
    }

    private void checkAggregatedTimeouts() throws InterruptedException {
        if (this.aggregatedDelayedUpdates.size() == 0) {
            return;
        }
        ArrayList<TileSet> pruneList = null;
        for (TimedQuotaUpdate timedUpadte : this.aggregatedDelayedUpdates.values()) {
            boolean prune;
            if (pruneList == null) {
                pruneList = new ArrayList<TileSet>(2);
            }
            if (!(prune = this.checkAggregatedTimeout(timedUpadte))) continue;
            pruneList.add(timedUpadte.getTileSet());
        }
        this.prune(pruneList);
    }

    private void prune(List<TileSet> pruneList) {
        if (pruneList != null && pruneList.size() > 0) {
            for (TileSet ts : pruneList) {
                this.aggregatedDelayedUpdates.remove(ts);
            }
        }
    }

    private boolean checkAggregatedTimeout(TimedQuotaUpdate timedUpadte) throws InterruptedException {
        boolean canWaitABitLonger;
        long creationTime = timedUpadte.creationTime;
        long timeSinceLastCommit = System.currentTimeMillis() - creationTime;
        boolean timeout = timeSinceLastCommit >= 2000L;
        int numAggregations = timedUpadte.numAggregations;
        boolean tooManyPendingCommits = numAggregations >= 1000;
        boolean bl = canWaitABitLonger = timeSinceLastCommit < 2000L && timedUpadte.tilePages.size() < 1000;
        if (!canWaitABitLonger && (timeout || tooManyPendingCommits)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Committing " + timedUpadte + " to quota store due to " + (tooManyPendingCommits ? "too many pending commits" : "max wait time reached")));
            }
            this.commit(timedUpadte);
            return true;
        }
        return false;
    }

    private void commit(TimedQuotaUpdate aggregatedUpadte) throws InterruptedException {
        TileSet tileSet = aggregatedUpadte.getTileSet();
        Quota quotaDiff = aggregatedUpadte.getAccummulatedQuotaDifference();
        ArrayList<PageStatsPayload> tileCountDiffs = new ArrayList<PageStatsPayload>(aggregatedUpadte.getAccummulatedTilePageCounts());
        if (quotaDiff.getBytes().compareTo(BigInteger.ZERO) == 0 && tileCountDiffs.size() == 0) {
            return;
        }
        this.quotaStore.addToQuotaAndTileCounts(tileSet, quotaDiff, tileCountDiffs);
    }

    private static class TimedQuotaUpdate {
        private final TilePageCalculator tpc;
        private final TileSet tileSet;
        private final long creationTime;
        private int numAggregations;
        private Quota accumQuotaDiff;
        private Map<String, PageStatsPayload> tilePages;
        private StringBuilder pageIdTarget;
        private int[] pageIndexTarget;

        public TimedQuotaUpdate(TileSet tileSet, TilePageCalculator tpc) {
            this.tileSet = tileSet;
            this.tpc = tpc;
            this.creationTime = System.currentTimeMillis();
            this.tilePages = new HashMap<String, PageStatsPayload>();
            this.pageIndexTarget = new int[3];
            this.pageIdTarget = new StringBuilder(128);
            this.accumQuotaDiff = new Quota();
        }

        public void add(QuotaUpdate quotaUpdate) {
            String tileSetId = this.tileSet.getId();
            long size = quotaUpdate.getSize();
            this.accumQuotaDiff.addBytes(quotaUpdate.getSize());
            long[] tileIndex = quotaUpdate.getTileIndex();
            this.tpc.pageIndexForTile(this.tileSet, tileIndex, this.pageIndexTarget);
            int pageX = this.pageIndexTarget[0];
            int pageY = this.pageIndexTarget[1];
            byte pageZ = (byte)this.pageIndexTarget[2];
            this.pageIdTarget.setLength(0);
            TilePage.computeId(tileSetId, pageX, pageY, pageZ, this.pageIdTarget);
            String pageIdForTile = this.pageIdTarget.toString();
            int tileCountDiff = size > 0L ? 1 : -1;
            PageStatsPayload payload = this.tilePages.get(pageIdForTile);
            if (payload == null) {
                TilePage page = new TilePage(tileSetId, pageX, pageY, pageZ);
                payload = new PageStatsPayload(page);
                this.tilePages.put(pageIdForTile, payload);
            }
            int previousCount = payload.getNumTiles();
            payload.setNumTiles(previousCount + tileCountDiff);
            ++this.numAggregations;
        }

        public TileSet getTileSet() {
            return this.tileSet;
        }

        public Quota getAccummulatedQuotaDifference() {
            return this.accumQuotaDiff;
        }

        public Collection<PageStatsPayload> getAccummulatedTilePageCounts() {
            return this.tilePages.values();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(91);
            sb.append(this.tileSet);
            sb.append(this.numAggregations).append(" aggregated updates, ");
            sb.append(this.tilePages.size()).append(" different pages, ");
            sb.append("accum quota diff: ").append(this.accumQuotaDiff.toNiceString());
            sb.append(", created ").append(System.currentTimeMillis() - this.creationTime).append("ms ago").append(']');
            return sb.toString();
        }
    }
}

