/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml.v1_1_0;

import java.io.Reader;
import java.util.Map;
import javax.xml.namespace.QName;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.XmlRequestReader;
import org.geoserver.util.EntityResolverProvider;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.xml.WFSXmlUtils;
import org.geotools.util.Version;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;

public class WfsXmlReader
extends XmlRequestReader {
    WFSInfo wfs;
    Configuration configuration;
    GeoServer geoServer;
    EntityResolverProvider entityResolverProvider;

    public WfsXmlReader(String element, GeoServer gs, Configuration configuration) {
        this(element, gs, configuration, "wfs");
    }

    protected WfsXmlReader(String element, GeoServer gs, Configuration configuration, String serviceId) {
        super(new QName("http://www.opengis.net/wfs", element), new Version("1.1.0"), serviceId);
        this.geoServer = gs;
        this.wfs = (WFSInfo)gs.getService(WFSInfo.class);
        this.configuration = configuration;
        this.entityResolverProvider = new EntityResolverProvider(this.geoServer);
    }

    public Object read(Object request, Reader reader, Map kvp) throws Exception {
        this.configuration.getProperties().add(Parser.Properties.PARSE_UNKNOWN_ELEMENTS);
        Parser parser = new Parser(this.configuration);
        parser.setEntityResolver(this.entityResolverProvider.getEntityResolver());
        WFSXmlUtils.initRequestParser(parser, this.wfs, this.geoServer, kvp);
        Object parsed = WFSXmlUtils.parseRequest(parser, reader, this.wfs);
        WFSXmlUtils.checkValidationErrors(parser, this);
        return parsed;
    }
}

