/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.xml;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.xsd.XSDSchema;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wfs.xml.FeatureTypeSchemaBuilder;
import org.geotools.xml.XSD;

public class ApplicationSchemaXSD2
extends XSD {
    FeatureTypeSchemaBuilder schemaBuilder;
    Map<String, Set<FeatureTypeInfo>> featureTypes;
    String baseURL;

    public ApplicationSchemaXSD2(FeatureTypeSchemaBuilder schemaBuilder, Map<String, Set<FeatureTypeInfo>> featureTypes) {
        this.schemaBuilder = schemaBuilder;
        this.featureTypes = featureTypes;
    }

    public String getNamespaceURI() {
        if (this.featureTypes.size() == 1) {
            return this.featureTypes.keySet().iterator().next();
        }
        return null;
    }

    public void setBaseURL(String baseURL) {
        this.baseURL = baseURL;
    }

    public String getBaseURL() {
        return this.baseURL;
    }

    public String getSchemaLocation() {
        StringBuilder sb = new StringBuilder();
        for (Set<FeatureTypeInfo> fts : this.featureTypes.values()) {
            for (FeatureTypeInfo ft : fts) {
                sb.append(ft.getPrefixedName()).append(",");
            }
        }
        sb.setLength(sb.length() - 1);
        HashMap<String, String> kvp = new HashMap<String, String>();
        kvp.putAll(this.schemaBuilder.getDescribeFeatureTypeParams());
        kvp.put("typename", sb.toString());
        return ResponseUtils.buildURL((String)this.baseURL, (String)"wfs", kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE);
    }

    protected XSDSchema buildSchema() throws IOException {
        HashSet<FeatureTypeInfo> types = new HashSet<FeatureTypeInfo>();
        for (Set<FeatureTypeInfo> fts : this.featureTypes.values()) {
            types.addAll(fts);
        }
        return this.schemaBuilder.build(types.toArray(new FeatureTypeInfo[types.size()]), this.baseURL, 1);
    }
}

