/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;

public class RemappingFeatureCollection
extends DecoratingSimpleFeatureCollection {
    Map<String, String> attributesMapping;

    public RemappingFeatureCollection(SimpleFeatureCollection delegate, Map<String, String> attributesMapping) {
        super(delegate);
        this.attributesMapping = attributesMapping;
    }

    public SimpleFeatureType getSchema() {
        return this.remapSchema((SimpleFeatureType)this.delegate.getSchema());
    }

    static Map<String, String> invertMappings(Map<String, String> map) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (String key : map.keySet()) {
            result.put(map.get(key), key);
        }
        return result;
    }

    private SimpleFeatureType remapSchema(SimpleFeatureType schema) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.setName(schema.getName());
        for (AttributeDescriptor attDesc : schema.getAttributeDescriptors()) {
            if (attDesc instanceof GeometryDescriptor) {
                GeometryDescriptor geoDesc = (GeometryDescriptor)attDesc;
                builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding(), geoDesc.getCoordinateReferenceSystem());
                continue;
            }
            List filters = attDesc.getType().getRestrictions();
            if (filters != null && !filters.isEmpty()) {
                builder.restrictions(filters);
            }
            builder.add(this.attributesMapping.get(attDesc.getLocalName()), attDesc.getType().getBinding());
        }
        return builder.buildFeatureType();
    }

    public SimpleFeatureIterator features() {
        return new RemappingIterator(this.delegate.features(), this.attributesMapping, this.getSchema());
    }

    static SimpleFeature remap(SimpleFeature source, Map<String, String> attributeMappings, SimpleFeatureBuilder builder) {
        SimpleFeatureType target = builder.getFeatureType();
        for (int i = 0; i < target.getAttributeCount(); ++i) {
            AttributeDescriptor attributeType = target.getDescriptor(i);
            Object value = null;
            String mappedName = attributeMappings.get(attributeType.getLocalName());
            if (source.getFeatureType().getDescriptor(mappedName) != null) {
                value = source.getAttribute(mappedName);
            }
            builder.add(value);
        }
        return builder.buildFeature(source.getIdentifier().getID());
    }

    public static class RemappingIterator
    implements SimpleFeatureIterator {
        Map<String, String> attributesMapping;
        SimpleFeatureIterator delegate;
        SimpleFeatureBuilder builder;

        public RemappingIterator(SimpleFeatureIterator delegate, Map attributesMapping, SimpleFeatureType schema) {
            this.delegate = delegate;
            this.attributesMapping = RemappingFeatureCollection.invertMappings(attributesMapping);
            this.builder = new SimpleFeatureBuilder(schema);
        }

        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        public SimpleFeature next() {
            return RemappingFeatureCollection.remap((SimpleFeature)this.delegate.next(), this.attributesMapping, this.builder);
        }

        public void close() {
            this.delegate.close();
        }
    }
}

