/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import javax.xml.namespace.QName;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.response.WFSResponse;
import org.geoserver.wfs.xml.v1_1_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureResponse
extends WFSResponse {
    Catalog catalog;
    WFSConfiguration configuration;

    public FeatureResponse(GeoServer gs, WFSConfiguration configuration) {
        super(gs, SimpleFeature.class);
        this.catalog = gs.getCatalog();
        this.configuration = configuration;
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml; subtype=gml/3.1.1";
    }

    public void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        SimpleFeature feature = (SimpleFeature)value;
        SimpleFeatureType featureType = feature.getType();
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(featureType.getName());
        Encoder encoder = new Encoder((Configuration)this.configuration);
        encoder.setEncoding(Charset.forName(this.getInfo().getGeoServer().getSettings().getCharset()));
        encoder.encode((Object)feature, new QName(meta.getNamespace().getURI(), meta.getName()), output);
    }
}

