/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.response;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.sql.Date;
import java.sql.Time;
import java.text.NumberFormat;
import java.util.Collection;
import java.util.Iterator;
import java.util.Locale;
import java.util.regex.Pattern;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.impl.XSDElementDeclarationImpl;
import org.geoserver.config.GeoServer;
import org.geoserver.feature.FlatteningFeatureCollection;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.type.DateUtil;
import org.opengis.feature.Feature;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;

public class CSVOutputFormat
extends WFSGetFeatureOutputFormat {
    static final Pattern CSV_ESCAPES = Pattern.compile("[\"\n,\r]");

    public CSVOutputFormat(GeoServer gs) {
        super(gs, "csv");
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/csv";
    }

    public String getPreferredDisposition(Object value, Operation operation) {
        return "attachment";
    }

    public String getAttachmentFileName(Object value, Operation operation) {
        GetFeatureRequest request = GetFeatureRequest.adapt(operation.getParameters()[0]);
        String outputFileName = request.getQueries().get(0).getTypeNames().get(0).getLocalPart();
        return outputFileName + ".csv";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation getFeature) throws IOException, ServiceException {
        BufferedWriter w = new BufferedWriter(new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset()));
        FeatureCollection fc = featureCollection.getFeature().get(0);
        if (fc.getSchema() instanceof SimpleFeatureType) {
            fc = FlatteningFeatureCollection.flatten((SimpleFeatureCollection)((SimpleFeatureCollection)fc));
            SimpleFeatureType ft = (SimpleFeatureType)fc.getSchema();
            w.write("FID,");
            for (int i = 0; i < ft.getAttributeCount(); ++i) {
                AttributeDescriptor ad = ft.getDescriptor(i);
                w.write(this.prepCSVField(ad.getLocalName()));
                if (i >= ft.getAttributeCount() - 1) continue;
                w.write(",");
            }
        } else {
            w.write("gml:id,");
            int i = 0;
            for (PropertyDescriptor att : fc.getSchema().getDescriptors()) {
                if (att.getName().getLocalPart().startsWith("FEATURE_LINK")) continue;
                if (i > 0) {
                    w.write(",");
                }
                String elName = att.getName().toString();
                Object xsd = att.getUserData().get(XSDElementDeclaration.class);
                if (xsd != null && xsd instanceof XSDElementDeclarationImpl) {
                    XSDElementDeclarationImpl xsdEl = (XSDElementDeclarationImpl)xsd;
                    elName = xsdEl.getQName();
                }
                w.write(this.prepCSVField(elName));
                ++i;
            }
        }
        w.write("\r\n");
        NumberFormat coordFormatter = NumberFormat.getInstance(Locale.US);
        coordFormatter.setMaximumFractionDigits(this.getInfo().getGeoServer().getSettings().getNumDecimals());
        coordFormatter.setGroupingUsed(false);
        try (FeatureIterator i = fc.features();){
            while (i.hasNext()) {
                Feature f = i.next();
                w.write(this.prepCSVField(f.getIdentifier().getID()));
                w.write(",");
                if (f instanceof SimpleFeature) {
                    for (int j = 0; j < ((SimpleFeature)f).getAttributeCount(); ++j) {
                        Object att = ((SimpleFeature)f).getAttribute(j);
                        if (att != null) {
                            String value = this.formatToString(att, coordFormatter);
                            w.write(this.prepCSVField(value));
                        }
                        if (j >= ((SimpleFeature)f).getAttributeCount() - 1) continue;
                        w.write(",");
                    }
                } else {
                    Iterator descriptors = fc.getSchema().getDescriptors().iterator();
                    int j = 0;
                    while (descriptors.hasNext()) {
                        PropertyDescriptor desc = (PropertyDescriptor)descriptors.next();
                        if (desc.getName().getLocalPart().startsWith("FEATURE_LINK")) continue;
                        if (j > 0) {
                            w.write(",");
                        }
                        ++j;
                        Collection values = f.getProperties(desc.getName());
                        if (values.size() > 1) {
                            throw new UnsupportedOperationException("Multi valued properties aren't supported with CSV format!");
                        }
                        Object att = null;
                        if (!values.isEmpty()) {
                            att = ((Property)values.iterator().next()).getValue();
                        }
                        if (att == null) continue;
                        String value = this.formatToString(att, coordFormatter);
                        w.write(this.prepCSVField(value));
                    }
                }
                w.write("\r\n");
            }
        }
        w.flush();
    }

    private String formatToString(Object att, NumberFormat coordFormatter) {
        String value = null;
        value = att instanceof Number ? coordFormatter.format(att) : (att instanceof java.util.Date ? (att instanceof Date ? DateUtil.serializeSqlDate((Date)((Date)att)) : (att instanceof Time ? DateUtil.serializeSqlTime((Time)((Time)att)) : DateUtil.serializeDateTime((java.util.Date)((java.util.Date)att)))) : att.toString());
        return value;
    }

    private String prepCSVField(String field) {
        String mod = field.replaceAll("\"", "\"\"");
        if (CSV_ESCAPES.matcher(mod).find()) {
            mod = "\"" + mod + "\"";
        }
        return mod;
    }

    @Override
    public String getCapabilitiesElementName() {
        return "CSV";
    }

    public String getCharset(Operation operation) {
        return this.gs.getGlobal().getSettings().getCharset();
    }
}

