/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.request;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import net.opengis.wfs.AllSomeType;
import net.opengis.wfs.DeleteElementType;
import net.opengis.wfs.InsertElementType;
import net.opengis.wfs.UpdateElementType;
import net.opengis.wfs.WfsFactory;
import net.opengis.wfs20.DeleteType;
import net.opengis.wfs20.InsertType;
import net.opengis.wfs20.NativeType;
import net.opengis.wfs20.ReplaceType;
import net.opengis.wfs20.TransactionResponseType;
import net.opengis.wfs20.TransactionType;
import net.opengis.wfs20.UpdateType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.geoserver.wfs.request.Delete;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.Native;
import org.geoserver.wfs.request.Replace;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionResponse;
import org.geoserver.wfs.request.Update;
import org.geotools.data.Transaction;

public abstract class TransactionRequest
extends RequestObject {
    private Transaction transaction;

    public static TransactionRequest adapt(Object request) {
        if (request instanceof net.opengis.wfs.TransactionType) {
            return new WFS11((EObject)request);
        }
        if (request instanceof TransactionType) {
            return new WFS20((EObject)request);
        }
        return null;
    }

    protected TransactionRequest(EObject adaptee) {
        super(adaptee);
    }

    public Object getReleaseAction() {
        return this.eGet(this.adaptee, "releaseAction", Object.class);
    }

    public String getLockId() {
        return this.eGet(this.adaptee, "lockId", String.class);
    }

    public void setLockId(String lockId) {
        this.eSet(this.adaptee, "lockId", lockId);
    }

    public Transaction getTransaction() {
        return this.transaction;
    }

    public void setTransaction(Transaction transaction) {
        this.transaction = transaction;
    }

    public abstract boolean isReleaseActionAll();

    public abstract boolean isReleaseActionSome();

    public abstract void setReleaseActionAll();

    public abstract List<TransactionElement> getElements();

    public abstract TransactionResponse createResponse();

    public static class WFS20
    extends TransactionRequest {
        public WFS20(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public boolean isReleaseActionAll() {
            return ((TransactionType)this.adaptee).getReleaseAction() == net.opengis.wfs20.AllSomeType.ALL;
        }

        @Override
        public boolean isReleaseActionSome() {
            return ((TransactionType)this.adaptee).getReleaseAction() == net.opengis.wfs20.AllSomeType.SOME;
        }

        @Override
        public void setReleaseActionAll() {
            ((TransactionType)this.adaptee).setReleaseAction(net.opengis.wfs20.AllSomeType.ALL);
        }

        @Override
        public List<TransactionElement> getElements() {
            ArrayList<TransactionElement> list = new ArrayList<TransactionElement>();
            for (EObject el : ((TransactionType)this.adaptee).getAbstractTransactionAction()) {
                if (el instanceof DeleteType) {
                    list.add(new Delete.WFS20(el));
                    continue;
                }
                if (el instanceof InsertType) {
                    list.add(new Insert.WFS20(el));
                    continue;
                }
                if (el instanceof UpdateType) {
                    list.add(new Update.WFS20(el));
                    continue;
                }
                if (el instanceof ReplaceType) {
                    list.add(new Replace.WFS20(el));
                    continue;
                }
                if (el instanceof NativeType) {
                    list.add(new Native.WFS20(el));
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized transaction element: " + el);
            }
            return list;
        }

        @Override
        public TransactionResponse createResponse() {
            Wfs20Factory factory = (Wfs20Factory)this.getFactory();
            TransactionResponseType tr = factory.createTransactionResponseType();
            tr.setTransactionSummary(factory.createTransactionSummaryType());
            tr.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(0L));
            tr.getTransactionSummary().setTotalInserted(BigInteger.valueOf(0L));
            tr.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(0L));
            tr.getTransactionSummary().setTotalReplaced(BigInteger.valueOf(0L));
            return new TransactionResponse.WFS20((EObject)tr);
        }
    }

    public static class WFS11
    extends TransactionRequest {
        public WFS11(EObject adaptee) {
            super(adaptee);
        }

        @Override
        public boolean isReleaseActionAll() {
            return ((net.opengis.wfs.TransactionType)this.adaptee).getReleaseAction() == AllSomeType.ALL_LITERAL;
        }

        @Override
        public boolean isReleaseActionSome() {
            return ((net.opengis.wfs.TransactionType)this.adaptee).getReleaseAction() == AllSomeType.SOME_LITERAL;
        }

        @Override
        public void setReleaseActionAll() {
            ((net.opengis.wfs.TransactionType)this.adaptee).setReleaseAction(AllSomeType.ALL_LITERAL);
        }

        @Override
        public List<TransactionElement> getElements() {
            ArrayList<TransactionElement> list = new ArrayList<TransactionElement>();
            FeatureMap.ValueListIterator it = ((net.opengis.wfs.TransactionType)this.adaptee).getGroup().valueListIterator();
            while (it.hasNext()) {
                EObject el = (EObject)it.next();
                if (el instanceof DeleteElementType) {
                    list.add(new Delete.WFS11(el));
                    continue;
                }
                if (el instanceof InsertElementType) {
                    list.add(new Insert.WFS11(el));
                    continue;
                }
                if (el instanceof UpdateElementType) {
                    list.add(new Update.WFS11(el));
                    continue;
                }
                if (el instanceof net.opengis.wfs.NativeType) {
                    list.add(new Native.WFS11(el));
                    continue;
                }
                throw new IllegalArgumentException("Unrecognized transaction element: " + el);
            }
            return list;
        }

        @Override
        public TransactionResponse createResponse() {
            WfsFactory factory = (WfsFactory)this.getFactory();
            net.opengis.wfs.TransactionResponseType tr = factory.createTransactionResponseType();
            tr.setTransactionSummary(factory.createTransactionSummaryType());
            tr.getTransactionSummary().setTotalInserted(BigInteger.valueOf(0L));
            tr.getTransactionSummary().setTotalUpdated(BigInteger.valueOf(0L));
            tr.getTransactionSummary().setTotalDeleted(BigInteger.valueOf(0L));
            tr.setTransactionResults(factory.createTransactionResultsType());
            tr.setInsertResults(factory.createInsertResultsType());
            return new TransactionResponse.WFS11((EObject)tr);
        }

        public static net.opengis.wfs.TransactionType unadapt(TransactionRequest request) {
            if (request instanceof WFS11) {
                return (net.opengis.wfs.TransactionType)request.getAdaptee();
            }
            WfsFactory factory = WfsFactory.eINSTANCE;
            net.opengis.wfs.TransactionType tx = factory.createTransactionType();
            tx.setVersion(request.getVersion());
            tx.setHandle(request.getHandle());
            tx.setLockId(request.getLockId());
            tx.setReleaseAction(request.isReleaseActionAll() ? AllSomeType.ALL_LITERAL : AllSomeType.SOME_LITERAL);
            tx.setBaseUrl(request.getBaseUrl());
            tx.setExtendedProperties(request.getExtendedProperties());
            for (TransactionElement te : request.getElements()) {
                if (te instanceof Delete) {
                    tx.getDelete().add((Object)Delete.WFS11.unadapt((Delete)te));
                }
                if (te instanceof Update) {
                    tx.getUpdate().add((Object)Update.WFS11.unadapt((Update)te));
                }
                if (te instanceof Insert) {
                    tx.getInsert().add((Object)Insert.WFS11.unadapt((Insert)te));
                }
                if (!(te instanceof Native)) continue;
                tx.getNative().add((Object)Native.WFS11.unadapt((Native)te));
            }
            return tx;
        }
    }
}

