/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.kvp;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import org.geoserver.ows.KvpParser;
import org.geoserver.ows.util.KvpUtils;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.kvp.SRSEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope3D;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BBoxKvpParser
extends KvpParser {
    public BBoxKvpParser() {
        super("bbox", Envelope.class);
    }

    public Object parse(String value) throws Exception {
        List unparsed = KvpUtils.readFlat((String)value, (KvpUtils.Tokenizer)KvpUtils.INNER_DELIMETER);
        if (unparsed.size() < 4) {
            throw new IllegalArgumentException("Requested bounding box contains wrongnumber of coordinates (should have 4): " + unparsed.size());
        }
        int countco = 4;
        if (unparsed.size() == 6) {
            countco = 6;
        }
        double[] bbox = new double[countco];
        for (int i = 0; i < countco; ++i) {
            try {
                bbox[i] = Double.parseDouble((String)unparsed.get(i));
                continue;
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Bounding box coordinate " + i + " is not parsable:" + unparsed.get(i));
            }
        }
        double minx = bbox[0];
        double miny = bbox[1];
        double minz = 0.0;
        double maxx = 0.0;
        double maxy = 0.0;
        double maxz = 0.0;
        if (countco == 6) {
            minz = bbox[2];
            maxx = bbox[3];
            maxy = bbox[4];
            maxz = bbox[5];
        } else {
            maxx = bbox[2];
            maxy = bbox[3];
        }
        if (minx > maxx) {
            throw new ServiceException("illegal bbox, minX: " + minx + " is " + "greater than maxX: " + maxx);
        }
        if (miny > maxy) {
            throw new ServiceException("illegal bbox, minY: " + miny + " is " + "greater than maxY: " + maxy);
        }
        if (minz > maxz) {
            throw new ServiceException("illegal bbox, minZ: " + minz + " is " + "greater than maxZ: " + maxz);
        }
        String srs = null;
        if (unparsed.size() > countco) {
            StringBuilder sb = new StringBuilder();
            for (int i = countco; i < unparsed.size(); ++i) {
                sb.append(unparsed.get(i));
                if (i >= unparsed.size() - 1) continue;
                sb.append(",");
            }
            srs = sb.toString();
        }
        if (countco == 6) {
            CoordinateReferenceSystem crs = srs != null ? CRS.decode(srs) : null;
            return new ReferencedEnvelope3D(minx, maxx, miny, maxy, minz, maxz, crs);
        }
        return new SRSEnvelope(minx, maxx, miny, maxy, srs);
    }
}

