/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.json;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.QueryType;
import net.sf.json.JSONException;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.WFSGetFeatureOutputFormat;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.json.GeoJSONBuilder;
import org.geoserver.wfs.json.JSONType;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.filter.spatial.ReprojectingFilterVisitor;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.gml2.SrsSyntax;
import org.geotools.referencing.CRS;
import org.geotools.referencing.NamedIdentifier;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class GeoJSONGetFeatureResponse
extends WFSGetFeatureOutputFormat {
    private final Logger LOGGER = Logging.getLogger(((Object)((Object)this)).getClass());
    private final boolean jsonp;

    public GeoJSONGetFeatureResponse(GeoServer gs, String format) {
        super(gs, format);
        if (JSONType.isJsonMimeType(format)) {
            this.jsonp = false;
        } else if (JSONType.isJsonpMimeType(format)) {
            this.jsonp = true;
        } else {
            throw new IllegalArgumentException("Unable to create the JSON Response handler using format: " + format + " supported mymetype are: " + Arrays.toString(JSONType.getSupportedTypes()));
        }
    }

    @Override
    public String getCapabilitiesElementName() {
        return JSONType.getJSONType(this.getOutputFormat()).toString();
    }

    @Override
    public String getMimeType(Object value, Operation operation) throws ServiceException {
        if (this.jsonp) {
            return JSONType.JSONP.getMimeType();
        }
        return JSONType.JSON.getMimeType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(FeatureCollectionResponse featureCollection, OutputStream output, Operation describeFeatureType) throws IOException {
        if (this.LOGGER.isLoggable(Level.INFO)) {
            this.LOGGER.info("about to encode JSON");
        }
        WFSInfo wfs = this.getInfo();
        boolean featureBounding = wfs.isFeatureBounding();
        String id_option = null;
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request != null) {
            id_option = JSONType.getIdPolicy(request.getKvp());
        }
        OutputStreamWriter osw = null;
        BufferedWriter outWriter = null;
        boolean hasGeom = false;
        BigInteger featureCount = null;
        if (describeFeatureType != null) {
            if (describeFeatureType.getParameters()[0] instanceof GetFeatureType) {
                featureCount = BigInteger.valueOf(this.getFeatureCountFromWFS11Request(describeFeatureType, wfs));
            } else if (describeFeatureType.getParameters()[0] instanceof net.opengis.wfs20.GetFeatureType) {
                BigInteger totalNumberOfFeatures = featureCollection.getTotalNumberOfFeatures();
                featureCount = totalNumberOfFeatures != null && totalNumberOfFeatures.longValue() < 0L ? null : totalNumberOfFeatures;
            }
        }
        try {
            osw = new OutputStreamWriter(output, this.gs.getGlobal().getSettings().getCharset());
            outWriter = new BufferedWriter(osw);
            if (this.jsonp) {
                outWriter.write(this.getCallbackFunction() + "(");
            }
            GeoJSONBuilder jsonWriter = new GeoJSONBuilder(outWriter);
            jsonWriter.object().key("type").value((Object)"FeatureCollection");
            if (featureCount != null) {
                jsonWriter.key("totalFeatures").value((Object)featureCount);
            } else {
                jsonWriter.key("totalFeatures").value((Object)"unknown");
            }
            jsonWriter.key("features");
            jsonWriter.array();
            List<FeatureCollection> resultsList = featureCollection.getFeature();
            CoordinateReferenceSystem crs = null;
            for (int i = 0; i < resultsList.size(); ++i) {
                FeatureCollection collection = resultsList.get(i);
                try (FeatureIterator iterator = collection.features();){
                    while (iterator.hasNext()) {
                        Object value;
                        int j;
                        SimpleFeature feature = (SimpleFeature)iterator.next();
                        jsonWriter.object();
                        jsonWriter.key("type").value((Object)"Feature");
                        SimpleFeatureType fType = feature.getFeatureType();
                        List types = fType.getAttributeDescriptors();
                        if (id_option == null) {
                            jsonWriter.key("id").value((Object)feature.getID());
                        } else if (id_option.length() != 0) {
                            Object value2 = feature.getAttribute(id_option);
                            jsonWriter.key("id").value(value2);
                        }
                        GeometryDescriptor defaultGeomType = fType.getGeometryDescriptor();
                        if (defaultGeomType != null) {
                            CoordinateReferenceSystem featureCrs = defaultGeomType.getCoordinateReferenceSystem();
                            jsonWriter.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)featureCrs));
                            if (crs == null) {
                                crs = featureCrs;
                            }
                        } else {
                            jsonWriter.setAxisOrder(CRS.AxisOrder.EAST_NORTH);
                        }
                        jsonWriter.key("geometry");
                        Geometry aGeom = (Geometry)feature.getDefaultGeometry();
                        if (aGeom == null) {
                            for (j = 0; j < types.size() && aGeom == null; ++j) {
                                value = feature.getAttribute(j);
                                if (value == null || !(value instanceof Geometry)) continue;
                                aGeom = (Geometry)value;
                            }
                        }
                        if (aGeom != null) {
                            jsonWriter.writeGeom(aGeom);
                            hasGeom = true;
                        } else {
                            jsonWriter.value(null);
                        }
                        if (defaultGeomType != null) {
                            jsonWriter.key("geometry_name").value((Object)defaultGeomType.getLocalName());
                        }
                        jsonWriter.key("properties");
                        jsonWriter.object();
                        for (j = 0; j < types.size(); ++j) {
                            value = feature.getAttribute(j);
                            AttributeDescriptor ad = (AttributeDescriptor)types.get(j);
                            if (id_option != null && id_option.equals(ad.getLocalName())) continue;
                            if (value != null) {
                                if (value instanceof Geometry) {
                                    if (ad.equals(defaultGeomType)) continue;
                                    jsonWriter.key(ad.getLocalName());
                                    jsonWriter.writeGeom((Geometry)value);
                                    continue;
                                }
                                jsonWriter.key(ad.getLocalName());
                                jsonWriter.value(value);
                                continue;
                            }
                            jsonWriter.key(ad.getLocalName());
                            jsonWriter.value(null);
                        }
                        ReferencedEnvelope refenv = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)feature.getBounds());
                        if (featureBounding && !refenv.isEmpty()) {
                            jsonWriter.writeBoundingBox((Envelope)refenv);
                        }
                        jsonWriter.endObject();
                        jsonWriter.endObject();
                    }
                    continue;
                }
            }
            jsonWriter.endArray();
            try {
                if ("true".equals(GeoServerExtensions.getProperty((String)"GEOSERVER_GEOJSON_LEGACY_CRS"))) {
                    this.writeCrsLegacy(jsonWriter, crs);
                } else {
                    this.writeCrs(jsonWriter, crs);
                }
            }
            catch (FactoryException e) {
                throw (IOException)new IOException("Error looking up crs identifier").initCause(e);
            }
            if (hasGeom && featureBounding) {
                ReferencedEnvelope e = null;
                for (int i = 0; i < resultsList.size(); ++i) {
                    FeatureCollection collection = resultsList.get(i);
                    if (e == null) {
                        e = collection.getBounds();
                        continue;
                    }
                    e.expandToInclude((Envelope)collection.getBounds());
                }
                if (e != null) {
                    jsonWriter.setAxisOrder(CRS.getAxisOrder((CoordinateReferenceSystem)e.getCoordinateReferenceSystem()));
                    jsonWriter.writeBoundingBox((Envelope)e);
                }
            }
            jsonWriter.endObject();
            if (this.jsonp) {
                outWriter.write(")");
            }
            ((Writer)outWriter).flush();
        }
        catch (JSONException jsonException) {
            ServiceException serviceException = new ServiceException("Error: " + jsonException.getMessage());
            serviceException.initCause((Throwable)jsonException);
            throw serviceException;
        }
    }

    private void writeCrs(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) throws FactoryException {
        if (crs != null) {
            String identifier = null;
            Integer code = CRS.lookupEpsgCode((CoordinateReferenceSystem)crs, (boolean)true);
            if (code != null) {
                if (code != null) {
                    identifier = SrsSyntax.OGC_URN.getPrefix() + code;
                }
            } else {
                identifier = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)true);
            }
            jsonWriter.key("crs");
            jsonWriter.object();
            jsonWriter.key("type").value((Object)"name");
            jsonWriter.key("properties");
            jsonWriter.object();
            jsonWriter.key("name");
            jsonWriter.value(identifier);
            jsonWriter.endObject();
            jsonWriter.endObject();
        } else {
            jsonWriter.key("crs");
            jsonWriter.value(null);
        }
    }

    private void writeCrsLegacy(GeoJSONBuilder jsonWriter, CoordinateReferenceSystem crs) {
        NamedIdentifier namedIdent;
        String csStr;
        Set ids;
        if (crs != null && (ids = crs.getIdentifiers()) != null && ids.size() > 0 && (csStr = (namedIdent = (NamedIdentifier)ids.iterator().next()).getCodeSpace().toUpperCase()).equals("EPSG")) {
            jsonWriter.key("crs");
            jsonWriter.object();
            jsonWriter.key("type").value((Object)csStr);
            jsonWriter.key("properties");
            jsonWriter.object();
            jsonWriter.key("code");
            jsonWriter.value(namedIdent.getCode());
            jsonWriter.endObject();
            jsonWriter.endObject();
        }
    }

    private String getCallbackFunction() {
        Request request = (Request)Dispatcher.REQUEST.get();
        if (request == null) {
            return "parseResponse";
        }
        return JSONType.getCallbackFunction(request.getKvp());
    }

    private int getFeatureCountFromWFS11Request(Operation operation, WFSInfo wfs) throws IOException {
        FilterFactory2 FF = CommonFactoryFinder.getFilterFactory2(null);
        int totalCount = 0;
        Catalog catalog = wfs.getGeoServer().getCatalog();
        GetFeatureType request = (GetFeatureType)operation.getParameters()[0];
        List<Map<String, String>> viewParams = new GetFeatureRequest.WFS11((EObject)request).getViewParams();
        int idx = 0;
        for (QueryType query : request.getQuery()) {
            Map<String, String> viewParam;
            QName typeName = (QName)query.getTypeName().get(0);
            FeatureTypeInfo meta = catalog.getFeatureTypeByName(typeName.getNamespaceURI(), typeName.getLocalPart());
            FeatureSource source = meta.getFeatureSource(null, null);
            Filter filter = query.getFilter();
            if (filter == null) {
                filter = Filter.INCLUDE;
            } else {
                ReprojectingFilterVisitor reprojector = new ReprojectingFilterVisitor(FF, source.getSchema());
                filter = (Filter)filter.accept((FilterVisitor)reprojector, null);
            }
            Query countQuery = new Query(typeName.getLocalPart(), filter);
            Map<String, String> map = viewParam = viewParams != null && viewParams.size() > idx ? viewParams.get(idx) : null;
            if (viewParam != null) {
                Hints hints = new Hints();
                hints.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, viewParam);
                countQuery.setHints(hints);
            }
            int count = 0;
            count = source.getCount(countQuery);
            if (count == -1) {
                Query gtQuery = new Query(countQuery);
                FeatureCollection features = source.getFeatures(gtQuery);
                count = features.size();
            }
            totalCount += count;
        }
        return totalCount;
    }

    public String getCharset(Operation operation) {
        return this.gs.getGlobal().getSettings().getCharset();
    }
}

