/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.thoughtworks.xstream.XStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerResourceLoader;
import org.geoserver.wfs.GMLInfo;
import org.geoserver.wfs.GMLInfoImpl;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSInfoImpl;

public class WFSXStreamLoader
extends XStreamServiceLoader<WFSInfo> {
    public WFSXStreamLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader, "wfs");
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        super.initXStreamPersister(xp, gs);
        XStream xs = xp.getXStream();
        xs.alias("wfs", WFSInfo.class, WFSInfoImpl.class);
        xs.alias("version", WFSInfo.Version.class);
        xs.alias("gml", GMLInfo.class, GMLInfoImpl.class);
        xs.allowTypes(new Class[]{WFSInfo.Version.class, GMLInfo.class, GMLInfoImpl.class});
    }

    protected WFSInfo createServiceFromScratch(GeoServer gs) {
        WFSInfoImpl wfs = new WFSInfoImpl();
        wfs.setName("WFS");
        wfs.setMaxFeatures(1000000);
        this.addGml(wfs, WFSInfo.Version.V_10, GMLInfo.SrsNameStyle.XML, true);
        this.addGml(wfs, WFSInfo.Version.V_11, GMLInfo.SrsNameStyle.URN, false);
        this.addGml(wfs, WFSInfo.Version.V_20, GMLInfo.SrsNameStyle.URN2, false);
        return wfs;
    }

    public Class<WFSInfo> getServiceClass() {
        return WFSInfo.class;
    }

    protected WFSInfo initialize(WFSInfo service) {
        GMLInfo gml;
        super.initialize((ServiceInfo)service);
        if (service.getVersions().isEmpty()) {
            service.getVersions().add(WFSInfo.Version.V_10.getVersion());
            service.getVersions().add(WFSInfo.Version.V_11.getVersion());
        }
        if (!service.getVersions().contains(WFSInfo.Version.V_20.getVersion())) {
            service.getVersions().add(WFSInfo.Version.V_20.getVersion());
        }
        if (service.getGML() == null) {
            ((WFSInfoImpl)service).setGML(new HashMap<WFSInfo.Version, GMLInfo>());
        }
        if ((gml = service.getGML().get((Object)WFSInfo.Version.V_10)) == null) {
            this.addGml(service, WFSInfo.Version.V_10, GMLInfo.SrsNameStyle.URL, false);
        } else if (gml.getOverrideGMLAttributes() == null) {
            gml.setOverrideGMLAttributes(true);
        }
        gml = service.getGML().get((Object)WFSInfo.Version.V_11);
        if (gml == null) {
            this.addGml(service, WFSInfo.Version.V_11, GMLInfo.SrsNameStyle.URN, false);
        } else if (gml.getOverrideGMLAttributes() == null) {
            gml.setOverrideGMLAttributes(false);
        }
        gml = service.getGML().get((Object)WFSInfo.Version.V_20);
        if (gml == null) {
            this.addGml(service, WFSInfo.Version.V_20, GMLInfo.SrsNameStyle.URN2, false);
        }
        if (service.getSRS() == null) {
            ((WFSInfoImpl)service).setSRS(new ArrayList<String>());
        }
        return service;
    }

    void addGml(WFSInfo info, WFSInfo.Version ver, GMLInfo.SrsNameStyle srs, boolean overrideGmlAtts) {
        GMLInfoImpl gml = new GMLInfoImpl();
        gml.setSrsNameStyle(srs);
        gml.setOverrideGMLAttributes(overrideGmlAtts);
        info.getGML().put(ver, gml);
    }
}

