/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.SettingsInfo;
import org.geoserver.platform.Operation;
import org.geoserver.platform.ServiceException;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.response.WFSResponse;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.logging.Logging;
import org.opengis.feature.type.FeatureType;

public abstract class WFSGetFeatureOutputFormat
extends WFSResponse {
    static final Pattern XML_ELEMENT = Pattern.compile("[:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\ud7ff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\x10000-\\xEFFFF][:A-Z_a-z\\u00C0\\u00D6\\u00D8-\\u00F6\\u00F8-\\u02ff\\u0370-\\u037d\\u037f-\\u1fff\\u200c\\u200d\\u2070-\\u218f\\u2c00-\\u2fef\\u3001-\\udfff\\uf900-\\ufdcf\\ufdf0-\\ufffd\\\\x10000-\\\\xEFFFF\\-\\.0-9\\u00b7\\u0300-\\u036f\\u203f-\\u2040]*\\Z");
    protected static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");

    public WFSGetFeatureOutputFormat(GeoServer gs, String outputFormat) {
        super(gs, FeatureCollectionResponse.class, outputFormat);
    }

    public WFSGetFeatureOutputFormat(GeoServer gs, Set<String> outputFormats) {
        super(gs, FeatureCollectionResponse.class, outputFormats);
    }

    public String getMimeType(Object value, Operation operation) throws ServiceException {
        return "text/xml";
    }

    public boolean canHandle(Operation operation) {
        GetFeatureRequest req;
        if (("GetFeature".equalsIgnoreCase(operation.getId()) || "GetFeatureWithLock".equalsIgnoreCase(operation.getId())) && (req = GetFeatureRequest.adapt(operation.getParameters()[0])).isResultTypeResults()) {
            return this.canHandleInternal(operation);
        }
        return false;
    }

    public String getCapabilitiesElementName() {
        String of = this.getOutputFormat();
        if (of == null) {
            return null;
        }
        if (XML_ELEMENT.matcher(of).matches()) {
            return of;
        }
        LOGGER.severe("ERROR IN " + ((Object)((Object)this)).getClass() + " IMPLEMENTATION.  getCapabilitiesElementName() should return a" + "valid XML element name string for use in the WFS 1.0.0 capabilities document.");
        String name = ((Object)((Object)this)).getClass().getName();
        if (name.indexOf(46) != -1) {
            name = name.substring(name.lastIndexOf(46) + 1);
        }
        return name;
    }

    public List<String> getCapabilitiesElementNames() {
        String name = this.getCapabilitiesElementName();
        if (name == null) {
            return Collections.emptyList();
        }
        return Arrays.asList(name);
    }

    protected List<String> getAllCapabilitiesElementNames() {
        ArrayList<String> result = new ArrayList<String>();
        for (String name : this.getOutputFormats()) {
            if (!XML_ELEMENT.matcher(name).matches()) continue;
            result.add(name);
        }
        Collections.sort(result);
        return result;
    }

    protected boolean canHandleInternal(Operation operation) {
        return true;
    }

    public final void write(Object value, OutputStream output, Operation operation) throws IOException, ServiceException {
        if (value instanceof FeatureCollectionResponse) {
            this.write((FeatureCollectionResponse)value, output, operation);
        } else {
            this.write(FeatureCollectionResponse.adapt(value), output, operation);
        }
    }

    protected int getNumDecimals(List featureCollections, GeoServer geoServer, Catalog catalog) {
        int numDecimals = -1;
        for (int i = 0; i < featureCollections.size(); ++i) {
            int ftiDecimals;
            FeatureCollection features = (FeatureCollection)featureCollections.get(i);
            FeatureType featureType = features.getSchema();
            ResourceInfo meta = catalog.getResourceByName(featureType.getName(), ResourceInfo.class);
            if (!(meta instanceof FeatureTypeInfo) || (ftiDecimals = ((FeatureTypeInfo)meta).getNumDecimals()) <= 0) continue;
            numDecimals = numDecimals == -1 ? ftiDecimals : Math.max(numDecimals, ftiDecimals);
        }
        SettingsInfo settings = geoServer.getSettings();
        if (numDecimals == -1) {
            numDecimals = settings.getNumDecimals();
        }
        return numDecimals;
    }

    protected abstract void write(FeatureCollectionResponse var1, OutputStream var2, Operation var3) throws IOException, ServiceException;
}

