/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.opengis.wfs20.ParameterExpressionType;
import net.opengis.wfs20.ParameterType;
import net.opengis.wfs20.QueryExpressionTextType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.StoredQueryType;
import net.opengis.wfs20.TitleType;
import net.opengis.wfs20.Wfs20Factory;
import org.geoserver.catalog.Catalog;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.kvp.QNameKvpParser;
import org.geotools.wfs.v2_0.WFSConfiguration;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.geotools.xs.XS;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class StoredQuery {
    public static final StoredQuery DEFAULT;
    StoredQueryDescriptionType queryDef;
    Catalog catalog;

    public StoredQuery(StoredQueryDescriptionType query, Catalog catalog) {
        this.queryDef = query;
        this.catalog = catalog;
    }

    public String getName() {
        return this.queryDef.getId();
    }

    public String getTitle() {
        if (!this.queryDef.getTitle().isEmpty()) {
            return ((TitleType)this.queryDef.getTitle().get(0)).getValue();
        }
        return null;
    }

    public List<QName> getFeatureTypes() {
        ArrayList<QName> types = new ArrayList<QName>();
        for (QueryExpressionTextType qe : this.queryDef.getQueryExpressionText()) {
            types.addAll(qe.getReturnFeatureTypes());
        }
        return types;
    }

    public StoredQueryDescriptionType getQuery() {
        return this.queryDef;
    }

    public void validate() throws WFSException, IOException {
        DocumentBuilder db;
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            db = dbf.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        for (QueryExpressionTextType qe : this.queryDef.getQueryExpressionText()) {
            HashSet queryTypes = new HashSet();
            try {
                Document doc = db.parse(new ByteArrayInputStream(qe.getValue().getBytes()));
                NodeList queries = doc.getElementsByTagName("wfs:Query");
                if (queries.getLength() == 0) {
                    queries = doc.getElementsByTagName("Query");
                }
                if (queries.getLength() == 0) {
                    throw new WFSException("StoredQuery does not specify any Query elements");
                }
                for (int i = 0; i < queries.getLength(); ++i) {
                    String[] typeNames;
                    Element query = (Element)queries.item(i);
                    for (String typeName : typeNames = query.getAttribute("typeNames").split(" ")) {
                        queryTypes.addAll((List)new QNameKvpParser(null, this.catalog).parse(typeName));
                    }
                }
            }
            catch (Exception e) {
                throw new IOException(e);
            }
            HashSet<QName> returnTypes = new HashSet<QName>(qe.getReturnFeatureTypes());
            for (QName qName : queryTypes) {
                if (!returnTypes.contains(qName)) {
                    throw new WFSException(String.format("StoredQuery references typeName %s:%s not listed in returnFeatureTypes: %s", qName.getPrefix(), qName.getLocalPart(), this.toString(qe.getReturnFeatureTypes())));
                }
                returnTypes.remove(qName);
            }
            if (returnTypes.isEmpty()) continue;
            throw new WFSException(String.format("StoredQuery declares return feature type(s) not not referenced in query definition: %s", this.toString(returnTypes)));
        }
    }

    String toString(Collection<QName> qNames) {
        StringBuilder sb = new StringBuilder();
        for (QName qName : qNames) {
            sb.append(qName.getPrefix()).append(":").append(qName.getLocalPart()).append(", ");
        }
        sb.setLength(sb.length() - 2);
        return sb.toString();
    }

    public List<QueryType> compile(StoredQueryType query) {
        ArrayList<QueryType> list = new ArrayList<QueryType>();
        for (QueryExpressionTextType qe : this.queryDef.getQueryExpressionText()) {
            StringBuffer sb = new StringBuffer(qe.getValue());
            for (ParameterType p : query.getParameter()) {
                String name = p.getName();
                String token = "${" + name + "}";
                int i = sb.indexOf(token);
                while (i > 0) {
                    sb.replace(i, i + token.length(), p.getValue());
                    i = sb.indexOf(token, i + token.length());
                }
            }
            Parser p = new Parser((Configuration)new WFSConfiguration());
            try {
                QueryType compiled = (QueryType)p.parse((InputStream)new ByteArrayInputStream(sb.toString().getBytes()));
                list.add(compiled);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return list;
    }

    static {
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        StoredQueryDescriptionType desc = factory.createStoredQueryDescriptionType();
        desc.setId("urn:ogc:def:query:OGC-WFS::GetFeatureById");
        TitleType title = factory.createTitleType();
        title.setLang("en");
        title.setValue("Get feature by identifier");
        desc.getTitle().add((Object)title);
        ParameterExpressionType param = factory.createParameterExpressionType();
        param.setName("ID");
        param.setType(XS.STRING);
        desc.getParameter().add((Object)param);
        QueryExpressionTextType text = factory.createQueryExpressionTextType();
        text.setIsPrivate(true);
        text.setReturnFeatureTypes(new ArrayList());
        text.setLanguage(StoredQueryProvider.LANGUAGE);
        String xml = "<wfs:Query xmlns:wfs='http://www.opengis.net/wfs/2.0' xmlns:fes='http://www.opengis.net/fes/2.0'><fes:Filter><fes:ResourceId rid = '${ID}'/></fes:Filter></wfs:Query>";
        text.setValue(xml);
        desc.getQueryExpressionText().add((Object)text);
        DEFAULT = new StoredQuery(desc, null);
    }
}

