/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Replace;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;

public class ReplaceElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory(null);

    public ReplaceElementHandler(GeoServer geoServer) {
        super(geoServer);
    }

    public Class getElementClass() {
        return Replace.class;
    }

    @Override
    public QName[] getTypeNames(TransactionElement element) throws WFSTransactionException {
        Replace replace = (Replace)element;
        ArrayList<QName> typeNames = new ArrayList<QName>();
        List features = replace.getFeatures();
        if (!features.isEmpty()) {
            for (SimpleFeature feature : features) {
                String name = feature.getFeatureType().getTypeName();
                String namespaceURI = feature.getFeatureType().getName().getNamespaceURI();
                typeNames.add(new QName(namespaceURI, name));
            }
        }
        return typeNames.toArray(new QName[typeNames.size()]);
    }

    public void checkValidity(TransactionElement element, Map featureTypeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_REPLACE)) {
            throw new WFSException((RequestObject)element, "Transaction REPLACE support is not enabled");
        }
        if (featureTypeInfos.size() != 1) {
            throw new WFSException((RequestObject)element, "Transaction REPLACE must only specify features from a single feature type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(TransactionElement element, TransactionRequest request, Map featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        Replace replace = (Replace)element;
        List newFeatures = replace.getFeatures();
        SimpleFeatureStore featureStore = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.values().iterator().next()));
        if (featureStore == null) {
            throw new WFSException((RequestObject)element, "Could not obtain feature store");
        }
        String featureTypeName = ((SimpleFeatureType)featureStore.getSchema()).getTypeName();
        ArrayList<FeatureId> replaced = new ArrayList<FeatureId>();
        try {
            SimpleFeature oldFeature;
            Query query = new Query(featureTypeName, replace.getFilter());
            SimpleFeatureCollection features = featureStore.getFeatures(replace.getFilter());
            if (newFeatures.size() != features.size()) {
                throw new WFSException((RequestObject)element, String.format("Specified filter matched %d features but %d were supplied", features.size(), newFeatures.size()));
            }
            LinkedHashMap<String, SimpleFeature> oldFeatures = new LinkedHashMap<String, SimpleFeature>();
            try (SimpleFeatureIterator it = features.features();){
                while (it.hasNext()) {
                    SimpleFeature f = (SimpleFeature)it.next();
                    oldFeatures.put(f.getID(), f);
                }
            }
            ArrayList<SimpleFeature> leftovers = new ArrayList<SimpleFeature>();
            for (SimpleFeature newFeature : newFeatures) {
                oldFeature = (SimpleFeature)oldFeatures.get(newFeature.getID());
                if (oldFeature == null) {
                    leftovers.add(newFeature);
                    continue;
                }
                this.replace(oldFeature, newFeature, featureStore, oldFeatures, replaced);
            }
            for (SimpleFeature newFeature : leftovers) {
                oldFeature = (SimpleFeature)oldFeatures.values().iterator().next();
                this.replace(oldFeature, newFeature, featureStore, oldFeatures, replaced);
            }
        }
        catch (IOException e) {
            throw new WFSException((RequestObject)element, "Transaction REPLACE failed", (Throwable)e);
        }
        response.setTotalReplaced(BigInteger.valueOf(replaced.size()));
        response.addReplacedFeatures(replace.getHandle(), replaced);
    }

    void replace(SimpleFeature oldFeature, SimpleFeature newFeature, SimpleFeatureStore featureStore, Map<String, SimpleFeature> oldFeatures, Collection<FeatureId> ids) throws IOException {
        String[] names = new String[oldFeature.getAttributeCount()];
        Object[] valus = new Object[names.length];
        int i = 0;
        for (AttributeDescriptor att : oldFeature.getType().getAttributeDescriptors()) {
            String name = att.getLocalName();
            Object valu = newFeature.getAttribute(name);
            names[i] = name;
            valus[i++] = valu;
        }
        FeatureId id = filterFactory.featureId(oldFeature.getID());
        featureStore.modifyFeatures(names, valus, (Filter)filterFactory.id(Collections.singleton(id)));
        ids.add(id);
        oldFeatures.remove(oldFeature.getID());
    }
}

