/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.WFSException;
import org.geotools.data.Join;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.FilterAttributeExtractor;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.geotools.filter.visitor.FilterVisitorSupport;
import org.opengis.filter.And;
import org.opengis.filter.BinaryComparisonOperator;
import org.opengis.filter.BinaryLogicOperator;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNil;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.temporal.BinaryTemporalOperator;

public class JoinExtractingVisitor
extends FilterVisitorSupport {
    static FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
    FeatureTypeInfo primaryFeatureType = null;
    String primaryAlias;
    List<FeatureTypeInfo> featureTypes;
    List<String> aliases;
    boolean hadAliases;
    List<Filter> joinFilters = new ArrayList<Filter>();
    List<Filter> filters = new ArrayList<Filter>();

    public JoinExtractingVisitor(List<FeatureTypeInfo> featureTypes, List<String> aliases) {
        this.featureTypes = new ArrayList<FeatureTypeInfo>(featureTypes);
        if (aliases == null || aliases.isEmpty()) {
            this.hadAliases = false;
            aliases = new ArrayList<String>();
            int j = 0;
            for (int i = 0; i < featureTypes.size(); ++i) {
                String alias;
                boolean conflictFound;
                block1: do {
                    conflictFound = false;
                    alias = String.valueOf((char)(97 + j++));
                    for (FeatureTypeInfo ft : featureTypes) {
                        if (!alias.equals(ft.getName()) && !alias.equals(ft.prefixedName())) continue;
                        conflictFound = true;
                        continue block1;
                    }
                } while (conflictFound);
                aliases.add(alias);
            }
        } else {
            this.hadAliases = true;
        }
        this.aliases = new ArrayList<String>(aliases);
    }

    public Object visitNullFilter(Object extraData) {
        return null;
    }

    public Object visit(ExcludeFilter filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(IncludeFilter filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(Id filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(Not filter, Object extraData) {
        if (this.isJoinFilter(filter.getFilter(), extraData)) {
            this.checkValidJoinFilter((Filter)filter);
            this.joinFilters.add((Filter)filter);
        } else {
            this.handleOther((Filter)filter, extraData);
        }
        return extraData;
    }

    private void checkValidJoinFilter(Filter filter) {
        Set<String> prefixes = this.getFilterPrefixes(filter);
        if (prefixes.size() > 2) {
            throw new WFSException("Not subfilter joins against more than one table " + prefixes + ", this kind of filter is not supported: " + filter);
        }
    }

    public Object visit(PropertyIsBetween filter, Object extraData) {
        return this.handle((Filter)filter, extraData, filter.getLowerBoundary(), filter.getUpperBoundary(), filter.getUpperBoundary());
    }

    public Object visit(PropertyIsLike filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsNull filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    public Object visit(PropertyIsNil filter, Object extraData) {
        return this.handleOther((Filter)filter, extraData);
    }

    protected Object visit(BinaryLogicOperator op, Object extraData) {
        if (op instanceof And) {
            for (Filter f : op.getChildren()) {
                f.accept((FilterVisitor)this, extraData);
            }
        } else {
            boolean joinFilter = false;
            for (Filter child : op.getChildren()) {
                if (!this.isJoinFilter(child, extraData)) continue;
                joinFilter = true;
                break;
            }
            if (joinFilter) {
                this.checkValidJoinFilter((Filter)op);
                this.joinFilters.add((Filter)op);
            } else {
                this.handleOther((Filter)op, extraData);
            }
            return extraData;
        }
        return extraData;
    }

    protected Object visit(BinaryComparisonOperator op, Object extraData) {
        return this.handle((Filter)op, extraData, op.getExpression1(), op.getExpression2());
    }

    protected Object visit(BinarySpatialOperator op, Object extraData) {
        return this.handle((Filter)op, extraData, op.getExpression1(), op.getExpression2());
    }

    protected Object visit(BinaryTemporalOperator op, Object extraData) {
        return this.handle((Filter)op, extraData, op.getExpression1(), op.getExpression2());
    }

    Object handle(Filter f, Object extraData, Expression ... expressions) {
        if (this.isJoinFilter(expressions)) {
            this.joinFilters.add(f);
        } else {
            this.handleOther(f, extraData);
        }
        return null;
    }

    Object handleOther(Filter f, Object extraData) {
        this.filters.add(f);
        return null;
    }

    boolean isJoinFilter(Expression ... expressions) {
        HashSet<String> prefixes = new HashSet<String>();
        for (Expression ex : expressions) {
            FilterAttributeExtractor fae = new FilterAttributeExtractor();
            ex.accept((ExpressionVisitor)fae, null);
            Set localAttributes = fae.getAttributeNameSet();
            Set<String> localPrefixes = this.getPrefixes(localAttributes);
            if (localPrefixes.isEmpty()) continue;
            if (prefixes.size() == 0) {
                prefixes.addAll(localPrefixes);
                continue;
            }
            if (prefixes.size() > 1) {
                return true;
            }
            localPrefixes.removeAll(prefixes);
            if (localPrefixes.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private boolean isJoinFilter(Filter filter, Object extraData) {
        JoinExtractingVisitor visitor = new JoinExtractingVisitor(this.featureTypes, this.aliases);
        filter.accept((FilterVisitor)visitor, extraData);
        return !visitor.joinFilters.isEmpty();
    }

    private Set<String> getPrefixes(Set<String> attributes) {
        HashSet<String> result = new HashSet<String>();
        for (String attribute : attributes) {
            int idx = attribute.indexOf(47);
            if (idx <= 0) continue;
            String prefix = attribute.substring(0, idx);
            result.add(prefix);
        }
        return result;
    }

    public List<Join> getJoins() {
        ArrayList<Join> joins = new ArrayList<Join>();
        this.setupPrimary();
        List<Filter> joinFilters = this.rewriteAndSortJoinFilters(this.joinFilters);
        List<Filter> otherFilters = this.rewriteAndSortOtherFilters(this.filters);
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            String nativeName = this.featureTypes.get(i).getNativeName();
            Join join = new Join(nativeName, joinFilters.get(i + 1));
            if (this.aliases != null) {
                join.setAlias(this.aliases.get(i));
            }
            if (otherFilters.get(i + 1) != null) {
                join.setFilter(otherFilters.get(i + 1));
            }
            joins.add(join);
        }
        return joins;
    }

    public List<FeatureTypeInfo> getFeatureTypes() {
        if (this.primaryFeatureType == null) {
            return this.featureTypes;
        }
        ArrayList<FeatureTypeInfo> result = new ArrayList<FeatureTypeInfo>();
        result.add(this.primaryFeatureType);
        result.addAll(this.featureTypes);
        return result;
    }

    private void setupPrimary() {
        if (this.primaryFeatureType == null) {
            int idx = this.getPrimaryFeatureTypeIndex(this.joinFilters);
            this.primaryFeatureType = this.featureTypes.get(idx);
            this.primaryAlias = this.aliases.get(idx);
            this.featureTypes.remove(idx);
            this.aliases.remove(idx);
        }
    }

    public Filter getPrimaryFilter() {
        this.setupPrimary();
        List<Filter> otherFilters = this.rewriteAndSortOtherFilters(this.filters);
        return otherFilters.get(0);
    }

    public String getPrimaryAlias() {
        this.setupPrimary();
        return this.primaryAlias;
    }

    public FeatureTypeInfo getPrimaryFeatureType() {
        this.setupPrimary();
        return this.primaryFeatureType;
    }

    List<Filter> rewriteAndSortJoinFilters(List<Filter> filters) {
        Map<String, FeatureTypeInfo> typeMap = this.buildTypeMap();
        Map<String, String> nameToAlias = this.buildNameToAlias();
        String primaryName = this.primaryFeatureType.prefixedName();
        String primaryUnqualifiedName = this.primaryFeatureType.getName();
        PropertyNameRewriter rewriter = new PropertyNameRewriter(nameToAlias, true);
        Filter[] sorted = new Filter[this.featureTypes.size() + 1];
        for (Filter filter : filters) {
            Set<String> prefixes = this.getFilterPrefixes(filter);
            prefixes.remove(this.primaryAlias);
            prefixes.remove(primaryName);
            prefixes.remove(primaryUnqualifiedName);
            if (prefixes.size() != 1) {
                throw new WFSException("Extracted invalid join filter " + filter + ", it joins more than " + "one secondary feature type + " + prefixes + " with the central join feature type " + this.primaryAlias + "/" + primaryName);
            }
            Filter rewritten = (Filter)filter.accept((FilterVisitor)rewriter, null);
            String alias = prefixes.iterator().next();
            FeatureTypeInfo ft = typeMap.get(alias);
            int idx = this.featureTypes.indexOf(ft);
            if (idx == -1) {
                throw new WFSException("Extracted invalid join filter " + filter + ", it uses the unkonwn alias/typename " + alias);
            }
            this.updateFilter(sorted, idx + 1, rewritten);
        }
        return Arrays.asList(sorted);
    }

    private Set<String> getFilterPrefixes(Filter filter) {
        FilterAttributeExtractor extractor = new FilterAttributeExtractor();
        filter.accept((FilterVisitor)extractor, null);
        Set attributeNames = extractor.getAttributeNameSet();
        Set<String> prefixes = this.getPrefixes(attributeNames);
        return prefixes;
    }

    List<Filter> rewriteAndSortOtherFilters(List<Filter> filters) {
        String primaryName = this.primaryFeatureType.prefixedName();
        Map<String, FeatureTypeInfo> typeMap = this.buildTypeMap();
        Map<String, String> nameToAlias = this.buildNameToAlias();
        PropertyNameRewriter rewriter = new PropertyNameRewriter(nameToAlias, false);
        Filter[] sorted = new Filter[this.featureTypes.size() + 1];
        for (Filter filter : filters) {
            Set<String> prefixes = this.getFilterPrefixes(filter);
            prefixes.remove(primaryName);
            if (prefixes.size() != 1) {
                throw new WFSException("Extracted invalid join sub-filter " + filter + ", it users more than one feature type + " + prefixes);
            }
            Filter rewritten = (Filter)filter.accept((FilterVisitor)rewriter, null);
            String alias = prefixes.iterator().next();
            FeatureTypeInfo ft = typeMap.get(alias);
            if (this.primaryFeatureType.equals(ft)) {
                this.updateFilter(sorted, 0, rewritten);
                continue;
            }
            int idx = this.featureTypes.indexOf(ft);
            if (idx == -1) {
                throw new WFSException("Extracted invalid join filter " + filter + ", it uses the unkonwn alias/typename " + alias);
            }
            this.updateFilter(sorted, idx + 1, rewritten);
        }
        return Arrays.asList(sorted);
    }

    private Map<String, FeatureTypeInfo> buildTypeMap() {
        HashMap<String, FeatureTypeInfo> typeMap = new HashMap<String, FeatureTypeInfo>();
        typeMap.put(this.primaryFeatureType.prefixedName(), this.primaryFeatureType);
        typeMap.put(this.primaryFeatureType.getName(), this.primaryFeatureType);
        typeMap.put(this.primaryAlias, this.primaryFeatureType);
        for (int i = 0; i < this.aliases.size(); ++i) {
            String alias = this.aliases.get(i);
            FeatureTypeInfo ft = this.featureTypes.get(i);
            typeMap.put(ft.getName(), ft);
            typeMap.put(ft.prefixedName(), ft);
            typeMap.put(alias, ft);
        }
        return typeMap;
    }

    private Map<String, String> buildNameToAlias() {
        HashMap<String, String> nameToAlias = new HashMap<String, String>();
        nameToAlias.put(this.primaryFeatureType.prefixedName(), this.primaryAlias);
        nameToAlias.put(this.primaryFeatureType.getName(), this.primaryAlias);
        for (int i = 0; i < this.aliases.size(); ++i) {
            String alias = this.aliases.get(i);
            FeatureTypeInfo ft = this.featureTypes.get(i);
            nameToAlias.put(ft.getName(), alias);
            nameToAlias.put(ft.prefixedName(), alias);
        }
        return nameToAlias;
    }

    private int getPrimaryFeatureTypeIndex(List<Filter> filters) {
        if (this.featureTypes.size() == 2) {
            return 0;
        }
        ArrayList<Integer> connecteds = new ArrayList<Integer>();
        for (int i = 0; i < this.featureTypes.size(); ++i) {
            connecteds.add(i);
        }
        for (Filter filter : filters) {
            Set<String> filterPrefixes = this.getFilterPrefixes(filter);
            Set<Integer> nameTypes = this.getPropertyNameTypeIndexes(filterPrefixes);
            connecteds.retainAll(nameTypes);
        }
        if (connecteds.isEmpty()) {
            throw new WFSException("Cannot run this type of join, at the moment GeoServer only supports joins having a single central feature type joined to all others");
        }
        return (Integer)connecteds.iterator().next();
    }

    private Set<Integer> getPropertyNameTypeIndexes(Set<String> filterPrefixes) {
        HashSet<Integer> nameTypes = new HashSet<Integer>();
        block0: for (String prefix : filterPrefixes) {
            int aliasIdx = this.aliases.indexOf(prefix);
            if (aliasIdx >= 0) {
                nameTypes.add(aliasIdx);
                continue;
            }
            for (int i = 0; i < this.featureTypes.size(); ++i) {
                FeatureTypeInfo ft = this.featureTypes.get(i);
                if (!prefix.equals(ft.prefixedName()) && !prefix.equals(ft.getName())) continue;
                nameTypes.add(i);
                continue block0;
            }
        }
        return nameTypes;
    }

    void updateFilter(Filter[] filters, int i, Filter filter) {
        filters[i] = filters[i] == null ? filter : ff.and(filters[i], filter);
    }

    class PropertyNameRewriter
    extends DuplicatingFilterVisitor {
        Map<String, String> nameToAlias;
        private Set<String> prefixes = new HashSet<String>();
        boolean addPrefix;

        public PropertyNameRewriter(Map<String, String> nameToAlias, boolean prefix) {
            this.prefixes.addAll(nameToAlias.keySet());
            this.prefixes.addAll(nameToAlias.values());
            this.prefixes.add(JoinExtractingVisitor.this.primaryAlias);
            this.nameToAlias = nameToAlias;
            this.addPrefix = prefix;
        }

        public Object visit(PropertyName expression, Object extraData) {
            String n = expression.getPropertyName();
            int idx = n.indexOf(47);
            String prefix = null;
            if (idx > 0) {
                prefix = n.substring(0, idx);
                if (this.prefixes.contains(prefix)) {
                    if (this.nameToAlias.get(prefix) != null) {
                        prefix = this.nameToAlias.get(prefix);
                    }
                    n = n.substring(idx + 1);
                } else {
                    n = null;
                }
            } else {
                n = null;
            }
            if (n != null) {
                if (this.addPrefix) {
                    n = (prefix != null ? prefix : "") + "." + n;
                }
                return this.ff.property(n);
            }
            return null;
        }
    }
}

