/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import com.vividsolutions.jts.geom.Geometry;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.feature.ReprojectingFeatureCollection;
import org.geoserver.wfs.AbstractTransactionElementHandler;
import org.geoserver.wfs.TransactionEvent;
import org.geoserver.wfs.TransactionEventType;
import org.geoserver.wfs.TransactionListener;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTransactionException;
import org.geoserver.wfs.request.Insert;
import org.geoserver.wfs.request.RequestObject;
import org.geoserver.wfs.request.TransactionElement;
import org.geoserver.wfs.request.TransactionRequest;
import org.geoserver.wfs.request.TransactionResponse;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureStore;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.Hints;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.FeatureCollection;
import org.geotools.geometry.jts.JTS;
import org.geotools.referencing.operation.projection.PointOutsideEnvelopeException;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.identity.FeatureId;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class InsertElementHandler
extends AbstractTransactionElementHandler {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.wfs");
    private FilterFactory filterFactory;

    public InsertElementHandler(GeoServer gs, FilterFactory filterFactory) {
        super(gs);
        this.filterFactory = filterFactory;
    }

    @Override
    public void checkValidity(TransactionElement element, Map<QName, FeatureTypeInfo> featureTypeInfos) throws WFSTransactionException {
        if (!this.getInfo().getServiceLevel().getOps().contains((Object)WFSInfo.Operation.TRANSACTION_INSERT)) {
            throw new WFSException((RequestObject)element, "Transaction INSERT support is not enabled");
        }
    }

    public void execute(TransactionElement element, TransactionRequest request, Map featureStores, TransactionResponse response, TransactionListener listener) throws WFSTransactionException {
        List featureList;
        Insert insert = (Insert)element;
        LOGGER.finer("Transasction Insert:" + insert);
        long inserted = response.getTotalInserted().longValue();
        try {
            SimpleFeatureType schema;
            HashMap<SimpleFeatureType, DefaultFeatureCollection> schema2features = new HashMap<SimpleFeatureType, DefaultFeatureCollection>();
            featureList = insert.getFeatures();
            for (SimpleFeature feature : featureList) {
                SimpleFeatureType schema2 = feature.getFeatureType();
                DefaultFeatureCollection collection = (DefaultFeatureCollection)schema2features.get(schema2);
                if (collection == null) {
                    collection = new DefaultFeatureCollection(null, schema2);
                    schema2features.put(schema2, collection);
                }
                if (insert.isIdGenUseExisting()) {
                    feature.getUserData().put(Hints.USE_PROVIDED_FID, true);
                }
                collection.add(feature);
            }
            HashMap schema2fids = new HashMap();
            for (SimpleFeatureCollection collection : schema2features.values()) {
                CoordinateReferenceSystem target;
                GeometryDescriptor defaultGeometry;
                schema = (SimpleFeatureType)collection.getSchema();
                QName elementName = new QName(schema.getName().getNamespaceURI(), schema.getTypeName());
                SimpleFeatureStore store = DataUtilities.simple((FeatureStore)((FeatureStore)featureStores.get(elementName)));
                if (store == null) {
                    throw new WFSException((RequestObject)request, "Could not locate FeatureStore for '" + elementName + "'");
                }
                if (collection == null) continue;
                if (this.getInfo().isCiteCompliant()) {
                    this.checkFeatureCoordinatesRange(collection);
                }
                if ((defaultGeometry = ((SimpleFeatureType)store.getSchema()).getGeometryDescriptor()) != null && (target = defaultGeometry.getCoordinateReferenceSystem()) != null) {
                    collection = new ReprojectingFeatureCollection(collection, target);
                }
                LOGGER.finer("Use featureValidation to check contents of insert");
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                if (fids == null) {
                    fids = new LinkedList();
                    schema2fids.put(schema.getTypeName(), fids);
                }
                TransactionEvent event = new TransactionEvent(TransactionEventType.PRE_INSERT, request, elementName, collection);
                event.setSource(Insert.WFS11.unadapt(insert));
                listener.dataStoreChange(event);
                fids.addAll(store.addFeatures((FeatureCollection)collection));
                SimpleFeatureCollection features = store.getFeatures((Filter)this.filterFactory.id(new HashSet(fids)));
                event = new TransactionEvent(TransactionEventType.POST_INSERT, request, elementName, features, Insert.WFS11.unadapt(insert));
                listener.dataStoreChange(event);
            }
            for (SimpleFeature feature : featureList) {
                schema = feature.getFeatureType();
                LinkedList fids = (LinkedList)schema2fids.get(schema.getTypeName());
                FeatureId fid = (FeatureId)fids.removeFirst();
                response.addInsertedFeature(insert.getHandle(), fid);
            }
        }
        catch (Exception e) {
            String msg = "Error performing insert: " + e.getMessage();
            throw new WFSTransactionException(msg, (Throwable)e, insert.getHandle());
        }
        response.setTotalInserted(BigInteger.valueOf(inserted += (long)featureList.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkFeatureCoordinatesRange(SimpleFeatureCollection collection) throws PointOutsideEnvelopeException {
        List types = ((SimpleFeatureType)collection.getSchema()).getAttributeDescriptors();
        try (SimpleFeatureIterator fi = collection.features();){
            while (fi.hasNext()) {
                SimpleFeature f = (SimpleFeature)fi.next();
                for (int i = 0; i < types.size(); ++i) {
                    Geometry geom;
                    GeometryDescriptor gat;
                    if (!(types.get(i) instanceof GeometryDescriptor) || (gat = (GeometryDescriptor)types.get(i)).getCoordinateReferenceSystem() == null || (geom = (Geometry)f.getAttribute(i)) == null) continue;
                    JTS.checkCoordinatesRange((Geometry)geom, (CoordinateReferenceSystem)gat.getCoordinateReferenceSystem());
                }
            }
        }
    }

    public Class getElementClass() {
        return Insert.class;
    }

    @Override
    public QName[] getTypeNames(TransactionElement element) throws WFSTransactionException {
        Insert insert = (Insert)element;
        ArrayList<QName> typeNames = new ArrayList<QName>();
        List features = insert.getFeatures();
        if (!features.isEmpty()) {
            for (SimpleFeature feature : features) {
                String name = feature.getFeatureType().getTypeName();
                String namespaceURI = feature.getFeatureType().getName().getNamespaceURI();
                typeNames.add(new QName(namespaceURI, name));
            }
        } else {
            LOGGER.finer("Insert was empty - does not need a FeatuerSoruce");
        }
        return typeNames.toArray(new QName[typeNames.size()]);
    }
}

