/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.awt.RenderingHints;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import net.opengis.wfs.XlinkPropertyNameType;
import net.opengis.wfs20.QueryType;
import net.opengis.wfs20.ResultTypeType;
import net.opengis.wfs20.StoredQueryType;
import org.geoserver.catalog.AttributeTypeInfo;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.feature.TypeNameExtractingVisitor;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.KvpMap;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wfs.AliasedQuery;
import org.geoserver.wfs.BBOXNamespaceSettingVisitor;
import org.geoserver.wfs.CatalogNamespaceSupport;
import org.geoserver.wfs.CountExecutor;
import org.geoserver.wfs.FeatureBoundsFeatureCollection;
import org.geoserver.wfs.JoinExtractingVisitor;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.StoredQuery;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSReprojectionUtil;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.Lock;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.LockFeatureResponse;
import org.geoserver.wfs.request.Query;
import org.geoserver.wfs.request.RequestObject;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.Join;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.NameImpl;
import org.geotools.feature.SchemaException;
import org.geotools.filter.FilterCapabilities;
import org.geotools.filter.expression.AbstractExpressionVisitor;
import org.geotools.filter.v2_0.FES;
import org.geotools.filter.v2_0.FESConfiguration;
import org.geotools.filter.visitor.AbstractFilterVisitor;
import org.geotools.filter.visitor.PostPreProcessFilterSplittingVisitor;
import org.geotools.filter.visitor.SimplifyingFilterVisitor;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.geotools.xml.Configuration;
import org.geotools.xml.Encoder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.feature.type.Name;
import org.opengis.filter.And;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.Id;
import org.opengis.filter.IncludeFilter;
import org.opengis.filter.Not;
import org.opengis.filter.Or;
import org.opengis.filter.PropertyIsBetween;
import org.opengis.filter.PropertyIsLike;
import org.opengis.filter.PropertyIsNull;
import org.opengis.filter.expression.ExpressionVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.filter.spatial.Beyond;
import org.opengis.filter.spatial.BinarySpatialOperator;
import org.opengis.filter.spatial.Contains;
import org.opengis.filter.spatial.Crosses;
import org.opengis.filter.spatial.DWithin;
import org.opengis.filter.spatial.Disjoint;
import org.opengis.filter.spatial.Equals;
import org.opengis.filter.spatial.Intersects;
import org.opengis.filter.spatial.Overlaps;
import org.opengis.filter.spatial.Touches;
import org.opengis.filter.spatial.Within;
import org.opengis.filter.temporal.After;
import org.opengis.filter.temporal.Before;
import org.opengis.filter.temporal.Begins;
import org.opengis.filter.temporal.BegunBy;
import org.opengis.filter.temporal.During;
import org.opengis.filter.temporal.EndedBy;
import org.opengis.filter.temporal.Ends;
import org.opengis.filter.temporal.TContains;
import org.opengis.filter.temporal.TEquals;
import org.opengis.geometry.Envelope;
import org.opengis.metadata.extent.GeographicBoundingBox;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.xml.sax.helpers.NamespaceSupport;

public class GetFeature {
    private static final Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.requests");
    private static final FilterCapabilities joinFilterCapabilities = new FilterCapabilities();
    protected Catalog catalog;
    protected WFSInfo wfs;
    protected FilterFactory2 filterFactory;
    StoredQueryProvider storedQueryProvider;

    public GetFeature(WFSInfo wfs, Catalog catalog) {
        this.wfs = wfs;
        this.catalog = catalog;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public NamespaceSupport getNamespaceSupport() {
        return new CatalogNamespaceSupport(this.catalog);
    }

    public WFSInfo getWFS() {
        return this.wfs;
    }

    public void setFilterFactory(FilterFactory2 filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setStoredQueryProvider(StoredQueryProvider storedQueryProvider) {
        this.storedQueryProvider = storedQueryProvider;
    }

    public FeatureCollectionResponse run(GetFeatureRequest request) throws WFSException {
        ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>> results;
        int totalOffset;
        int totalCount;
        int count;
        int maxFeatures;
        List<Query> queries;
        block56: {
            BigInteger bi;
            queries = request.getQueries();
            if (queries.isEmpty()) {
                throw new WFSException((RequestObject)request, "No query specified");
            }
            this.processStoredQueries(request);
            queries = request.getQueries();
            if (request.isQueryTypeNamesUnset()) {
                for (Query q : queries) {
                    if (!q.getTypeNames().isEmpty()) continue;
                    if (q.getFilter() != null) {
                        TypeNameExtractingVisitor v = new TypeNameExtractingVisitor(this.catalog);
                        q.getFilter().accept((FilterVisitor)v, null);
                        q.getTypeNames().addAll(v.getTypeNames());
                    }
                    if (!q.getTypeNames().isEmpty()) continue;
                    String msg = "No feature types specified";
                    throw new WFSException((RequestObject)request, msg);
                }
            }
            if ((bi = request.getMaxFeatures()) == null) {
                request.setMaxFeatures(BigInteger.valueOf(Integer.MAX_VALUE));
            }
            maxFeatures = Math.min(request.getMaxFeatures().intValue(), this.wfs.getMaxFeatures());
            if (this.wfs.isHitsIgnoreMaxFeatures() && request.isResultTypeHits()) {
                maxFeatures = Integer.MAX_VALUE;
            }
            List<Map<String, String>> viewParams = null;
            if (request.getViewParams() != null && request.getViewParams().size() > 0) {
                viewParams = request.getViewParams();
            }
            boolean isNumberMatchedSkipped = false;
            count = 0;
            totalCount = 0;
            int n = totalOffset = request.getStartIndex() != null ? request.getStartIndex().intValue() : -1;
            if (totalOffset == -1 && request.getVersion().startsWith("2") && this.wfs.isCiteCompliant()) {
                totalOffset = 0;
            }
            int offset = totalOffset;
            results = new ArrayList<FeatureCollection<? extends FeatureType, ? extends Feature>>();
            ArrayList<CountExecutor> totalCountExecutors = new ArrayList<CountExecutor>();
            try {
                for (int i = 0; i < queries.size() && count < maxFeatures; ++i) {
                    Query query = queries.get(i);
                    try {
                        if (!query.getAliases().isEmpty() && query.getAliases().size() != query.getTypeNames().size()) {
                            throw new WFSException((RequestObject)request, String.format("Query specifies %d type names and %d aliases, must be equal", query.getTypeNames().size(), query.getAliases().size()));
                        }
                        List<FeatureTypeInfo> metas = new ArrayList<FeatureTypeInfo>();
                        for (QName typeName : query.getTypeNames()) {
                            metas.add(this.featureTypeInfo(typeName, request));
                        }
                        FeatureTypeInfo meta = (FeatureTypeInfo)metas.get(0);
                        List<List<String>> reqPropertyNames = this.parsePropertyNames(query, metas);
                        NamespaceSupport ns = this.getNamespaceSupport();
                        List<Join> joins = null;
                        String primaryAlias = null;
                        QName primaryTypeName = query.getTypeNames().get(0);
                        FeatureTypeInfo primaryMeta = (FeatureTypeInfo)metas.get(0);
                        Filter filter = query.getFilter();
                        if (filter == null && metas.size() > 1) {
                            throw new WFSException((RequestObject)request, "Join query must specify a filter");
                        }
                        if (filter != null) {
                            if (meta.getFeatureType() instanceof SimpleFeatureType) {
                                if (metas.size() > 1) {
                                    query = AliasedQuery.fixAliases(metas, query);
                                    filter = query.getFilter();
                                    filter = SimplifyingFilterVisitor.simplify((Filter)filter);
                                    JoinExtractingVisitor extractor = new JoinExtractingVisitor(metas, query.getAliases());
                                    filter.accept((FilterVisitor)extractor, null);
                                    primaryAlias = extractor.getPrimaryAlias();
                                    primaryMeta = extractor.getPrimaryFeatureType();
                                    metas = extractor.getFeatureTypes();
                                    primaryTypeName = new QName(primaryMeta.getNamespace().getURI(), primaryMeta.getNativeName());
                                    joins = extractor.getJoins();
                                    if (joins.size() != metas.size() - 1) {
                                        throw new WFSException((RequestObject)request, String.format("Query specified %d types but %d join filters were found", metas.size(), extractor.getJoins().size()));
                                    }
                                    for (int j = 1; j < metas.size(); ++j) {
                                        Join join = joins.get(j - 1);
                                        if (!this.isValidJoinFilter(join.getJoinFilter())) {
                                            throw new WFSException((RequestObject)request, "Unable to perform join with specified join filter: " + filter);
                                        }
                                        if (join.getFilter() == null) continue;
                                        this.validateFilter(join.getFilter(), query, metas.get(j), request);
                                    }
                                    filter = extractor.getPrimaryFilter();
                                    if (filter != null) {
                                        this.validateFilter(filter, query, primaryMeta, request);
                                    }
                                } else {
                                    this.validateFilter(filter, query, meta, request);
                                }
                            } else {
                                BBOXNamespaceSettingVisitor filterVisitor = new BBOXNamespaceSettingVisitor(ns);
                                filter.accept((FilterVisitor)filterVisitor, null);
                            }
                        }
                        ArrayList<ArrayList<PropertyName>> propNames = new ArrayList<ArrayList<PropertyName>>();
                        ArrayList<ArrayList<PropertyName>> allPropNames = new ArrayList<ArrayList<PropertyName>>();
                        for (int j = 0; j < metas.size(); ++j) {
                            List<String> propertyNames = reqPropertyNames.get(j);
                            List<Object> metaPropNames = null;
                            List<Object> metaAllPropNames = null;
                            if (!propertyNames.isEmpty()) {
                                metaPropNames = new ArrayList<PropertyName>();
                                Iterator<String> iter = propertyNames.iterator();
                                while (iter.hasNext()) {
                                    PropertyName propName = this.createPropertyName(iter.next(), ns);
                                    if (propName.evaluate((Object)meta.getFeatureType()) == null) {
                                        String mesg = "Requested property: " + propName + " is " + "not available " + "for " + meta.getPrefixedName() + ".  ";
                                        if (meta.getFeatureType() instanceof SimpleFeatureType) {
                                            List atts = meta.attributes();
                                            ArrayList<String> attNames = new ArrayList<String>(atts.size());
                                            for (AttributeTypeInfo att : atts) {
                                                attNames.add(att.getName());
                                            }
                                            mesg = mesg + "The possible propertyName values are: " + attNames;
                                        }
                                        throw new WFSException((RequestObject)request, mesg, "InvalidParameterValue");
                                    }
                                    metaPropNames.add(propName);
                                }
                                metaAllPropNames = this.wfs.isFeatureBounding() ? this.addGeometryProperties(meta, metaPropNames) : metaPropNames;
                                if (meta.getFeatureType() instanceof SimpleFeatureType) {
                                    metaAllPropNames = DataUtilities.addMandatoryProperties((SimpleFeatureType)((SimpleFeatureType)meta.getFeatureType()), metaAllPropNames);
                                    metaPropNames = DataUtilities.addMandatoryProperties((SimpleFeatureType)((SimpleFeatureType)meta.getFeatureType()), metaPropNames);
                                }
                            }
                            allPropNames.add((ArrayList<PropertyName>)metaAllPropNames);
                            propNames.add((ArrayList<PropertyName>)metaPropNames);
                        }
                        List<SortBy> sortBy = query.getSortBy();
                        if (sortBy != null && !sortBy.isEmpty() && meta.getFeatureType() instanceof SimpleFeatureType) {
                            this.validateSortBy(sortBy, meta, request);
                        }
                        Hints hints = null;
                        if (joins != null) {
                            hints = new Hints((RenderingHints.Key)ResourcePool.JOINS, joins);
                        }
                        FeatureSource source = primaryMeta.getFeatureSource(null, hints);
                        int queryMaxFeatures = maxFeatures - count;
                        int metaMaxFeatures = this.maxFeatures(metas);
                        if (metaMaxFeatures > 0 && metaMaxFeatures < queryMaxFeatures) {
                            queryMaxFeatures = metaMaxFeatures;
                        }
                        Map<String, String> viewParam = viewParams != null ? viewParams.get(i) : null;
                        org.geotools.data.Query gtQuery = this.toDataQuery(query, filter, offset, queryMaxFeatures, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                        LOGGER.fine("Query is " + query + "\n To gt2: " + gtQuery);
                        Object features = this.getFeatures(request, (FeatureSource<? extends FeatureType, ? extends Feature>)source, gtQuery);
                        if (!(meta.getFeatureType() instanceof SimpleFeatureType)) {
                            features.getSchema().getUserData().put("targetCrs", query.getSrsName());
                            features.getSchema().getUserData().put("targetVersion", request.getVersion());
                        }
                        boolean calculateSize = true;
                        boolean bl = calculateSize = !"1.0".equals(request.getVersion()) && !"1.0.0".equals(request.getVersion()) || queries.size() != 1 && maxFeatures != Integer.MAX_VALUE;
                        if (!calculateSize) {
                            calculateSize = offset > 0 && i < queries.size() - 1;
                        }
                        int size = 0;
                        if (calculateSize) {
                            size = features.size();
                        }
                        count += size;
                        if (offset > 0) {
                            if (size > 0) {
                                offset = 0;
                            } else {
                                org.geotools.data.Query q2 = this.toDataQuery(query, filter, 0, queryMaxFeatures, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                                int size2 = source.getCount(q2);
                                if (size2 > 0) {
                                    offset = Math.max(0, offset - size2);
                                }
                            }
                        }
                        boolean bl2 = isNumberMatchedSkipped = meta.getSkipNumberMatched() && !request.isResultTypeHits();
                        if (!isNumberMatchedSkipped) {
                            if (calculateSize && (queryMaxFeatures == Integer.MAX_VALUE || size < queryMaxFeatures) && offset <= 0) {
                                totalCountExecutors.add(new CountExecutor(size));
                            } else {
                                org.geotools.data.Query qTotal = this.toDataQuery(query, filter, 0, Integer.MAX_VALUE, (FeatureSource<? extends FeatureType, ? extends Feature>)source, request, (List)allPropNames.get(0), viewParam, joins, primaryTypeName, primaryAlias);
                                totalCountExecutors.add(new CountExecutor(source, qTotal));
                            }
                        }
                        List metaPropNames = (List)propNames.get(0);
                        if (features.getSchema() instanceof SimpleFeatureType && metaPropNames != null && metaPropNames.size() < ((List)allPropNames.get(0)).size()) {
                            String[] residualNames = new String[metaPropNames.size()];
                            Iterator it = metaPropNames.iterator();
                            int j = 0;
                            while (it.hasNext()) {
                                residualNames[j] = ((PropertyName)it.next()).getPropertyName();
                                ++j;
                            }
                            SimpleFeatureType targetType = DataUtilities.createSubType((SimpleFeatureType)((SimpleFeatureType)features.getSchema()), (String[])residualNames);
                            features = new FeatureBoundsFeatureCollection((SimpleFeatureCollection)features, targetType);
                        }
                        results.add((FeatureCollection<? extends FeatureType, ? extends Feature>)features);
                        continue;
                    }
                    catch (WFSException e) {
                        if (query.getHandle() != null && (e.getLocator() == null || "GetFeature".equalsIgnoreCase(e.getLocator()))) {
                            e.setLocator(query.getHandle());
                        }
                        throw e;
                    }
                }
                if (!request.getVersion().startsWith("2")) {
                    totalCount = -1;
                    break block56;
                }
                if (isNumberMatchedSkipped) {
                    totalCount = -1;
                    totalOffset = 0;
                    break block56;
                }
                if (count < maxFeatures) {
                    totalCount = count;
                    break block56;
                }
                for (CountExecutor q : totalCountExecutors) {
                    int result = q.getCount();
                    if (result == -1) {
                        totalCount = -1;
                        break;
                    }
                    totalCount += result;
                }
            }
            catch (IOException e) {
                throw new WFSException(request, "Error occurred getting features", (Throwable)e, request.getHandle());
            }
            catch (SchemaException e) {
                throw new WFSException(request, "Error occurred getting features", (Throwable)e, request.getHandle());
            }
        }
        String lockId = null;
        if (request.isLockRequest()) {
            LockFeatureRequest lockRequest = request.createLockRequest();
            lockRequest.setExpiry(request.getExpiry());
            lockRequest.setHandle(request.getHandle());
            lockRequest.setLockActionAll();
            for (int i = 0; i < queries.size(); ++i) {
                Query query = queries.get(i);
                Lock lock = lockRequest.createLock();
                lock.setFilter(query.getFilter());
                lock.setHandle(query.getHandle());
                List<QName> typeNames = query.getTypeNames();
                lock.setTypeName(typeNames.get(0));
                lockRequest.addLock(lock);
            }
            LockFeature lockFeature = new LockFeature(this.wfs, this.catalog);
            lockFeature.setFilterFactory((FilterFactory)this.filterFactory);
            LockFeatureResponse response = lockFeature.lockFeature(lockRequest);
            lockId = response.getLockId();
        }
        return this.buildResults(request, totalOffset, maxFeatures, count, totalCount, results, lockId);
    }

    protected void processStoredQueries(GetFeatureRequest request) {
        List<Object> queries = request.getAdaptedQueries();
        for (int i = 0; i < queries.size(); ++i) {
            Object obj = queries.get(i);
            if (!(obj instanceof StoredQueryType)) continue;
            if (this.storedQueryProvider == null) {
                throw new WFSException((RequestObject)request, "Stored query not supported");
            }
            StoredQueryType sq = (StoredQueryType)obj;
            StoredQuery storedQuery = this.storedQueryProvider.getStoredQuery(sq.getId());
            if (storedQuery == null) {
                throw new WFSException((RequestObject)request, "Stored query '" + sq.getId() + "' does not exist.");
            }
            List<QueryType> compiled = storedQuery.compile(sq);
            queries.remove(i);
            queries.addAll(i, compiled);
            i += compiled.size();
        }
    }

    protected FeatureCollectionResponse buildResults(GetFeatureRequest request, int offset, int maxFeatures, int count, int total, List results, String lockId) {
        FeatureCollectionResponse result = request.createResponse();
        result.setNumberOfFeatures(BigInteger.valueOf(count));
        result.setTotalNumberOfFeatures(BigInteger.valueOf(total));
        result.setTimeStamp(Calendar.getInstance());
        result.setLockId(lockId);
        result.getFeature().addAll(results);
        if (offset > 0 || count < Integer.MAX_VALUE) {
            int nextCount;
            Request req = (Request)Dispatcher.REQUEST.get();
            KvpMap kvp = null;
            kvp = req.isGet() ? new KvpMap(req.getRawKvp()) : this.buildKvpFromRequest(request);
            if (offset > 0) {
                int prevOffset = Math.max(offset - maxFeatures, 0);
                kvp.put("startIndex", String.valueOf(prevOffset));
                kvp.put("count", String.valueOf(offset - prevOffset));
                result.setPrevious(ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"wfs", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
            }
            if (count > 0 && offset > -1 && (nextCount = total - (offset + count)) > 0) {
                kvp.put("startIndex", String.valueOf(offset > 0 ? offset + count : count));
                kvp.put("count", String.valueOf(maxFeatures));
                result.setNext(ResponseUtils.buildURL((String)request.getBaseUrl(), (String)"wfs", (Map)kvp, (URLMangler.URLType)URLMangler.URLType.SERVICE));
            }
        }
        return result;
    }

    KvpMap buildKvpFromRequest(GetFeatureRequest request) {
        KvpMap kvp = new KvpMap();
        kvp.put((Object)"SERVICE", (Object)"WFS");
        kvp.put((Object)"REQUEST", (Object)"GetFeature");
        kvp.put((Object)"VERSION", (Object)request.getVersion());
        kvp.put((Object)"OUTPUTFORMAT", (Object)request.getOutputFormat());
        kvp.put((Object)"RESULTTYPE", (Object)(request.isResultTypeHits() ? ResultTypeType.HITS.name() : ResultTypeType.RESULTS.name()));
        List<Query> queries = request.getQueries();
        Query q = queries.get(0);
        if (q.getSrsName() != null) {
            kvp.put((Object)"SRSNAME", (Object)q.getSrsName().toString());
        }
        StringBuilder typeNames = new StringBuilder();
        StringBuilder propertyName = !q.getPropertyNames().isEmpty() ? new StringBuilder() : null;
        StringBuilder aliases = !q.getAliases().isEmpty() ? new StringBuilder() : null;
        StringBuilder filter = q.getFilter() != null && q.getFilter() != Filter.INCLUDE ? new StringBuilder() : null;
        this.encodeQueryAsKvp(q, typeNames, propertyName, aliases, filter, true);
        if (queries.size() > 1) {
            for (int i = 1; i < queries.size(); ++i) {
                this.encodeQueryAsKvp(queries.get(i), typeNames, propertyName, aliases, filter, true);
            }
        }
        kvp.put((Object)"TYPENAMES", (Object)typeNames.toString());
        if (propertyName != null) {
            kvp.put((Object)"PROPERTYNAME", (Object)propertyName.toString());
        }
        if (aliases != null) {
            kvp.put((Object)"ALIASES", (Object)aliases.toString());
        }
        if (filter != null) {
            kvp.put((Object)"FILTER", (Object)filter.toString());
        }
        return kvp;
    }

    void encodeQueryAsKvp(Query q, StringBuilder typeNames, StringBuilder propertyName, StringBuilder aliases, StringBuilder filter, boolean useDelim) {
        if (useDelim) {
            typeNames.append("(");
        }
        for (QName qName : q.getTypeNames()) {
            typeNames.append(qName.getPrefix()).append(":").append(qName.getLocalPart()).append(",");
        }
        typeNames.setLength(typeNames.length() - 1);
        if (useDelim) {
            typeNames.append(")");
        }
        if (propertyName != null) {
            if (useDelim) {
                propertyName.append("(");
            }
            for (String pName : q.getPropertyNames()) {
                propertyName.append(pName).append(",");
            }
            propertyName.setLength(propertyName.length() - 1);
            if (useDelim) {
                propertyName.append(")");
            }
        }
        if (aliases != null) {
            if (useDelim) {
                aliases.append("(");
            }
            for (String alias : q.getAliases()) {
                aliases.append(alias).append(",");
            }
            aliases.setLength(aliases.length() - 1);
            if (useDelim) {
                aliases.append(")");
            }
        }
        if (filter != null) {
            Filter f = q.getFilter();
            if (useDelim) {
                filter.append("(");
            }
            try {
                Encoder e = new Encoder((Configuration)new FESConfiguration());
                e.setOmitXMLDeclaration(true);
                filter.append(e.encodeAsString((Object)q.getFilter(), FES.Filter));
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to encode filter " + f, e);
            }
            if (useDelim) {
                filter.append(")");
            }
        }
    }

    protected FeatureCollection<? extends FeatureType, ? extends Feature> getFeatures(Object request, FeatureSource<? extends FeatureType, ? extends Feature> source, org.geotools.data.Query gtQuery) throws IOException {
        return source.getFeatures(gtQuery);
    }

    public org.geotools.data.Query toDataQuery(Query query, Filter filter, int offset, int maxFeatures, FeatureSource<? extends FeatureType, ? extends Feature> source, GetFeatureRequest request, List<PropertyName> props, Map<String, String> viewParams, List<Join> joins, QName primaryTypeName, String primaryAlias) throws WFSException {
        Iterator<XlinkPropertyNameType> x;
        List<XlinkPropertyNameType> xlinkProperties;
        String featureVersion;
        List<SortBy> sortBy;
        CoordinateReferenceSystem target;
        URI srsName;
        String wfsVersion = request.getVersion();
        if (maxFeatures <= 0) {
            maxFeatures = Integer.MAX_VALUE;
        }
        if (filter == null) {
            filter = Filter.INCLUDE;
        } else {
            SimplifyingFilterVisitor visitor = new SimplifyingFilterVisitor();
            filter = (Filter)filter.accept((FilterVisitor)visitor, null);
        }
        CoordinateReferenceSystem crs = source.getSchema().getCoordinateReferenceSystem();
        CoordinateReferenceSystem declaredCRS = WFSReprojectionUtil.getDeclaredCrs(crs, wfsVersion);
        Filter transformedFilter = filter;
        if (declaredCRS != null) {
            transformedFilter = WFSReprojectionUtil.normalizeFilterCRS(filter, source.getSchema(), declaredCRS);
        }
        QName typeName = primaryTypeName;
        org.geotools.data.Query dataQuery = new org.geotools.data.Query(typeName.getLocalPart(), transformedFilter, maxFeatures, props, query.getHandle());
        if (primaryAlias != null) {
            dataQuery.setAlias(primaryAlias);
        }
        if ((srsName = query.getSrsName()) != null) {
            try {
                target = CRS.decode((String)srsName.toString());
            }
            catch (Exception e) {
                String msg = "Unable to support srsName: " + srsName;
                throw new WFSException(request, msg, (Throwable)e, "InvalidParameterValue").locator("srsName");
            }
        } else {
            target = declaredCRS;
        }
        if (target != null && declaredCRS != null && !CRS.equalsIgnoreMetadata((Object)crs, (Object)target)) {
            dataQuery.setCoordinateSystemReproject(target);
        }
        if ((sortBy = query.getSortBy()) != null) {
            dataQuery.setSortBy(sortBy.toArray(new SortBy[sortBy.size()]));
        }
        if ((featureVersion = query.getFeatureVersion()) != null) {
            dataQuery.setVersion(featureVersion);
        }
        if (offset > -1) {
            dataQuery.setStartIndex(Integer.valueOf(offset));
        }
        Hints hints = new Hints();
        String traverseXlinkDepth = request.getTraverseXlinkDepth();
        if (traverseXlinkDepth != null) {
            Integer depth = GetFeature.traverseXlinkDepth(traverseXlinkDepth);
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)depth);
        }
        hints.put((Object)Hints.RESOLVE, (Object)request.getResolve());
        BigInteger resolveTimeOut = request.getResolveTimeOut();
        if (resolveTimeOut != null) {
            hints.put((Object)Hints.RESOLVE_TIMEOUT, (Object)resolveTimeOut.intValue());
        }
        if (!(xlinkProperties = query.getXlinkPropertyNames()).isEmpty() && (x = xlinkProperties.iterator()).hasNext()) {
            XlinkPropertyNameType xlinkProperty = x.next();
            Integer xlinkDepth = GetFeature.traverseXlinkDepth(xlinkProperty.getTraverseXlinkDepth());
            hints.put((Object)Hints.ASSOCIATION_TRAVERSAL_DEPTH, (Object)xlinkDepth);
            PropertyName xlinkPropertyName = this.filterFactory.property(xlinkProperty.getValue());
            hints.put((Object)Hints.ASSOCIATION_PROPERTY, (Object)xlinkPropertyName);
            dataQuery.setHints(hints);
        }
        hints.put((Object)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory());
        if (viewParams != null) {
            hints.put((Object)Hints.VIRTUAL_TABLE_PARAMETERS, viewParams);
        }
        hints.put((Object)org.geotools.data.Query.INCLUDE_MANDATORY_PROPS, (Object)true);
        if (joins != null) {
            dataQuery.getJoins().addAll(joins);
        }
        dataQuery.setHints(hints);
        return dataQuery;
    }

    static Integer traverseXlinkDepth(String raw) {
        Integer traverseXlinkDepth = null;
        try {
            traverseXlinkDepth = new Integer(raw);
        }
        catch (NumberFormatException nfe) {
            if ("*".equals(raw)) {
                traverseXlinkDepth = new Integer(2);
            }
            throw nfe;
        }
        return traverseXlinkDepth;
    }

    boolean isValidJoinFilter(Filter filter) {
        PostPreProcessFilterSplittingVisitor visitor = new PostPreProcessFilterSplittingVisitor(joinFilterCapabilities, null, null);
        filter.accept((FilterVisitor)visitor, null);
        return visitor.getFilterPost() == null || visitor.getFilterPost() == Filter.INCLUDE;
    }

    FeatureTypeInfo featureTypeInfo(QName name, GetFeatureRequest request) throws WFSException, IOException {
        FeatureTypeInfo meta = this.catalog.getFeatureTypeByName(name.getNamespaceURI(), name.getLocalPart());
        if (meta == null) {
            String msg = "Could not locate " + name + " in catalog.";
            throw new WFSException((RequestObject)request, msg, "InvalidParameterValue").locator("typeName");
        }
        return meta;
    }

    List<List<String>> parsePropertyNames(Query query, List<FeatureTypeInfo> featureTypes) {
        ArrayList<List<String>> propNames = new ArrayList<List<String>>();
        for (FeatureTypeInfo featureType : featureTypes) {
            propNames.add(new ArrayList());
        }
        if (featureTypes.size() == 1) {
            ((List)propNames.get(0)).addAll(query.getPropertyNames());
            return propNames;
        }
        block1: for (String propName : query.getPropertyNames()) {
            int j;
            for (j = 0; j < featureTypes.size(); ++j) {
                FeatureTypeInfo featureType = featureTypes.get(j);
                if (propName.startsWith(featureType.getPrefixedName() + "/")) {
                    ((List)propNames.get(j)).add(propName.substring((featureType.getPrefixedName() + "/").length()));
                    continue block1;
                }
                if (!propName.startsWith(featureType.getName() + "/")) continue;
                ((List)propNames.get(j)).add(propName.substring((featureType.getName() + "/").length()));
                continue block1;
            }
            for (j = 0; j < query.getAliases().size(); ++j) {
                String alias = query.getAliases().get(j);
                if (!propName.startsWith(alias + "/")) continue;
                ((List)propNames.get(j)).add(propName.substring((alias + "/").length()));
                continue block1;
            }
            ((List)propNames.get(0)).add(propName);
        }
        return propNames;
    }

    void validateSortBy(List<SortBy> sortBys, FeatureTypeInfo meta, GetFeatureRequest request) throws IOException {
        FeatureType featureType = meta.getFeatureType();
        for (SortBy sortBy : sortBys) {
            PropertyName name = sortBy.getPropertyName();
            if (name.evaluate((Object)featureType) != null) continue;
            throw new WFSException((RequestObject)request, "Illegal property name: " + name.getPropertyName() + " for feature type " + meta.prefixedName(), "InvalidParameterValue");
        }
    }

    void validateFilter(Filter filter, Query query, final FeatureTypeInfo meta, final GetFeatureRequest request) throws IOException {
        final FeatureType featureType = meta.getFeatureType();
        AbstractExpressionVisitor visitor = new AbstractExpressionVisitor(){

            public Object visit(PropertyName name, Object data) {
                if (name.evaluate((Object)featureType) == null) {
                    throw new WFSException((RequestObject)request, "Illegal property name: " + name.getPropertyName() + " for feature type " + meta.prefixedName(), "InvalidParameterValue");
                }
                return name;
            }
        };
        filter.accept((FilterVisitor)new AbstractFilterVisitor((ExpressionVisitor)visitor), null);
        AbstractFilterVisitor fvisitor = new AbstractFilterVisitor(){

            protected Object visit(BinarySpatialOperator filter, Object data) {
                AttributeDescriptor att;
                PropertyName name = null;
                if (filter.getExpression1() instanceof PropertyName) {
                    name = (PropertyName)filter.getExpression1();
                } else if (filter.getExpression2() instanceof PropertyName) {
                    name = (PropertyName)filter.getExpression2();
                }
                if (name != null && !((att = (AttributeDescriptor)name.evaluate((Object)featureType)) instanceof GeometryDescriptor)) {
                    throw new WFSException((RequestObject)request, "Property " + name + " is not geometric in feature type " + meta.prefixedName(), "InvalidParameterValue");
                }
                return filter;
            }
        };
        filter.accept((FilterVisitor)fvisitor, null);
        if (this.wfs.isCiteCompliant() && query.getSrsName() != null) {
            final Query fquery = query;
            fvisitor = new AbstractFilterVisitor(){

                public Object visit(BBOX filter, Object data) {
                    if (filter.getSRS() != null && !fquery.getSrsName().toString().equals(filter.getSRS())) {
                        DefaultGeographicCRS geo = DefaultGeographicCRS.WGS84;
                        GeneralEnvelope e = new GeneralEnvelope(new double[]{filter.getMinX(), filter.getMinY()}, new double[]{filter.getMaxX(), filter.getMaxY()});
                        CoordinateReferenceSystem crs = null;
                        try {
                            crs = CRS.decode((String)filter.getSRS());
                            e.setCoordinateReferenceSystem(crs);
                            e = CRS.transform((Envelope)e, (CoordinateReferenceSystem)geo);
                        }
                        catch (Exception ex) {
                            throw new WFSException((RequestObject)request, (Throwable)ex);
                        }
                        try {
                            crs = CRS.decode((String)fquery.getSrsName().toString());
                        }
                        catch (Exception ex) {
                            throw new WFSException((RequestObject)request, (Throwable)ex);
                        }
                        GeographicBoundingBox valid = (GeographicBoundingBox)crs.getDomainOfValidity().getGeographicElements().iterator().next();
                        if (e.getMinimum(0) < valid.getWestBoundLongitude() || e.getMinimum(0) > valid.getEastBoundLongitude() || e.getMaximum(0) < valid.getWestBoundLongitude() || e.getMaximum(0) > valid.getEastBoundLongitude() || e.getMinimum(1) < valid.getSouthBoundLatitude() || e.getMinimum(1) > valid.getNorthBoundLatitude() || e.getMaximum(1) < valid.getSouthBoundLatitude() || e.getMaximum(1) > valid.getNorthBoundLatitude()) {
                            throw new WFSException((RequestObject)request, "bounding box out of valid range of crs", "InvalidParameterValue");
                        }
                    }
                    return data;
                }
            };
            filter.accept((FilterVisitor)fvisitor, null);
        }
    }

    int maxFeatures(List<FeatureTypeInfo> metas) {
        int maxFeatures = Integer.MAX_VALUE;
        for (FeatureTypeInfo meta : metas) {
            if (meta.getMaxFeatures() <= 0) continue;
            maxFeatures = Math.min(maxFeatures, meta.getMaxFeatures());
        }
        return maxFeatures;
    }

    protected PropertyName createPropertyName(String path, NamespaceSupport namespaceContext) {
        if (path.contains("/")) {
            return this.filterFactory.property(path, namespaceContext);
        }
        if (path.contains(":")) {
            int i = path.indexOf(":");
            return this.filterFactory.property((Name)new NameImpl(namespaceContext.getURI(path.substring(0, i)), path.substring(i + 1)));
        }
        return this.filterFactory.property(path);
    }

    protected List<PropertyName> addGeometryProperties(FeatureTypeInfo meta, List<PropertyName> oldProperties) throws IOException {
        List atts = meta.attributes();
        Iterator ii = atts.iterator();
        ArrayList<PropertyName> properties = new ArrayList<PropertyName>(oldProperties);
        while (ii.hasNext()) {
            AttributeTypeInfo ati = (AttributeTypeInfo)ii.next();
            PropertyName propName = this.filterFactory.property(ati.getName());
            if (!(meta.getFeatureType().getDescriptor(ati.getName()) instanceof GeometryDescriptor) || properties.contains(propName)) continue;
            properties.add(propName);
        }
        return properties;
    }

    static {
        joinFilterCapabilities.addAll(FilterCapabilities.SIMPLE_COMPARISONS_OPENGIS);
        joinFilterCapabilities.addType(PropertyIsNull.class);
        joinFilterCapabilities.addType(PropertyIsBetween.class);
        joinFilterCapabilities.addType(Id.class);
        joinFilterCapabilities.addType(IncludeFilter.class);
        joinFilterCapabilities.addType(ExcludeFilter.class);
        joinFilterCapabilities.addType(PropertyIsLike.class);
        joinFilterCapabilities.addType(BBOX.class);
        joinFilterCapabilities.addType(Contains.class);
        joinFilterCapabilities.addType(Crosses.class);
        joinFilterCapabilities.addType(Disjoint.class);
        joinFilterCapabilities.addType(Equals.class);
        joinFilterCapabilities.addType(Intersects.class);
        joinFilterCapabilities.addType(Overlaps.class);
        joinFilterCapabilities.addType(Touches.class);
        joinFilterCapabilities.addType(Within.class);
        joinFilterCapabilities.addType(DWithin.class);
        joinFilterCapabilities.addType(Beyond.class);
        joinFilterCapabilities.addType(After.class);
        joinFilterCapabilities.addType(Before.class);
        joinFilterCapabilities.addType(Begins.class);
        joinFilterCapabilities.addType(BegunBy.class);
        joinFilterCapabilities.addType(During.class);
        joinFilterCapabilities.addType(Ends.class);
        joinFilterCapabilities.addType(EndedBy.class);
        joinFilterCapabilities.addType(TContains.class);
        joinFilterCapabilities.addType(TEquals.class);
        joinFilterCapabilities.addType(And.class);
        joinFilterCapabilities.addType(Or.class);
        joinFilterCapabilities.addType(Not.class);
    }
}

