/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import net.opengis.wfs20.CreateStoredQueryResponseType;
import net.opengis.wfs20.CreateStoredQueryType;
import net.opengis.wfs20.DescribeFeatureTypeType;
import net.opengis.wfs20.DescribeStoredQueriesResponseType;
import net.opengis.wfs20.DescribeStoredQueriesType;
import net.opengis.wfs20.DropStoredQueryType;
import net.opengis.wfs20.ExecutionStatusType;
import net.opengis.wfs20.GetCapabilitiesType;
import net.opengis.wfs20.GetFeatureType;
import net.opengis.wfs20.GetFeatureWithLockType;
import net.opengis.wfs20.GetPropertyValueType;
import net.opengis.wfs20.ListStoredQueriesResponseType;
import net.opengis.wfs20.ListStoredQueriesType;
import net.opengis.wfs20.LockFeatureResponseType;
import net.opengis.wfs20.LockFeatureType;
import net.opengis.wfs20.TransactionResponseType;
import net.opengis.wfs20.TransactionType;
import net.opengis.wfs20.ValueCollectionType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.CreateStoredQuery;
import org.geoserver.wfs.DescribeFeatureType;
import org.geoserver.wfs.DescribeStoredQueries;
import org.geoserver.wfs.DropStoredQuery;
import org.geoserver.wfs.GetCapabilities;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.GetPropertyValue;
import org.geoserver.wfs.ListStoredQueries;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.Transaction;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSExtensions;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WebFeatureService20;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.TransactionRequest;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWebFeatureService20
implements WebFeatureService20,
ApplicationContextAware {
    protected GeoServer geoServer;
    protected FilterFactory2 filterFactory;
    protected ApplicationContext context;

    public DefaultWebFeatureService20(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public void setFilterFactory(FilterFactory2 filterFactory) {
        this.filterFactory = filterFactory;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }

    @Override
    public WFSInfo getServiceInfo() {
        return (WFSInfo)this.geoServer.getService(WFSInfo.class);
    }

    public Catalog getCatalog() {
        return this.geoServer.getCatalog();
    }

    public StoredQueryProvider getStoredQueryProvider() {
        return new StoredQueryProvider(this.getCatalog());
    }

    @Override
    public TransformerBase getCapabilities(GetCapabilitiesType request) throws WFSException {
        return new GetCapabilities(this.getServiceInfo(), this.getCatalog(), WFSExtensions.findExtendedCapabilitiesProviders(this.context)).run(new GetCapabilitiesRequest.WFS20((EObject)request));
    }

    @Override
    public FeatureTypeInfo[] describeFeatureType(DescribeFeatureTypeType request) throws WFSException {
        return new DescribeFeatureType(this.getServiceInfo(), this.getCatalog()).run(new DescribeFeatureTypeRequest.WFS20((EObject)request));
    }

    @Override
    public FeatureCollectionResponse getFeature(GetFeatureType request) throws WFSException {
        GetFeature gf = new GetFeature(this.getServiceInfo(), this.getCatalog());
        gf.setFilterFactory(this.filterFactory);
        gf.setStoredQueryProvider(this.getStoredQueryProvider());
        return gf.run(new GetFeatureRequest.WFS20((EObject)request));
    }

    @Override
    public FeatureCollectionResponse getFeatureWithLock(GetFeatureWithLockType request) throws WFSException {
        return this.getFeature((GetFeatureType)request);
    }

    @Override
    public ValueCollectionType getPropertyValue(GetPropertyValueType request) throws WFSException {
        return new GetPropertyValue(this.getServiceInfo(), this.getCatalog(), this.filterFactory).run(request);
    }

    @Override
    public LockFeatureResponseType lockFeature(LockFeatureType request) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.getServiceInfo(), this.getCatalog(), (FilterFactory)this.filterFactory);
        return (LockFeatureResponseType)lockFeature.lockFeature(new LockFeatureRequest.WFS20((EObject)request)).getAdaptee();
    }

    @Override
    public TransactionResponseType transaction(TransactionType request) throws WFSException {
        Transaction tx = new Transaction(this.getServiceInfo(), this.getCatalog(), this.context);
        tx.setFilterFactory((FilterFactory)this.filterFactory);
        return (TransactionResponseType)tx.transaction(new TransactionRequest.WFS20((EObject)request)).getAdaptee();
    }

    @Override
    public ListStoredQueriesResponseType listStoredQueries(ListStoredQueriesType request) throws WFSException {
        return new ListStoredQueries(this.getServiceInfo(), this.getStoredQueryProvider()).run(request);
    }

    @Override
    public DescribeStoredQueriesResponseType describeStoredQueries(DescribeStoredQueriesType request) throws WFSException {
        return new DescribeStoredQueries(this.getServiceInfo(), this.getStoredQueryProvider()).run(request);
    }

    @Override
    public CreateStoredQueryResponseType createStoredQuery(CreateStoredQueryType request) throws WFSException {
        return new CreateStoredQuery(this.getServiceInfo(), this.getStoredQueryProvider()).run(request);
    }

    @Override
    public ExecutionStatusType dropStoredQuery(DropStoredQueryType request) throws WFSException {
        return new DropStoredQuery(this.getServiceInfo(), this.getStoredQueryProvider()).run(request);
    }

    @Override
    public void releaseLock(String lockId) throws WFSException {
        new LockFeature(this.getServiceInfo(), this.getCatalog()).release(lockId);
    }
}

