/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import net.opengis.wfs.DescribeFeatureTypeType;
import net.opengis.wfs.GetCapabilitiesType;
import net.opengis.wfs.GetFeatureType;
import net.opengis.wfs.GetFeatureWithLockType;
import net.opengis.wfs.GetGmlObjectType;
import net.opengis.wfs.LockFeatureResponseType;
import net.opengis.wfs.LockFeatureType;
import net.opengis.wfs.TransactionResponseType;
import net.opengis.wfs.TransactionType;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.wfs.DescribeFeatureType;
import org.geoserver.wfs.GetCapabilities;
import org.geoserver.wfs.GetFeature;
import org.geoserver.wfs.GetGmlObject;
import org.geoserver.wfs.LockFeature;
import org.geoserver.wfs.Transaction;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSExtensions;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WebFeatureService;
import org.geoserver.wfs.request.DescribeFeatureTypeRequest;
import org.geoserver.wfs.request.FeatureCollectionResponse;
import org.geoserver.wfs.request.GetCapabilitiesRequest;
import org.geoserver.wfs.request.GetFeatureRequest;
import org.geoserver.wfs.request.LockFeatureRequest;
import org.geoserver.wfs.request.TransactionRequest;
import org.geotools.xml.transform.TransformerBase;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.FilterFactory2;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class DefaultWebFeatureService
implements WebFeatureService,
ApplicationContextAware {
    protected GeoServer geoServer;
    protected Catalog catalog;
    protected FilterFactory2 filterFactory;
    protected ApplicationContext context;

    public DefaultWebFeatureService(GeoServer gs) {
        this.geoServer = gs;
        this.catalog = gs.getCatalog();
    }

    public void setFilterFactory(FilterFactory2 filterFactory) {
        this.filterFactory = filterFactory;
    }

    @Override
    public WFSInfo getServiceInfo() {
        return (WFSInfo)this.geoServer.getService(WFSInfo.class);
    }

    @Override
    public TransformerBase getCapabilities(GetCapabilitiesType request) throws WFSException {
        return new GetCapabilities(this.getServiceInfo(), this.catalog, WFSExtensions.findExtendedCapabilitiesProviders(this.context)).run(new GetCapabilitiesRequest.WFS11((EObject)request));
    }

    @Override
    public FeatureTypeInfo[] describeFeatureType(DescribeFeatureTypeType request) throws WFSException {
        return new DescribeFeatureType(this.getServiceInfo(), this.catalog).run(new DescribeFeatureTypeRequest.WFS11((EObject)request));
    }

    @Override
    public FeatureCollectionResponse getFeature(GetFeatureType request) throws WFSException {
        GetFeature getFeature = new GetFeature(this.getServiceInfo(), this.catalog);
        getFeature.setFilterFactory(this.filterFactory);
        return getFeature.run(new GetFeatureRequest.WFS11((EObject)request));
    }

    @Override
    public FeatureCollectionResponse getFeatureWithLock(GetFeatureWithLockType request) throws WFSException {
        return this.getFeature((GetFeatureType)request);
    }

    @Override
    public LockFeatureResponseType lockFeature(LockFeatureType request) throws WFSException {
        LockFeature lockFeature = new LockFeature(this.getServiceInfo(), this.catalog);
        lockFeature.setFilterFactory((FilterFactory)this.filterFactory);
        return (LockFeatureResponseType)lockFeature.lockFeature(new LockFeatureRequest.WFS11((EObject)request)).getAdaptee();
    }

    @Override
    public TransactionResponseType transaction(TransactionType request) throws WFSException {
        Transaction transaction = new Transaction(this.getServiceInfo(), this.catalog, this.context);
        transaction.setFilterFactory((FilterFactory)this.filterFactory);
        return (TransactionResponseType)transaction.transaction(new TransactionRequest.WFS11((EObject)request)).getAdaptee();
    }

    @Override
    public Object getGmlObject(GetGmlObjectType request) throws WFSException {
        GetGmlObject getGmlObject = new GetGmlObject(this.getServiceInfo(), this.catalog);
        getGmlObject.setFilterFactory((FilterFactory)this.filterFactory);
        return getGmlObject.run(request);
    }

    @Override
    public void releaseLock(String lockId) throws WFSException {
        new LockFeature(this.getServiceInfo(), this.catalog).release(lockId);
    }

    public void releaseAllLocks() throws WFSException {
        new LockFeature(this.getServiceInfo(), this.catalog).releaseAll();
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = context;
    }
}

