/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import net.opengis.wfs20.CreateStoredQueryResponseType;
import net.opengis.wfs20.CreateStoredQueryType;
import net.opengis.wfs20.QueryExpressionTextType;
import net.opengis.wfs20.StoredQueryDescriptionType;
import net.opengis.wfs20.Wfs20Factory;
import org.eclipse.emf.ecore.EObject;
import org.geoserver.wfs.StoredQueryProvider;
import org.geoserver.wfs.WFSException;
import org.geoserver.wfs.WFSInfo;

public class CreateStoredQuery {
    WFSInfo wfs;
    StoredQueryProvider storedQueryProvider;

    public CreateStoredQuery(WFSInfo wfs, StoredQueryProvider storedQueryProvider) {
        this.wfs = wfs;
        this.storedQueryProvider = storedQueryProvider;
    }

    public CreateStoredQueryResponseType run(CreateStoredQueryType request) throws WFSException {
        for (StoredQueryDescriptionType sqd : request.getStoredQueryDefinition()) {
            this.validateStoredQuery(request, sqd);
            try {
                this.storedQueryProvider.createStoredQuery(sqd);
            }
            catch (Exception e) {
                throw new WFSException((EObject)request, "Error occured creating stored query", (Throwable)e);
            }
        }
        Wfs20Factory factory = Wfs20Factory.eINSTANCE;
        CreateStoredQueryResponseType response = factory.createCreateStoredQueryResponseType();
        response.setStatus("OK");
        return response;
    }

    void validateStoredQuery(CreateStoredQueryType request, StoredQueryDescriptionType sq) throws WFSException {
        if (sq.getQueryExpressionText().isEmpty()) {
            throw new WFSException((EObject)request, "Stored query does not specify any queries");
        }
        String language = ((QueryExpressionTextType)sq.getQueryExpressionText().get(0)).getLanguage();
        for (int i = 1; i < sq.getQueryExpressionText().size(); ++i) {
            if (language.equals(((QueryExpressionTextType)sq.getQueryExpressionText().get(i)).getLanguage())) continue;
            throw new WFSException((EObject)request, "Stored query specifies queries with multiple languages. Not supported");
        }
        try {
            this.storedQueryProvider.createStoredQuery(sq, false).validate();
        }
        catch (WFSException e) {
            throw new WFSException((EObject)request, e.getMessage(), (Throwable)((Object)e), e.getCode());
        }
        catch (Exception e) {
            throw new WFSException((EObject)request, "Error validating stored query", (Throwable)e);
        }
    }
}

