/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.util.Enumeration;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.Predicates;
import org.geoserver.catalog.util.CloseableIterator;
import org.xml.sax.helpers.NamespaceSupport;

public class CatalogNamespaceSupport
extends NamespaceSupport {
    Catalog catalog;

    public CatalogNamespaceSupport(Catalog catalog) {
        this.catalog = catalog;
    }

    public Enumeration getDeclaredPrefixes() {
        return this.getPrefixes();
    }

    public Enumeration getPrefixes() {
        final CloseableIterator it = this.catalog.list(NamespaceInfo.class, Predicates.acceptAll());
        return new Enumeration(){

            @Override
            public boolean hasMoreElements() {
                if (it.hasNext()) {
                    return true;
                }
                it.close();
                return false;
            }

            public Object nextElement() {
                return ((NamespaceInfo)it.next()).getPrefix();
            }
        };
    }

    public Enumeration getPrefixes(String uri) {
        final String pre = this.getPrefix(uri);
        if (pre == null) {
            return new Enumeration(){

                @Override
                public boolean hasMoreElements() {
                    return false;
                }

                public Object nextElement() {
                    return null;
                }
            };
        }
        return new Enumeration(){
            boolean read = false;

            @Override
            public boolean hasMoreElements() {
                return !this.read;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object nextElement() {
                try {
                    String string = pre;
                    return string;
                }
                finally {
                    this.read = false;
                }
            }
        };
    }

    @Override
    public String getPrefix(String uri) {
        NamespaceInfo ns = "".equals(uri) ? this.catalog.getDefaultNamespace() : this.catalog.getNamespaceByURI(uri);
        return ns != null ? ns.getPrefix() : null;
    }

    @Override
    public String getURI(String prefix) {
        NamespaceInfo ns = "".equals(prefix) ? this.catalog.getDefaultNamespace() : this.catalog.getNamespaceByPrefix(prefix);
        return ns != null ? ns.getURI() : null;
    }

    @Override
    public void reset() {
        super.reset();
    }

    @Override
    public void pushContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void popContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean declarePrefix(String prefix, String uri) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] processName(String qName, String[] parts, boolean isAttribute) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setNamespaceDeclUris(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isNamespaceDeclUris() {
        throw new UnsupportedOperationException();
    }
}

