/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import net.opengis.wfs.XlinkPropertyNameType;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.wfs.request.Query;
import org.geotools.filter.visitor.DuplicatingFilterVisitor;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.PropertyDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterVisitor;
import org.opengis.filter.expression.PropertyName;
import org.opengis.filter.sort.SortBy;

class AliasedQuery
extends Query {
    private List<String> aliases;
    private Query delegate;
    private Filter filter;
    private List<String> propertyNames;

    static Query fixAliases(List<FeatureTypeInfo> metas, Query query) throws IOException {
        ArrayList<Object> aliases;
        HashSet<String> reservedWords = new HashSet<String>();
        for (FeatureTypeInfo meta : metas) {
            reservedWords.add(meta.getName());
            reservedWords.add(meta.prefixedName());
            FeatureType featureType = meta.getFeatureType();
            for (PropertyDescriptor pd : featureType.getDescriptors()) {
                reservedWords.add(pd.getName().getLocalPart());
                reservedWords.add(pd.getName().getURI());
            }
        }
        List<String> originalAliases = query.getAliases();
        boolean replaced = false;
        if (query.getAliases() != null && !query.getAliases().isEmpty()) {
            aliases = new ArrayList<String>(query.getAliases());
        } else {
            replaced = true;
            aliases = new ArrayList();
            for (int i = 0; i < metas.size(); ++i) {
                aliases.add(String.valueOf((char)(97 + i)));
            }
        }
        for (int i = 0; i < aliases.size(); ++i) {
            String alias;
            String base = alias = (String)aliases.get(i);
            int j = 0;
            while (reservedWords.contains(alias)) {
                replaced = true;
                alias = base + j++;
            }
            aliases.set(i, alias);
        }
        if (replaced) {
            return new AliasedQuery(query, originalAliases, aliases);
        }
        return query;
    }

    public AliasedQuery(Query query, List<String> originalAliases, List<String> aliases) {
        super(null);
        this.delegate = query;
        this.aliases = aliases;
        if (originalAliases != null && !originalAliases.isEmpty()) {
            Map<String, String> renameMap = this.buildRenameMap(originalAliases, aliases);
            this.filter = (Filter)query.getFilter().accept((FilterVisitor)new AliasRenameVisitor(renameMap), null);
            if (query.getPropertyNames() != null) {
                this.propertyNames = new ArrayList<String>();
                for (String name : query.getPropertyNames()) {
                    this.propertyNames.add(this.rename(renameMap, name));
                }
            }
        } else {
            this.filter = query.getFilter();
            this.propertyNames = query.getPropertyNames();
        }
    }

    private Map<String, String> buildRenameMap(List<String> originalAliases, List<String> newAliases) {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < originalAliases.size(); ++i) {
            String a2;
            String a1 = originalAliases.get(i);
            if (a1.equals(a2 = newAliases.get(i))) continue;
            map.put(a1, a2);
        }
        return map;
    }

    String rename(Map<String, String> renameMap, String name) {
        String prefix;
        String renamed;
        int idx = name.indexOf(47);
        if (idx > 0 && (renamed = renameMap.get(prefix = name.substring(0, idx))) != null) {
            name = renamed + name.substring(idx);
        }
        return name;
    }

    @Override
    public List<QName> getTypeNames() {
        return this.delegate.getTypeNames();
    }

    @Override
    public List<String> getAliases() {
        return this.aliases;
    }

    @Override
    public List<String> getPropertyNames() {
        return this.propertyNames;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public List<SortBy> getSortBy() {
        return this.delegate.getSortBy();
    }

    @Override
    public List<XlinkPropertyNameType> getXlinkPropertyNames() {
        return this.delegate.getXlinkPropertyNames();
    }

    class AliasRenameVisitor
    extends DuplicatingFilterVisitor {
        private Map<String, String> renameMap;

        public AliasRenameVisitor(Map<String, String> renameMap) {
            this.renameMap = renameMap;
        }

        public Object visit(PropertyName expression, Object extraData) {
            String name = expression.getPropertyName();
            String renamed = AliasedQuery.this.rename(this.renameMap, name);
            return this.ff.property(renamed);
        }
    }
}

