/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.web.publish;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.form.validation.FormComponentFeedbackBorder;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.NumberValidator;
import org.geoserver.web.publish.LayerConfigurationPanel;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.LiveCollectionModel;
import org.geoserver.web.wicket.SRSListTextArea;

public class WFSLayerConfig
extends LayerConfigurationPanel {
    protected GeoServerDialog dialog;

    public WFSLayerConfig(String id, IModel model) {
        super(id, model);
        TextField maxFeatures = new TextField("perReqFeatureLimit", (IModel)new PropertyModel((Object)model, "resource.maxFeatures"));
        maxFeatures.add((IValidator)NumberValidator.minimum((long)0L));
        FormComponentFeedbackBorder mfb = new FormComponentFeedbackBorder("perReqFeaturesBorder");
        mfb.add(new Component[]{maxFeatures});
        this.add(new Component[]{mfb});
        TextField maxDecimals = new TextField("maxDecimals", (IModel)new PropertyModel((Object)model, "resource.numDecimals"));
        maxFeatures.add((IValidator)NumberValidator.minimum((long)0L));
        FormComponentFeedbackBorder mdb = new FormComponentFeedbackBorder("maxDecimalsBorder");
        mdb.add(new Component[]{maxDecimals});
        this.add(new Component[]{mdb});
        CheckBox skipNumberMatched = new CheckBox("skipNumberMatched", (IModel)new PropertyModel((Object)model, "resource.skipNumberMatched"));
        this.add(new Component[]{skipNumberMatched});
        this.dialog = new GeoServerDialog("wfsDialog");
        this.add(new Component[]{this.dialog});
        PropertyModel overrideServiceSRSModel = new PropertyModel((Object)model, "resource.overridingServiceSRS");
        final CheckBox overrideServiceSRS = new CheckBox("overridingServiceSRS", (IModel)overrideServiceSRSModel);
        this.add(new Component[]{overrideServiceSRS});
        WebMarkupContainer otherSrsContainer = new WebMarkupContainer("otherSRSContainer");
        otherSrsContainer.setOutputMarkupId(true);
        this.add(new Component[]{otherSrsContainer});
        SRSListTextArea srsList = new SRSListTextArea("srs", (IModel)LiveCollectionModel.list((IModel)new PropertyModel((Object)model, "resource.responseSRS")));
        srsList.setOutputMarkupId(true);
        srsList.setVisible(Boolean.TRUE.equals(overrideServiceSRSModel.getObject()));
        otherSrsContainer.add(new Component[]{srsList});
        overrideServiceSRS.add(new IBehavior[]{new AjaxFormComponentUpdatingBehavior("onchange", (TextArea)srsList, otherSrsContainer){
            final /* synthetic */ TextArea val$srsList;
            final /* synthetic */ WebMarkupContainer val$otherSrsContainer;
            {
                this.val$srsList = textArea;
                this.val$otherSrsContainer = webMarkupContainer;
                super(x0);
            }

            protected void onUpdate(AjaxRequestTarget target) {
                Boolean visible = (Boolean)overrideServiceSRS.getConvertedInput();
                this.val$srsList.setVisible(visible.booleanValue());
                target.addComponent((Component)this.val$otherSrsContainer);
            }
        }});
        this.add(new Component[]{new AjaxLink("skipNumberMatchedHelp"){

            public void onClick(AjaxRequestTarget target) {
                WFSLayerConfig.this.dialog.showInfo(target, (IModel)new StringResourceModel("skipNumberMatched", (Component)WFSLayerConfig.this, null), new IModel[]{new StringResourceModel("skipNumberMatched.message", (Component)WFSLayerConfig.this, null)});
            }
        }});
        this.add(new Component[]{new AjaxLink("otherSRSHelp"){

            public void onClick(AjaxRequestTarget target) {
                WFSLayerConfig.this.dialog.showInfo(target, (IModel)new StringResourceModel("otherSRS", (Component)WFSLayerConfig.this, null), new IModel[]{new StringResourceModel("otherSRS.message", (Component)WFSLayerConfig.this, null)});
            }
        }});
    }
}

