/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.geoserver.security.ldap.LDAPRoleServiceConfig;
import org.geoserver.security.web.role.RoleServicePanel;

public class LDAPRoleServicePanel
extends RoleServicePanel<LDAPRoleServiceConfig> {
    public LDAPRoleServicePanel(String id, IModel<LDAPRoleServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("groupSearchBase").setRequired(true)});
        this.add(new Component[]{new TextField("groupSearchFilter")});
        this.add(new Component[]{new TextField("allGroupsSearchFilter")});
        this.add(new Component[]{new TextField("userFilter")});
        this.add(new Component[]{new AjaxCheckBox("bindBeforeGroupSearch"){

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)LDAPRoleServicePanel.this.get("authenticationPanelContainer");
                LDAPAuthenticationPanel ldapAuthenticationPanel = (LDAPAuthenticationPanel)c.get("authenticationPanel");
                ldapAuthenticationPanel.resetModel();
                ldapAuthenticationPanel.setVisible((Boolean)this.getModelObject());
                target.addComponent((Component)c);
            }
        }});
        LDAPAuthenticationPanel authPanel = new LDAPAuthenticationPanel("authenticationPanel");
        authPanel.setVisible(((LDAPRoleServiceConfig)model.getObject()).isBindBeforeGroupSearch());
        this.add(new Component[]{new WebMarkupContainer("authenticationPanelContainer").add(new Component[]{authPanel}).setOutputMarkupId(true)});
    }

    class LDAPAuthenticationPanel
    extends FormComponentPanel {
        public LDAPAuthenticationPanel(String id) {
            super(id, (IModel)new Model());
            this.add(new Component[]{new TextField("user")});
            PasswordTextField pwdField = new PasswordTextField("password");
            pwdField.setResetPassword(false);
            this.add(new Component[]{pwdField});
        }

        public void resetModel() {
            this.get("user").setDefaultModelObject(null);
            this.get("password").setDefaultModelObject(null);
        }
    }
}

