/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.web.security.ldap;

import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import javax.naming.AuthenticationException;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxCheckBox;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.PasswordTextField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.security.config.SecurityNamedServiceConfig;
import org.geoserver.security.ldap.LDAPAuthenticationProvider;
import org.geoserver.security.ldap.LDAPSecurityProvider;
import org.geoserver.security.ldap.LDAPSecurityServiceConfig;
import org.geoserver.security.web.auth.AuthenticationProviderPanel;
import org.geoserver.security.web.usergroup.UserGroupServiceChoice;
import org.geoserver.web.util.MapModel;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;

public class LDAPAuthProviderPanel
extends AuthenticationProviderPanel<LDAPSecurityServiceConfig> {
    public LDAPAuthProviderPanel(String id, IModel<LDAPSecurityServiceConfig> model) {
        super(id, model);
        this.add(new Component[]{new TextField("serverURL").setRequired(true)});
        this.add(new Component[]{new CheckBox("useTLS")});
        this.add(new Component[]{new TextField("userDnPattern")});
        this.add(new Component[]{new TextField("userFilter")});
        this.add(new Component[]{new TextField("userFormat")});
        boolean useLdapAuth = ((LDAPSecurityServiceConfig)model.getObject()).getUserGroupServiceName() == null;
        this.add(new Component[]{new AjaxCheckBox("useLdapAuthorization", (IModel)new Model((Serializable)Boolean.valueOf(useLdapAuth))){

            protected void onUpdate(AjaxRequestTarget target) {
                WebMarkupContainer c = (WebMarkupContainer)LDAPAuthProviderPanel.this.get("authorizationPanelContainer");
                ((AuthorizationPanel)c.get("authorizationPanel")).resetModel();
                c.remove("authorizationPanel");
                c.add(new Component[]{LDAPAuthProviderPanel.this.createAuthorizationPanel("authorizationPanel", (Boolean)this.getModelObject())});
                target.addComponent((Component)c);
            }
        }});
        this.add(new Component[]{new WebMarkupContainer("authorizationPanelContainer").add(new Component[]{this.createAuthorizationPanel("authorizationPanel", useLdapAuth)}).setOutputMarkupId(true)});
        this.add(new Component[]{new TestLDAPConnectionPanel("testCx")});
    }

    AuthorizationPanel createAuthorizationPanel(String id, boolean useLDAP) {
        return useLDAP ? new LDAPAuthorizationPanel(id) : new UserGroupAuthorizationPanel(id);
    }

    class TestLDAPConnectionPanel
    extends FormComponentPanel {
        public TestLDAPConnectionPanel(String id) {
            super(id, (IModel)new Model(new HashMap()));
            this.add(new Component[]{new TextField("username", (IModel)new MapModel(this.getModel(), "username"))});
            this.add(new Component[]{new PasswordTextField("password", (IModel)new MapModel(this.getModel(), "password")).setRequired(false)});
            this.add(new Component[]{new AjaxSubmitLink("test"){

                protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                    ((FormComponent)TestLDAPConnectionPanel.this.get("username")).processInput();
                    ((FormComponent)TestLDAPConnectionPanel.this.get("password")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("serverURL")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("useTLS")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("userDnPattern")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("userFilter")).processInput();
                    ((FormComponent)LDAPAuthProviderPanel.this.get("userFormat")).processInput();
                    String username = (String)((FormComponent)TestLDAPConnectionPanel.this.get("username")).getConvertedInput();
                    String password = (String)((FormComponent)TestLDAPConnectionPanel.this.get("password")).getConvertedInput();
                    LDAPSecurityServiceConfig ldapConfig = (LDAPSecurityServiceConfig)this.getForm().getModelObject();
                    this.doTest(ldapConfig, username, password);
                    target.addComponent(this.getPage().get("feedback"));
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                void doTest(LDAPSecurityServiceConfig ldapConfig, String username, String password) {
                    try {
                        if (ldapConfig.getUserDnPattern() == null && ldapConfig.getUserFilter() == null) {
                            this.error((Serializable)((Object)"Neither user dn pattern or user filter specified"));
                            return;
                        }
                        LDAPSecurityProvider provider = new LDAPSecurityProvider(LDAPAuthProviderPanel.this.getSecurityManager());
                        LDAPAuthenticationProvider authProvider = (LDAPAuthenticationProvider)provider.createAuthenticationProvider((SecurityNamedServiceConfig)ldapConfig);
                        Authentication authentication = authProvider.authenticate((Authentication)new UsernamePasswordAuthenticationToken((Object)username, (Object)password));
                        if (authentication == null || !authentication.isAuthenticated()) {
                            throw new AuthenticationException("Cannot authenticate " + username);
                        }
                        provider.destroy(null);
                        this.info((String)new StringResourceModel(LDAPAuthProviderPanel.class.getSimpleName() + ".connectionSuccessful", null).getObject());
                    }
                    catch (Exception e) {
                        this.error(e);
                        LOGGER.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }.setDefaultFormProcessing(false)});
        }
    }

    class LDAPAuthorizationPanel
    extends AuthorizationPanel {
        public LDAPAuthorizationPanel(String id) {
            super(id);
            this.add(new Component[]{new CheckBox("bindBeforeGroupSearch")});
            this.add(new Component[]{new TextField("adminGroup")});
            this.add(new Component[]{new TextField("groupAdminGroup")});
            this.add(new Component[]{new TextField("groupSearchBase")});
            this.add(new Component[]{new TextField("groupSearchFilter")});
        }

        @Override
        public void resetModel() {
            this.get("bindBeforeGroupSearch").setDefaultModelObject(null);
            this.get("adminGroup").setDefaultModelObject(null);
            this.get("groupAdminGroup").setDefaultModelObject(null);
            this.get("groupSearchBase").setDefaultModelObject(null);
            this.get("groupSearchFilter").setDefaultModelObject(null);
        }
    }

    class UserGroupAuthorizationPanel
    extends AuthorizationPanel {
        public UserGroupAuthorizationPanel(String id) {
            super(id);
            this.add(new Component[]{new UserGroupServiceChoice("userGroupServiceName")});
        }

        @Override
        public void resetModel() {
            this.get("userGroupServiceName").setDefaultModelObject(null);
        }
    }

    abstract class AuthorizationPanel
    extends FormComponentPanel {
        public AuthorizationPanel(String id) {
            super(id, (IModel)new Model());
        }

        public abstract void resetModel();
    }
}

