/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table.filter;

import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.DataTable;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.FilterForm;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilterStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.IFilteredColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.filter.NoFilter;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.repeater.RepeatingView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilterToolbar
extends AbstractToolbar {
    private static final long serialVersionUID = 1L;
    private static final String FILTER_COMPONENT_ID = "filter";

    public FilterToolbar(DataTable<?> table, FilterForm form, IFilterStateLocator stateLocator) {
        super(table);
        if (table == null) {
            throw new IllegalArgumentException("argument [table] cannot be null");
        }
        if (stateLocator == null) {
            throw new IllegalArgumentException("argument [stateLocator] cannot be null");
        }
        RepeatingView filters = new RepeatingView("filters");
        filters.setRenderBodyOnly(true);
        this.add(new Component[]{filters});
        IColumn<?>[] cols = table.getColumns();
        for (int i = 0; i < cols.length; ++i) {
            WebMarkupContainer item = new WebMarkupContainer(filters.newChildId());
            item.setRenderBodyOnly(true);
            IColumn<?> col = cols[i];
            NoFilter filter = null;
            if (col instanceof IFilteredColumn) {
                IFilteredColumn filteredCol = (IFilteredColumn)col;
                filter = filteredCol.getFilter(FILTER_COMPONENT_ID, form);
            }
            if (filter == null) {
                filter = new NoFilter(FILTER_COMPONENT_ID);
            } else if (!filter.getId().equals(FILTER_COMPONENT_ID)) {
                throw new IllegalStateException("filter component returned  with an invalid component id. invalid component id [" + filter.getId() + "] required component id [" + FILTER_COMPONENT_ID + "] generating column [" + col.toString() + "] ");
            }
            item.add(new Component[]{filter});
            filters.add(new Component[]{item});
        }
    }

    protected void onBeforeRender() {
        if (this.findParent(FilterForm.class) == null) {
            throw new IllegalStateException("FilterToolbar must be contained within a Form");
        }
        super.onBeforeRender();
    }
}

