/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.ajax.markup.html.form.upload;

import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.IInitializer;
import org.apache.wicket.RequestCycle;
import org.apache.wicket.Resource;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.MultipartRequest;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadStatusResource;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadWebRequest;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.CSSPackageResource;
import org.apache.wicket.markup.html.JavascriptPackageResource;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.Panel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UploadProgressBar
extends Panel {
    private static final Logger log = LoggerFactory.getLogger(UploadProgressBar.class);
    private static final ResourceReference JS = new ResourceReference(UploadProgressBar.class, "progressbar.js");
    private static final ResourceReference CSS = new ResourceReference(UploadProgressBar.class, "UploadProgressBar.css");
    private static final String RESOURCE_NAME = UploadProgressBar.class.getName();
    private static final long serialVersionUID = 1L;
    private final Form<?> form;

    public UploadProgressBar(String id, Form<?> form) {
        this(id, form, null);
    }

    public UploadProgressBar(String id, Form<?> form, FileUploadField fileUploadField) {
        super(id);
        this.form = form;
        this.setOutputMarkupId(true);
        form.setOutputMarkupId(true);
        this.setRenderBodyOnly(true);
        this.add(new IBehavior[]{JavascriptPackageResource.getHeaderContribution((ResourceReference)JS)});
        ResourceReference css = this.getCss();
        if (css != null) {
            this.add(new IBehavior[]{CSSPackageResource.getHeaderContribution((ResourceReference)css)});
        }
        WebMarkupContainer barDiv = new WebMarkupContainer("bar");
        barDiv.setOutputMarkupId(true);
        this.add(new Component[]{barDiv});
        WebMarkupContainer statusDiv = new WebMarkupContainer("status");
        statusDiv.setOutputMarkupId(true);
        this.add(new Component[]{statusDiv});
        if (!(RequestCycle.get().getRequest() instanceof UploadWebRequest) && !(RequestCycle.get().getRequest() instanceof MultipartRequest)) {
            log.warn("UploadProgressBar will not work without an UploadWebRequest. See the javadoc for details.");
        }
        form.add(new IBehavior[]{new FormEnabler(this, (Component)statusDiv, (Component)barDiv, (Component)fileUploadField)});
    }

    protected ResourceReference getCss() {
        return CSS;
    }

    protected void onRemove() {
        for (IBehavior behavior : this.form.getBehaviors()) {
            if (!(behavior instanceof FormEnabler) || ((FormEnabler)behavior).getUploadProgressBar() != this) continue;
            this.form.remove(behavior);
            break;
        }
        super.onRemove();
    }

    private static class FormEnabler
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;
        private final Component status;
        private final Component bar;
        private final Component uploadField;
        private final UploadProgressBar pbar;

        public FormEnabler(UploadProgressBar pbar, Component status, Component bar, Component uploadField) {
            this.pbar = pbar;
            this.bar = bar;
            this.status = status;
            this.uploadField = uploadField;
        }

        public void onComponentTag(Component component, ComponentTag tag) {
            ResourceReference ref = new ResourceReference(RESOURCE_NAME);
            String uploadFieldId = this.uploadField == null ? "" : this.uploadField.getMarkupId();
            tag.put("onsubmit", (CharSequence)("var def=new Wicket.WUPB.Def('" + component.getMarkupId() + "', '" + this.status.getMarkupId() + "', '" + this.bar.getMarkupId() + "', '" + component.getPage().urlFor(ref) + "','" + uploadFieldId + "'); Wicket.WUPB.start(def);"));
        }

        public UploadProgressBar getUploadProgressBar() {
            return this.pbar;
        }
    }

    public static final class ComponentInitializer
    implements IInitializer {
        public void init(Application application) {
            Application.get().getSharedResources().add(RESOURCE_NAME, (Resource)new UploadStatusResource());
        }

        public String toString() {
            return "Ajax UploadProgressBar initializer";
        }
    }
}

