/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;
import org.geoserver.gwc.web.layer.CaseNormalizerSubform;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.StringParameterFilter;

public class StringParameterFilterSubform
extends AbstractParameterFilterSubform<StringParameterFilter> {
    private static final long serialVersionUID = 1L;
    private static final IConverter CONVERT = new IConverter(){
        private static final long serialVersionUID = 1L;

        public Object convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            String[] strings = StringUtils.split((String)value, (String)"\r\n");
            return Arrays.asList(strings);
        }

        public String convertToString(Object value, Locale locale) {
            List floats = (List)value;
            Iterator i = floats.iterator();
            StringBuilder sb = new StringBuilder();
            if (i.hasNext()) {
                sb.append((String)i.next());
            }
            while (i.hasNext()) {
                sb.append("\r\n");
                sb.append((String)i.next());
            }
            return sb.toString();
        }
    };
    private Component normalize;

    public StringParameterFilterSubform(String id, IModel<StringParameterFilter> model) {
        super(id, model);
        TextField defaultValue = new TextField("defaultValue", (IModel)new PropertyModel(model, "defaultValue"));
        this.add(new Component[]{defaultValue});
        TextArea<List<String>> values = new TextArea<List<String>>("values", (IModel)new PropertyModel(model, "values")){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class<?> type) {
                return CONVERT;
            }
        };
        this.add(new Component[]{values});
        this.normalize = new CaseNormalizerSubform("normalize", (IModel<CaseNormalizer>)new PropertyModel(model, "normalize"));
        this.add(new Component[]{this.normalize});
    }
}

