/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;
import org.geoserver.gwc.web.layer.CaseNormalizerSubform;
import org.geowebcache.filter.parameters.CaseNormalizer;
import org.geowebcache.filter.parameters.RegexParameterFilter;

public class RegexParameterFilterSubform
extends AbstractParameterFilterSubform<RegexParameterFilter> {
    private static final IValidator<String> REGEXP_VALIDATOR = new IValidator<String>(){
        private static final long serialVersionUID = 1L;

        public void validate(IValidatable<String> validatable) {
            String regex = (String)validatable.getValue();
            try {
                Pattern.compile(regex);
            }
            catch (PatternSyntaxException ex) {
                ValidationError error = new ValidationError();
                error.setMessage("Invalid Regular expression");
                error.addMessageKey(this.getClass().getSimpleName() + "." + "invalidRegularExpression");
                validatable.error((IValidationError)error);
            }
        }
    };
    private static final long serialVersionUID = 1L;
    private Component normalize;

    public RegexParameterFilterSubform(String id, IModel<RegexParameterFilter> model) {
        super(id, model);
        TextField defaultValue = new TextField("defaultValue", (IModel)new PropertyModel(model, "defaultValue"));
        this.add(new Component[]{defaultValue});
        TextField regex = new TextField("regex", (IModel)new PropertyModel(model, "regex"));
        regex.add(REGEXP_VALIDATOR);
        this.add(new Component[]{regex});
        this.normalize = new CaseNormalizerSubform("normalize", (IModel<CaseNormalizer>)new PropertyModel(model, "normalize"));
        this.add(new Component[]{this.normalize});
    }
}

