/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxSubmitLink;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidationError;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.ValidationError;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.StyleParameterFilter;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.layer.DefaultParameterFilterSubform;
import org.geoserver.gwc.web.layer.FloatParameterFilterSubform;
import org.geoserver.gwc.web.layer.IntegerParameterFilterSubform;
import org.geoserver.gwc.web.layer.RegexParameterFilterSubform;
import org.geoserver.gwc.web.layer.StringParameterFilterSubform;
import org.geoserver.gwc.web.layer.StyleParameterFilterSubform;
import org.geoserver.web.wicket.GeoServerAjaxFormLink;
import org.geoserver.web.wicket.Icon;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;
import org.geowebcache.filter.parameters.FloatParameterFilter;
import org.geowebcache.filter.parameters.IntegerParameterFilter;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.filter.parameters.RegexParameterFilter;
import org.geowebcache.filter.parameters.StringParameterFilter;

class ParameterFilterEditor
extends FormComponentPanel<Set<ParameterFilter>> {
    private static final Logger LOGGER = Logging.getLogger(ParameterFilterEditor.class);
    private static final long serialVersionUID = 5098470663723800345L;
    private static final List<String> COMMON_KEYS = Arrays.asList("ENV", "FORMAT_OPTIONS", "ANGLE", "BGCOLOR", "BUFFER", "CQL_FILTER", "ELEVATION", "FEATUREID", "FILTER", "PALETTE", "STARTINDEX", "MAXFEATURES", "TIME", "VIEWPARAMS", "FEATUREVERSION");
    private final WebMarkupContainer table;
    private final ListView<ParameterFilter> filters;
    private final ParameterListValidator validator = new ParameterListValidator();
    private final DropDownChoice<Class<? extends ParameterFilter>> availableFilterTypes;
    private final TextField<String> newFilterKey;

    public ParameterFilterEditor(String id, IModel<Set<ParameterFilter>> model, final IModel<? extends CatalogInfo> layerModel) {
        super(id, model);
        this.add(this.validator);
        final WebMarkupContainer container = new WebMarkupContainer("container");
        container.setOutputMarkupId(true);
        this.add(new Component[]{container});
        this.table = new WebMarkupContainer("table");
        this.table.setOutputMarkupId(true);
        container.add(new Component[]{this.table});
        this.filters = new ListView<ParameterFilter>("parameterFilters", new ArrayList((Collection)model.getObject())){
            private static final long serialVersionUID = 1L;

            protected void onBeforeRender() {
                super.onBeforeRender();
            }

            protected void populateItem(ListItem<ParameterFilter> item) {
                int index = item.getIndex();
                item.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)(index % 2 == 0 ? "even" : "odd"))});
                Label keyLabel = new Label("key", (IModel)new PropertyModel((Object)item.getModel(), "key"));
                item.add(new Component[]{keyLabel});
                Component subForm = ParameterFilterEditor.this.getSubform("subform", (IModel<? extends ParameterFilter>)item.getModel());
                item.add(new Component[]{subForm});
                AjaxSubmitLink removeLink = new AjaxSubmitLink("removeLink"){
                    private static final long serialVersionUID = 1L;

                    protected void onSubmit(AjaxRequestTarget target, Form form) {
                        this.getList().remove((ParameterFilter)this.getDefaultModelObject());
                        target.addComponent((Component)container);
                    }
                };
                removeLink.add(new Component[]{new Icon("removeIcon", GWCIconFactory.DELETE_ICON)});
                removeLink.setDefaultModel(item.getModel());
                removeLink.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("ParameterFilterEditor.removeLink"))});
                item.add(new Component[]{removeLink});
            }
        };
        this.filters.setOutputMarkupId(true);
        this.filters.setReuseItems(true);
        Form filtersForm = new Form("filtersForm", this.filters.getDefaultModel());
        filtersForm.add(new Component[]{this.filters});
        this.table.add(new Component[]{filtersForm});
        ArrayList parameterKeys = new ArrayList(GWC.get().getGridSetBroker().getNames());
        for (ParameterFilter filter : (Set)model.getObject()) {
            parameterKeys.remove(filter.getKey());
        }
        Collections.sort(parameterKeys);
        GeoServerAjaxFormLink addStyleFilterLink = new GeoServerAjaxFormLink("addStyleFilter"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form form) {
                StyleParameterFilter newFilter = new StyleParameterFilter();
                newFilter.setLayer((LayerInfo)layerModel.getObject());
                ParameterFilterEditor.this.addFilter((ParameterFilter)newFilter);
                target.addComponent((Component)container);
            }
        };
        addStyleFilterLink.add(new Component[]{new Icon("addIcon", GWCIconFactory.ADD_ICON)});
        this.add(new Component[]{addStyleFilterLink});
        ArrayList<Class> filterTypes = new ArrayList<Class>();
        filterTypes.add(StringParameterFilter.class);
        filterTypes.add(FloatParameterFilter.class);
        filterTypes.add(IntegerParameterFilter.class);
        filterTypes.add(RegexParameterFilter.class);
        this.availableFilterTypes = new DropDownChoice("availableFilterTypes", (IModel)new Model(), (IModel)new Model(filterTypes), (IChoiceRenderer)new IChoiceRenderer<Class<? extends ParameterFilter>>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(Class<? extends ParameterFilter> object) {
                String resource = "ParameterFilterEditor.filtername." + object.getCanonicalName();
                try {
                    return ParameterFilterEditor.this.getLocalizer().getString(resource, (Component)ParameterFilterEditor.this);
                }
                catch (MissingResourceException ex) {
                    if (LOGGER.isLoggable(Level.CONFIG)) {
                        LOGGER.log(Level.CONFIG, "Could not find localization resource for ParameterFilter subclass " + object.getCanonicalName());
                    }
                    return object.getSimpleName();
                }
            }

            public String getIdValue(Class<? extends ParameterFilter> object, int index) {
                return Integer.toString(index);
            }
        });
        this.availableFilterTypes.setOutputMarkupId(true);
        this.add(new Component[]{this.availableFilterTypes});
        this.newFilterKey = new TextField("newFilterKey", (IModel)Model.of((Serializable)((Object)"")));
        this.add(new Component[]{this.newFilterKey});
        RepeatingView commonKeys = new RepeatingView("commonKeys");
        for (String key : COMMON_KEYS) {
            commonKeys.add(new Component[]{new Label(commonKeys.newChildId(), key)});
        }
        this.add(new Component[]{commonKeys});
        GeoServerAjaxFormLink addFilterLink = new GeoServerAjaxFormLink("addFilter"){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target, Form form) {
                ParameterFilterEditor.this.availableFilterTypes.processInput();
                ParameterFilterEditor.this.newFilterKey.processInput();
                String key = (String)ParameterFilterEditor.this.newFilterKey.getModelObject();
                if (key == null || key.isEmpty()) {
                    ParamResourceModel rm = new ParamResourceModel("ParameterFilterEditor.nonEmptyFilter", null, new Object[]{""});
                    this.error((Serializable)((Object)rm.getString()));
                } else {
                    Class type = (Class)ParameterFilterEditor.this.availableFilterTypes.getModelObject();
                    try {
                        ParameterFilter newFilter = (ParameterFilter)type.getConstructor(new Class[0]).newInstance(new Object[0]);
                        newFilter.setKey(key);
                        ParameterFilterEditor.this.addFilter(newFilter);
                        ParameterFilterEditor.this.newFilterKey.setModel((IModel)Model.of((Serializable)((Object)"")));
                    }
                    catch (NoSuchMethodException ex) {
                        LOGGER.log(Level.WARNING, "No Default Constructor for " + type, ex);
                    }
                    catch (IllegalAccessException | InstantiationException | SecurityException | InvocationTargetException ex) {
                        LOGGER.log(Level.WARNING, "Could not execute default Constructor for " + type, ex);
                    }
                }
                target.addComponent((Component)container);
            }
        };
        addFilterLink.add(new Component[]{new Icon("addIcon", GWCIconFactory.ADD_ICON)});
        this.add(new Component[]{addFilterLink});
    }

    private Component getSubform(String id, IModel<? extends ParameterFilter> model) {
        if (model.getObject() instanceof RegexParameterFilter) {
            return new RegexParameterFilterSubform(id, (IModel<RegexParameterFilter>)model);
        }
        if (model.getObject() instanceof StyleParameterFilter) {
            return new StyleParameterFilterSubform(id, (IModel<StyleParameterFilter>)model);
        }
        if (model.getObject() instanceof StringParameterFilter) {
            return new StringParameterFilterSubform(id, (IModel<StringParameterFilter>)model);
        }
        if (model.getObject() instanceof FloatParameterFilter) {
            return new FloatParameterFilterSubform(id, (IModel<FloatParameterFilter>)model);
        }
        if (model.getObject() instanceof IntegerParameterFilter) {
            return new IntegerParameterFilterSubform(id, (IModel<IntegerParameterFilter>)model);
        }
        return new DefaultParameterFilterSubform(id, (IModel<ParameterFilter>)model);
    }

    protected void convertInput() {
        this.filters.visitChildren((Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                if (component instanceof FormComponent) {
                    FormComponent formComponent = (FormComponent)component;
                    formComponent.processInput();
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
        List info = this.filters.getModelObject();
        HashSet convertedInput = new HashSet(info);
        this.setConvertedInput(convertedInput);
    }

    private boolean hasFilter(String key) {
        for (ParameterFilter existing : this.filters.getModelObject()) {
            if (!existing.getKey().equalsIgnoreCase(key)) continue;
            return true;
        }
        return false;
    }

    private boolean addFilter(ParameterFilter filter) {
        if (this.hasFilter(filter.getKey())) {
            return false;
        }
        this.filters.getModelObject().add(filter);
        return true;
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }

    public void setValidating(boolean validate) {
        this.validator.setEnabled(validate);
    }

    private class ParameterListValidator
    implements IValidator<Set<ParameterFilter>> {
        private static final long serialVersionUID = 1L;
        private boolean validate;

        public ParameterListValidator() {
            this.setEnabled(true);
        }

        public void validate(IValidatable<Set<ParameterFilter>> validatable) {
            if (!this.validate) {
                return;
            }
            Set paramFilters = (Set)validatable.getValue();
            if (paramFilters == null) {
                return;
            }
            TreeSet<String> keys = new TreeSet<String>();
            for (ParameterFilter filter : paramFilters) {
                String key = filter.getKey();
                if (key == null) {
                    throw new IllegalStateException("ParameterFilter key is null");
                }
                if (keys.contains(key)) {
                    this.error(validatable, "ParameterFilterEditor.validation.duplicateKey", new String[0]);
                    return;
                }
                keys.add(key);
            }
        }

        private void error(IValidatable<Set<ParameterFilter>> validatable, String resourceKey, String ... params) {
            ValidationError error = new ValidationError();
            String message = params == null ? new ResourceModel(resourceKey).getObject() : (String)new ParamResourceModel(resourceKey, (Component)ParameterFilterEditor.this, (Object[])params).getObject();
            error.setMessage(message);
            validatable.error((IValidationError)error);
        }

        public void setEnabled(boolean validate) {
            this.validate = validate;
        }
    }
}

