/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import org.apache.wicket.Component;
import org.apache.wicket.model.IModel;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.config.GWCConfig;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.layer.TileLayerInfoUtil;
import org.geoserver.gwc.web.layer.GeoServerTileLayerEditor;
import org.geoserver.gwc.web.layer.GeoServerTileLayerInfoModel;
import org.geoserver.web.publish.LayerGroupConfigurationPanel;

public class LayerGroupCacheOptionsPanel
extends LayerGroupConfigurationPanel {
    private static final long serialVersionUID = -8651034825347320139L;
    private GeoServerTileLayerEditor editor;

    public LayerGroupCacheOptionsPanel(String id, IModel<LayerGroupInfo> layerGroupModel) {
        super(id, layerGroupModel);
        boolean initWithTileLayer;
        GeoServerTileLayerInfo tileLayerInfo;
        GeoServerTileLayer tileLayer;
        LayerGroupInfo layerGroupInfo = this.getLayerGroupInfo();
        boolean isNew = layerGroupInfo.getId() == null;
        GWC mediator = GWC.get();
        GWCConfig defaultSettings = mediator.getConfig();
        GeoServerTileLayer geoServerTileLayer = tileLayer = isNew ? null : mediator.getTileLayer((CatalogInfo)layerGroupInfo);
        if (isNew || tileLayer == null) {
            GWCConfig saneDefaults = defaultSettings.saneConfig();
            tileLayerInfo = TileLayerInfoUtil.loadOrCreate((LayerGroupInfo)layerGroupInfo, (GWCConfig)saneDefaults);
        } else {
            tileLayerInfo = tileLayer.getInfo().clone();
        }
        tileLayerInfo.setEnabled(true);
        boolean bl = initWithTileLayer = isNew && defaultSettings.isCacheLayersByDefault() || tileLayer != null;
        if (!initWithTileLayer) {
            tileLayerInfo.setId(null);
        }
        GeoServerTileLayerInfoModel tileLayerModel = new GeoServerTileLayerInfoModel(tileLayerInfo, isNew);
        this.editor = new GeoServerTileLayerEditor("tileLayerEditor", layerGroupModel, (IModel<GeoServerTileLayerInfo>)tileLayerModel);
        this.add(new Component[]{this.editor});
    }

    public void save() {
        this.editor.save();
    }
}

