/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang.StringUtils;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.TextArea;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.convert.ConversionException;
import org.apache.wicket.util.convert.IConverter;
import org.geoserver.gwc.web.layer.AbstractParameterFilterSubform;
import org.geowebcache.filter.parameters.IntegerParameterFilter;

public class IntegerParameterFilterSubform
extends AbstractParameterFilterSubform<IntegerParameterFilter> {
    private static final long serialVersionUID = 1L;
    private static final IConverter INTEGER = new IConverter(){
        private static final long serialVersionUID = 1L;

        public Integer convertToObject(String value, Locale locale) {
            if (value == null || value.isEmpty()) {
                return null;
            }
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException ex) {
                throw new ConversionException((Throwable)ex).setConverter((IConverter)this).setLocale(locale).setTargetType(Integer.class).setSourceValue((Object)value).setResourceKey("notAValidNumber");
            }
        }

        public String convertToString(Object value, Locale locale) {
            return Integer.toString((Integer)value);
        }
    };
    private static final IConverter CONVERT = new IConverter(){
        private static final long serialVersionUID = 1L;

        public Object convertToObject(String value, Locale locale) {
            if (value == null) {
                return null;
            }
            String[] strings = StringUtils.split((String)value, (String)"\r\n");
            ArrayList<Integer> floats = new ArrayList<Integer>(strings.length);
            for (String s : strings) {
                floats.add((Integer)INTEGER.convertToObject(s, locale));
            }
            return floats;
        }

        public String convertToString(Object value, Locale locale) {
            List floats = (List)value;
            Iterator i = floats.iterator();
            StringBuilder sb = new StringBuilder();
            if (i.hasNext()) {
                sb.append(INTEGER.convertToString(i.next(), locale));
            }
            while (i.hasNext()) {
                sb.append("\r\n");
                sb.append(INTEGER.convertToString(i.next(), locale));
            }
            return sb.toString();
        }
    };

    public IntegerParameterFilterSubform(String id, IModel<IntegerParameterFilter> model) {
        super(id, model);
        TextField defaultValue = new TextField("defaultValue", (IModel)new PropertyModel(model, "defaultValue"));
        this.add(new Component[]{defaultValue});
        TextArea<List<Integer>> values = new TextArea<List<Integer>>("values", (IModel)new PropertyModel(model, "values")){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class<?> type) {
                return CONVERT;
            }
        };
        this.add(new Component[]{values});
        TextField<Integer> threshold = new TextField<Integer>("threshold", (IModel)new PropertyModel(model, "threshold")){
            private static final long serialVersionUID = 1L;

            public IConverter getConverter(Class<?> type) {
                return INTEGER;
            }
        };
        this.add(new Component[]{threshold});
    }
}

