/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.OnChangeAjaxBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Check;
import org.apache.wicket.markup.html.form.CheckBox;
import org.apache.wicket.markup.html.form.CheckGroup;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.validation.IValidatable;
import org.apache.wicket.validation.IValidator;
import org.geoserver.catalog.CatalogInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.PublishedInfo;
import org.geoserver.catalog.PublishedType;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.impl.ModificationProxy;
import org.geoserver.gwc.ConfigurableBlobStore;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.layer.GeoServerTileLayerInfo;
import org.geoserver.gwc.web.layer.GeoServerTileLayerInfoModel;
import org.geoserver.gwc.web.layer.GridSubsetsEditor;
import org.geoserver.gwc.web.layer.ParameterFilterEditor;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geotools.util.logging.Logging;
import org.geowebcache.config.BlobStoreConfig;
import org.geowebcache.config.XMLGridSubset;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.filter.parameters.ParameterFilter;
import org.geowebcache.grid.GridSetBroker;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.storage.blobstore.memory.CacheProvider;

class GeoServerTileLayerEditor
extends FormComponentPanel<GeoServerTileLayerInfo> {
    private static final long serialVersionUID = 7870938096047218989L;
    private static final Logger LOGGER = Logging.getLogger(GeoServerTileLayerEditor.class);
    private final boolean cachedLayerExistedInitially;
    private final GeoServerDialog confirmRemovalDialog;
    private final FormComponent<Boolean> createLayer;
    private final FormComponent<Boolean> enabled;
    private final DropDownChoice<String> blobStoreId;
    private final WebMarkupContainer container;
    private final WebMarkupContainer configs;
    private final FormComponent<Integer> metaTilingX;
    private final FormComponent<Integer> metaTilingY;
    private final FormComponent<Integer> gutter;
    private final CheckGroup<String> cacheFormats;
    private final FormComponent<Integer> expireCache;
    private final FormComponent<Integer> expireClients;
    private final GridSubsetsEditor gridSubsets;
    private final ParameterFilterEditor parameterFilters;
    private final String originalLayerName;
    private IModel<? extends CatalogInfo> layerModel;
    private CheckBox enableInMemoryCaching;

    public GeoServerTileLayerEditor(String id, IModel<? extends PublishedInfo> layerModel, IModel<GeoServerTileLayerInfo> tileLayerModel) {
        super(id);
        boolean undefined;
        ResourceModel createTileLayerLabelModel;
        Preconditions.checkArgument((boolean)(tileLayerModel instanceof GeoServerTileLayerInfoModel));
        this.layerModel = layerModel;
        this.setModel(tileLayerModel);
        GWC mediator = GWC.get();
        PublishedInfo info = (PublishedInfo)layerModel.getObject();
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)tileLayerModel.getObject();
        if (info instanceof LayerInfo) {
            createTileLayerLabelModel = new ResourceModel("createTileLayerForLayer");
            ResourceInfo resource = ((LayerInfo)info).getResource();
            resource = (ResourceInfo)ModificationProxy.unwrap((Object)resource);
            this.originalLayerName = resource.getPrefixedName();
        } else if (info instanceof LayerGroupInfo) {
            createTileLayerLabelModel = new ResourceModel("createTileLayerForLayerGroup");
            LayerGroupInfo lgi = (LayerGroupInfo)ModificationProxy.unwrap((Object)((LayerGroupInfo)info));
            this.originalLayerName = GWC.tileLayerName((LayerGroupInfo)lgi);
        } else {
            throw new IllegalArgumentException("Provided model does not target a LayerInfo nor a LayerGroupInfo: " + info);
        }
        TileLayer tileLayer = null;
        if (this.originalLayerName != null) {
            try {
                tileLayer = mediator.getTileLayerByName(this.originalLayerName);
            }
            catch (IllegalArgumentException notFound) {
                // empty catch block
            }
        }
        this.cachedLayerExistedInitially = tileLayer != null;
        Component[] componentArray = new Component[1];
        this.confirmRemovalDialog = new GeoServerDialog("confirmRemovalDialog");
        componentArray[0] = this.confirmRemovalDialog;
        this.add(componentArray);
        this.confirmRemovalDialog.setInitialWidth(360);
        this.confirmRemovalDialog.setInitialHeight(180);
        this.add(new Component[]{new Label("createTileLayerLabel", (IModel)createTileLayerLabelModel)});
        GeoServerTileLayerInfoModel model = (GeoServerTileLayerInfoModel)tileLayerModel;
        boolean bl = undefined = model.getEnabled() == null;
        boolean doCreateTileLayer = tileLayerInfo.getId() != null ? true : this.isNew() && mediator.getConfig().isCacheLayersByDefault();
        if (undefined) {
            model.setEnabled(doCreateTileLayer);
        }
        Component[] componentArray2 = new Component[1];
        this.createLayer = new CheckBox("createTileLayer", (IModel)new Model((Serializable)Boolean.valueOf(doCreateTileLayer)));
        componentArray2[0] = this.createLayer;
        this.add(componentArray2);
        this.createLayer.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("createTileLayer.title"))});
        this.container = new WebMarkupContainer("container");
        this.container.setOutputMarkupId(true);
        this.add(new Component[]{this.container});
        this.configs = new WebMarkupContainer("configs");
        this.configs.setOutputMarkupId(true);
        this.container.add(new Component[]{this.configs});
        Component[] componentArray3 = new Component[1];
        this.enabled = new CheckBox("enabled", (IModel)new PropertyModel((Object)this.getModel(), "enabled"));
        componentArray3[0] = this.enabled;
        this.add(componentArray3);
        this.enabled.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("enabled.title"))});
        this.configs.add(new Component[]{this.enabled});
        IChoiceRenderer<String> blobStoreRenderer = new IChoiceRenderer<String>(){
            private static final long serialVersionUID = 1L;
            final String defaultStore;
            {
                this.defaultStore = GeoServerTileLayerEditor.this.getDefaultBlobStoreId();
            }

            public String getIdValue(String object, int index) {
                return object;
            }

            public Object getDisplayValue(String object) {
                String value = object;
                if (object.equals(this.defaultStore)) {
                    value = value + " (*)";
                }
                return value;
            }
        };
        PropertyModel blobStoreModel = new PropertyModel((Object)this.getModel(), "blobStoreId");
        List<String> blobStoreChoices = this.getBlobStoreIds();
        Component[] componentArray4 = new Component[1];
        this.blobStoreId = new DropDownChoice("blobStoreId", (IModel)blobStoreModel, blobStoreChoices, (IChoiceRenderer)blobStoreRenderer);
        componentArray4[0] = this.blobStoreId;
        this.configs.add(componentArray4);
        this.blobStoreId.setNullValid(true);
        this.blobStoreId.add(new IBehavior[]{new AttributeModifier("title", true, (IModel)new ResourceModel("blobStoreId.title"))});
        this.add((IValidator)new IValidator<GeoServerTileLayerInfo>(){
            private static final long serialVersionUID = 5240602030478856537L;

            public void validate(IValidatable<GeoServerTileLayerInfo> validatable) {
                Boolean createVal = (Boolean)GeoServerTileLayerEditor.this.createLayer.getConvertedInput();
                Boolean enabledVal = (Boolean)GeoServerTileLayerEditor.this.enabled.getConvertedInput();
                String blobStoreIdVal = (String)GeoServerTileLayerEditor.this.blobStoreId.getConvertedInput();
                if (createVal.booleanValue() && enabledVal.booleanValue() && !GeoServerTileLayerEditor.this.isBlobStoreEnabled(blobStoreIdVal)) {
                    GeoServerTileLayerEditor.this.error((Serializable)((Object)new ParamResourceModel("enabledError", (Component)GeoServerTileLayerEditor.this, new Object[0]).getString()));
                }
            }
        });
        this.enableInMemoryCaching = new CheckBox("inMemoryCached", (IModel)new PropertyModel((Object)this.getModel(), "inMemoryCached"));
        ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
        if (store != null && store.getCache() != null) {
            this.enableInMemoryCaching.setEnabled(mediator.getConfig().isInnerCachingEnabled() && !store.getCache().isImmutable());
        }
        this.configs.add(new Component[]{this.enableInMemoryCaching});
        List<Integer> metaTilingChoices = Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20);
        PropertyModel metaTilingXModel = new PropertyModel((Object)this.getModel(), "metaTilingX");
        this.metaTilingX = new DropDownChoice("metaTilingX", (IModel)metaTilingXModel, metaTilingChoices);
        this.configs.add(new Component[]{this.metaTilingX});
        PropertyModel metaTilingYModel = new PropertyModel((Object)this.getModel(), "metaTilingY");
        this.metaTilingY = new DropDownChoice("metaTilingY", (IModel)metaTilingYModel, metaTilingChoices);
        this.configs.add(new Component[]{this.metaTilingY});
        PropertyModel gutterModel = new PropertyModel((Object)this.getModel(), "gutter");
        List<Integer> gutterChoices = Arrays.asList(0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 15, 20, 50, 100);
        this.gutter = new DropDownChoice("gutter", (IModel)gutterModel, gutterChoices);
        this.configs.add(new Component[]{this.gutter});
        PropertyModel mimeFormatsModel = new PropertyModel((Object)this.getModel(), "mimeFormats");
        this.cacheFormats = new CheckGroup("cacheFormatsGroup", (IModel)mimeFormatsModel);
        this.cacheFormats.setLabel((IModel)new ResourceModel("cacheFormats"));
        this.configs.add(new Component[]{this.cacheFormats});
        GWC.get();
        ArrayList formats = Lists.newArrayList((Iterable)GWC.getAdvertisedCachedFormats((PublishedType)info.getType()));
        ListView<String> cacheFormatsList = new ListView<String>("cacheFormats", (List)formats){
            private static final long serialVersionUID = 1L;

            protected void populateItem(ListItem<String> item) {
                item.add(new Component[]{new Check("cacheFormatsOption", item.getModel())});
                item.add(new Component[]{new Label("name", item.getModel())});
            }
        };
        cacheFormatsList.setReuseItems(true);
        this.cacheFormats.add(new Component[]{cacheFormatsList});
        PropertyModel expireCacheModel = new PropertyModel((Object)this.getModel(), "expireCache");
        this.expireCache = new TextField("expireCache", (IModel)expireCacheModel);
        this.configs.add(new Component[]{this.expireCache});
        PropertyModel expireClientsModel = new PropertyModel((Object)this.getModel(), "expireClients");
        this.expireClients = new TextField("expireClients", (IModel)expireClientsModel);
        this.configs.add(new Component[]{this.expireClients});
        PropertyModel gridSubsetsModel = new PropertyModel((Object)this.getModel(), "gridSubsets");
        this.gridSubsets = new GridSubsetsEditor("cachedGridsets", (IModel<Set<XMLGridSubset>>)gridSubsetsModel);
        this.configs.add(new Component[]{this.gridSubsets});
        PropertyModel parameterFilterModel = new PropertyModel((Object)this.getModel(), "parameterFilters");
        this.parameterFilters = new ParameterFilterEditor("parameterFilters", (IModel<Set<ParameterFilter>>)parameterFilterModel, layerModel);
        this.configs.add(new Component[]{this.parameterFilters});
        this.configs.setVisible(((Boolean)this.createLayer.getModelObject()).booleanValue());
        this.setValidating((Boolean)this.createLayer.getModelObject());
        this.createLayer.add(new IBehavior[]{new OnChangeAjaxBehavior(){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                boolean createTileLayer = (Boolean)GeoServerTileLayerEditor.this.createLayer.getModelObject();
                if (!createTileLayer && GeoServerTileLayerEditor.this.cachedLayerExistedInitially) {
                    GeoServerTileLayerEditor.this.confirmRemovalOfExistingTileLayer(target);
                } else {
                    GeoServerTileLayerEditor.this.updateConfigsVisibility(target);
                }
            }
        }});
    }

    private List<String> getBlobStoreIds() {
        ArrayList<String> blobStoreIds = new ArrayList<String>();
        for (BlobStoreConfig blobStore : GWC.get().getBlobStores()) {
            blobStoreIds.add(blobStore.getId());
        }
        return blobStoreIds;
    }

    private boolean isBlobStoreEnabled(String blobStoreId) {
        if (blobStoreId == null) {
            return true;
        }
        for (BlobStoreConfig blobStore : GWC.get().getBlobStores()) {
            if (!blobStore.getId().equals(blobStoreId)) continue;
            return blobStore.isEnabled();
        }
        return false;
    }

    private boolean isNew() {
        GeoServerTileLayerInfoModel model = (GeoServerTileLayerInfoModel)super.getModel();
        return model.isNew();
    }

    private String getDefaultBlobStoreId() {
        BlobStoreConfig defaultBlobStore = GWC.get().getDefaultBlobStore();
        return defaultBlobStore == null ? null : defaultBlobStore.getId();
    }

    public void save() {
        GeoServerTileLayer tileLayer;
        String name;
        CacheProvider cache;
        boolean createLayer;
        GWC gwc = GWC.get();
        CatalogInfo layer = (CatalogInfo)this.layerModel.getObject();
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)this.getModelObject();
        boolean tileLayerExists = gwc.hasTileLayer(layer);
        GeoServerTileLayerInfoModel model = (GeoServerTileLayerInfoModel)this.getModel();
        boolean bl = createLayer = model.getEnabled() == null ? GWC.get().getConfig().isCacheLayersByDefault() : model.getEnabled().booleanValue();
        if (!createLayer) {
            if (tileLayerExists) {
                String tileLayerName = tileLayerInfo.getName();
                gwc.removeTileLayers(Arrays.asList(tileLayerName));
            }
            return;
        }
        Preconditions.checkState((layer.getId() != null ? 1 : 0) != 0);
        tileLayerInfo.setId(layer.getId());
        ConfigurableBlobStore store = (ConfigurableBlobStore)GeoServerExtensions.bean(ConfigurableBlobStore.class);
        if (store != null && (cache = store.getCache()) != null) {
            if (((Boolean)this.enableInMemoryCaching.getModelObject()).booleanValue()) {
                cache.removeUncachedLayer(((GeoServerTileLayerInfo)this.getModel().getObject()).getName());
            } else {
                cache.addUncachedLayer(((GeoServerTileLayerInfo)this.getModel().getObject()).getName());
            }
        }
        GridSetBroker gridsets = gwc.getGridSetBroker();
        if (layer instanceof LayerGroupInfo) {
            LayerGroupInfo groupInfo = (LayerGroupInfo)layer;
            name = GWC.tileLayerName((LayerGroupInfo)groupInfo);
            tileLayer = new GeoServerTileLayer((PublishedInfo)groupInfo, gridsets, tileLayerInfo);
        } else {
            LayerInfo layerInfo = (LayerInfo)layer;
            name = GWC.tileLayerName((LayerInfo)layerInfo);
            tileLayer = new GeoServerTileLayer((PublishedInfo)layerInfo, gridsets, tileLayerInfo);
        }
        tileLayerInfo.setName(name);
        if (tileLayerExists) {
            gwc.save((TileLayer)tileLayer);
        } else {
            gwc.add(tileLayer);
        }
    }

    private void updateConfigsVisibility(AjaxRequestTarget target) {
        boolean createTileLayer = (Boolean)this.createLayer.getModelObject();
        this.setValidating(createTileLayer);
        this.configs.setVisible(createTileLayer);
        target.addComponent((Component)this.container);
    }

    private void confirmRemovalOfExistingTileLayer(AjaxRequestTarget origTarget) {
        this.confirmRemovalDialog.setTitle((IModel)new Model((Serializable)((Object)"Confirm removal of cached contents?")));
        this.confirmRemovalDialog.showOkCancel(origTarget, new GeoServerDialog.DialogDelegate(){
            private static final long serialVersionUID = 1L;

            protected Component getContents(String id) {
                GWC gwc = GWC.get();
                Quota usedQuota = gwc.getUsedQuota(GeoServerTileLayerEditor.this.originalLayerName);
                if (usedQuota == null) {
                    usedQuota = new Quota();
                }
                String usedQuotaStr = usedQuota.toNiceString();
                return new Label(id, (IModel)new ParamResourceModel("confirmTileLayerRemoval", (Component)GeoServerTileLayerEditor.this, new Object[]{usedQuotaStr}));
            }

            protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                return true;
            }

            public void onClose(AjaxRequestTarget target) {
                target.addComponent((Component)GeoServerTileLayerEditor.this.createLayer);
                GeoServerTileLayerEditor.this.updateConfigsVisibility(target);
            }

            protected boolean onCancel(AjaxRequestTarget target) {
                GeoServerTileLayerEditor.this.createLayer.setModelObject((Object)Boolean.TRUE);
                boolean closeWindow = true;
                return true;
            }
        });
    }

    private void setValidating(boolean validate) {
        this.gridSubsets.setValidating(validate);
        this.cacheFormats.setRequired(validate);
    }

    protected void convertInput() {
        this.createLayer.processInput();
        boolean createTileLayer = (Boolean)this.createLayer.getModelObject();
        GeoServerTileLayerInfoModel model = (GeoServerTileLayerInfoModel)this.getModel();
        model.setEnabled(createTileLayer);
        GeoServerTileLayerInfo tileLayerInfo = (GeoServerTileLayerInfo)this.getModelObject();
        if (createTileLayer) {
            this.enabled.processInput();
            this.expireCache.processInput();
            this.expireClients.processInput();
            this.metaTilingX.processInput();
            this.metaTilingY.processInput();
            this.gutter.processInput();
            this.cacheFormats.processInput();
            this.parameterFilters.processInput();
            this.gridSubsets.processInput();
            tileLayerInfo.setId(((CatalogInfo)this.layerModel.getObject()).getId());
            this.setConvertedInput(tileLayerInfo);
        } else {
            tileLayerInfo.setId(null);
            this.setConvertedInput(tileLayerInfo);
        }
        this.setModelObject(tileLayerInfo);
    }

    protected void onBeforeRender() {
        super.onBeforeRender();
    }
}

