/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.form.DropDownChoice;
import org.apache.wicket.markup.html.form.FormComponent;
import org.apache.wicket.markup.html.form.FormComponentPanel;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.PropertyModel;
import org.geowebcache.filter.parameters.CaseNormalizer;

public class CaseNormalizerSubform
extends FormComponentPanel<CaseNormalizer> {
    private static final long serialVersionUID = -197485768903404047L;
    private DropDownChoice<Locale> localeEntry;
    private DropDownChoice<CaseNormalizer.Case> caseEntry;

    private List<Locale> getLocales() {
        Locale[] locales = Locale.getAvailableLocales();
        Arrays.sort(locales, new Comparator<Locale>(){

            @Override
            public int compare(Locale o1, Locale o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        return Arrays.asList(locales);
    }

    public CaseNormalizerSubform(String id, IModel<CaseNormalizer> model) {
        super(id, model);
        PropertyModel caseModel = new PropertyModel(model, "case");
        PropertyModel localeModel = new PropertyModel(model, "configuredLocale");
        this.localeEntry = new DropDownChoice("locale", (IModel)localeModel, this.getLocales(), (IChoiceRenderer)new IChoiceRenderer<Locale>(){

            public Object getDisplayValue(Locale object) {
                return object.getDisplayName(CaseNormalizerSubform.this.getLocale());
            }

            public String getIdValue(Locale object, int index) {
                return object.toString();
            }
        });
        this.localeEntry.setNullValid(true);
        this.caseEntry = new DropDownChoice("case", (IModel)caseModel, Arrays.asList(CaseNormalizer.Case.values()), (IChoiceRenderer)new IChoiceRenderer<CaseNormalizer.Case>(){
            private static final long serialVersionUID = 1L;

            public Object getDisplayValue(CaseNormalizer.Case object) {
                return CaseNormalizerSubform.this.getLocalizer().getString("case." + object.name(), (Component)CaseNormalizerSubform.this);
            }

            public String getIdValue(CaseNormalizer.Case object, int index) {
                return object.name();
            }
        });
        this.add(new Component[]{this.caseEntry});
        this.add(new Component[]{this.localeEntry});
    }

    protected void convertInput() {
        this.visitChildren((Component.IVisitor)new Component.IVisitor<Component>(){

            public Object component(Component component) {
                if (component instanceof FormComponent) {
                    FormComponent formComponent = (FormComponent)component;
                    formComponent.processInput();
                }
                return Component.IVisitor.CONTINUE_TRAVERSAL;
            }
        });
        CaseNormalizer filter = (CaseNormalizer)this.getModelObject();
        this.setConvertedInput(filter);
    }
}

