/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.gwc.web.layer;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.TreeSet;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ResourceReference;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.AjaxLink;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.link.BookmarkablePageLink;
import org.apache.wicket.markup.html.link.ExternalLink;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.ResourceModel;
import org.apache.wicket.model.StringResourceModel;
import org.geoserver.gwc.GWC;
import org.geoserver.gwc.layer.GeoServerTileLayer;
import org.geoserver.gwc.web.GWCIconFactory;
import org.geoserver.gwc.web.layer.CachedLayerProvider;
import org.geoserver.gwc.web.layer.ConfigureCachedLayerAjaxLink;
import org.geoserver.gwc.web.layer.NewCachedLayerPage;
import org.geoserver.web.GeoServerSecuredPage;
import org.geoserver.web.wicket.GeoServerDataProvider;
import org.geoserver.web.wicket.GeoServerDialog;
import org.geoserver.web.wicket.GeoServerTablePanel;
import org.geoserver.web.wicket.ParamResourceModel;
import org.geoserver.web.wicket.SimpleAjaxLink;
import org.geotools.image.io.ImageIOExt;
import org.geowebcache.diskquota.storage.Quota;
import org.geowebcache.layer.TileLayer;
import org.geowebcache.mime.MimeType;

public class CachedLayersPage
extends GeoServerSecuredPage {
    private CachedLayerProvider provider = new CachedLayerProvider();
    private GeoServerTablePanel<TileLayer> table = new GeoServerTablePanel<TileLayer>("table", (GeoServerDataProvider)this.provider, true){
        private static final long serialVersionUID = 1L;

        protected Component getComponentForProperty(String id, IModel itemModel, GeoServerDataProvider.Property<TileLayer> property) {
            if (property == CachedLayerProvider.TYPE) {
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                TileLayer layer = (TileLayer)itemModel.getObject();
                ResourceReference layerIcon = (ResourceReference)property.getPropertyValue((Object)layer);
                f.add(new Component[]{new Image("layerIcon", layerIcon)});
                return f;
            }
            if (property == CachedLayerProvider.NAME) {
                return CachedLayersPage.this.nameLink(id, (IModel<TileLayer>)itemModel);
            }
            if (property == CachedLayerProvider.QUOTA_LIMIT) {
                IModel quotaLimitModel = property.getModel(itemModel);
                return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaLimitModel);
            }
            if (property == CachedLayerProvider.QUOTA_USAGE) {
                IModel quotaUsageModel = property.getModel(itemModel);
                return CachedLayersPage.this.quotaLink(id, (IModel<Quota>)quotaUsageModel);
            }
            if (property == CachedLayerProvider.ENABLED) {
                TileLayer layerInfo = (TileLayer)itemModel.getObject();
                boolean enabled = layerInfo.isEnabled();
                ResourceReference icon = enabled ? GWCIconFactory.getEnabledIcon() : GWCIconFactory.getDisabledIcon();
                Fragment f = new Fragment(id, "iconFragment", (MarkupContainer)CachedLayersPage.this);
                f.add(new Component[]{new Image("layerIcon", icon)});
                return f;
            }
            if (property == CachedLayerProvider.PREVIEW_LINKS) {
                return CachedLayersPage.this.previewLinks(id, (IModel<TileLayer>)itemModel);
            }
            if (property == CachedLayerProvider.ACTIONS) {
                return CachedLayersPage.this.actionsLinks(id, (IModel<TileLayer>)itemModel);
            }
            if (property == CachedLayerProvider.BLOBSTORE) {
                return null;
            }
            throw new IllegalArgumentException("Don't know a property named " + property.getName());
        }

        protected void onSelectionUpdate(AjaxRequestTarget target) {
            CachedLayersPage.this.removal.setEnabled(CachedLayersPage.this.table.getSelection().size() > 0);
            target.addComponent((Component)CachedLayersPage.this.removal);
        }
    };
    private GeoServerDialog dialog;
    private CachedLayerSelectionRemovalLink removal;

    public CachedLayersPage() {
        this.table.setOutputMarkupId(true);
        this.add(new Component[]{this.table});
        Component[] componentArray = new Component[1];
        this.dialog = new GeoServerDialog("dialog");
        componentArray[0] = this.dialog;
        this.add(componentArray);
        this.dialog.setInitialWidth(360);
        this.dialog.setInitialHeight(180);
        this.setHeaderPanel(this.headerPanel());
        Long imageIOFileCachingThreshold = ImageIOExt.getFilesystemThreshold();
        if (null == imageIOFileCachingThreshold || 0L >= imageIOFileCachingThreshold) {
            String warningMsg = new ResourceModel("GWC.ImageIOFileCachingThresholdUnsetWarning").getObject();
            super.warn(warningMsg);
        }
    }

    private Component quotaLink(String id, IModel<Quota> quotaModel) {
        Quota quota = (Quota)quotaModel.getObject();
        String formattedQuota = null == quota ? new ResourceModel("CachedLayersPage.quotaLimitNotSet").getObject() : quota.toNiceString();
        return new Label(id, formattedQuota);
    }

    private Component nameLink(String id, IModel<TileLayer> itemModel) {
        TileLayer layer = (TileLayer)itemModel.getObject();
        String layerName = layer.getName();
        Object link = layer instanceof GeoServerTileLayer ? new ConfigureCachedLayerAjaxLink(id, itemModel, CachedLayersPage.class) : new Label(id, layerName);
        return link;
    }

    private Component actionsLinks(String id, IModel<TileLayer> tileLayerNameModel) {
        String name = ((TileLayer)tileLayerNameModel.getObject()).getName();
        String href = "../gwc/rest/seed/" + name;
        Fragment f = new Fragment(id, "actionsFragment", (MarkupContainer)this);
        f.add(new Component[]{new ExternalLink("seedLink", href, new ResourceModel("CachedLayersPage.seed").getObject())});
        f.add(new Component[]{this.truncateLink("truncateLink", tileLayerNameModel)});
        return f;
    }

    private SimpleAjaxLink<String> truncateLink(String id, IModel<TileLayer> tileLayerNameModel) {
        String layerName = ((TileLayer)tileLayerNameModel.getObject()).getName();
        Model model = new Model((Serializable)((Object)layerName));
        ResourceModel labelModel = new ResourceModel("truncate");
        SimpleAjaxLink<String> link = new SimpleAjaxLink<String>(id, (IModel)model, (IModel)labelModel){
            private static final long serialVersionUID = 1L;

            protected void onClick(AjaxRequestTarget target) {
                CachedLayersPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmTruncateTitle", (Component)CachedLayersPage.this, new Object[0]));
                CachedLayersPage.this.dialog.setDefaultModel(this.getDefaultModel());
                CachedLayersPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                    private static final long serialVersionUID = 1L;

                    protected Component getContents(String id) {
                        String layerName = this.getDefaultModelObjectAsString();
                        GWC gwcFacade = GWC.get();
                        Quota usedQuota = gwcFacade.getUsedQuota(layerName);
                        if (usedQuota == null) {
                            usedQuota = new Quota();
                        }
                        String usedQuotaStr = usedQuota.toNiceString();
                        ParamResourceModel model = new ParamResourceModel("CachedLayersPage.confirmTruncateMessage", (Component)CachedLayersPage.this, new Object[]{layerName, usedQuotaStr});
                        Label confirmLabel = new Label(id, (IModel)model);
                        confirmLabel.setEscapeModelStrings(false);
                        return confirmLabel;
                    }

                    protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                        String layerName = this.getDefaultModelObjectAsString();
                        GWC facade = GWC.get();
                        facade.truncate(layerName);
                        return true;
                    }

                    public void onClose(AjaxRequestTarget target) {
                        target.addComponent((Component)CachedLayersPage.this.table);
                    }
                });
            }
        };
        return link;
    }

    private Component previewLinks(String id, IModel<TileLayer> tileLayerModel) {
        TileLayer layer = (TileLayer)tileLayerModel.getObject();
        if (!layer.isEnabled()) {
            return new Label(id, (IModel)new ResourceModel("previewDisabled"));
        }
        TreeSet gridSubsets = new TreeSet(layer.getGridSubsets());
        ArrayList mimeTypes = new ArrayList(layer.getMimeTypes());
        Collections.sort(mimeTypes, new Comparator<MimeType>(){

            @Override
            public int compare(MimeType o1, MimeType o2) {
                return o1.getFormat().compareTo(o2.getFormat());
            }
        });
        Fragment f = new Fragment(id, "menuFragment", (MarkupContainer)this);
        WebMarkupContainer menu = new WebMarkupContainer("menu");
        RepeatingView previewLinks = new RepeatingView("previewLink");
        int i = 0;
        for (String gridSetId : gridSubsets) {
            for (MimeType mimeType : mimeTypes) {
                String label = gridSetId + " / " + mimeType.getFileExtension();
                Label format = new Label(String.valueOf(i++), label);
                String value = "gridSet=" + gridSetId + "&format=" + mimeType.getFormat();
                format.add(new IBehavior[]{new AttributeModifier("value", true, (IModel)new Model((Serializable)((Object)value)))});
                previewLinks.add(new Component[]{format});
            }
        }
        menu.add(new Component[]{previewLinks});
        String demoUrl = "'../gwc/demo/" + layer.getName() + "?' + this.options[this.selectedIndex].value";
        menu.add(new IBehavior[]{new AttributeAppender("onchange", (IModel)new Model((Serializable)((Object)("window.open(" + demoUrl + ");this.selectedIndex=0"))), ";")});
        f.add(new Component[]{menu});
        return f;
    }

    protected Component headerPanel() {
        Fragment header = new Fragment("headerPanel", "header", (MarkupContainer)this);
        header.add(new Component[]{new BookmarkablePageLink("addNew", NewCachedLayerPage.class)});
        Component[] componentArray = new Component[1];
        this.removal = new CachedLayerSelectionRemovalLink("removeSelected");
        componentArray[0] = this.removal;
        header.add(componentArray);
        this.removal.setOutputMarkupId(true);
        this.removal.setEnabled(false);
        return header;
    }

    private class CachedLayerSelectionRemovalLink
    extends AjaxLink<TileLayer> {
        private static final long serialVersionUID = 1L;

        public CachedLayerSelectionRemovalLink(String string) {
            super(string);
        }

        public void onClick(AjaxRequestTarget target) {
            List selection = CachedLayersPage.this.table.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            final ArrayList<String> selectedNames = new ArrayList<String>();
            for (TileLayer layer : selection) {
                selectedNames.add(layer.getName());
            }
            CachedLayersPage.this.dialog.setTitle((IModel)new ParamResourceModel("confirmRemoval", (Component)CachedLayersPage.this, new Object[0]));
            CachedLayersPage.this.dialog.showOkCancel(target, new GeoServerDialog.DialogDelegate(){
                private static final long serialVersionUID = 1L;

                protected Component getContents(String id) {
                    GWC gwcFacade = GWC.get();
                    Quota totalQuota = new Quota();
                    for (String layerName : selectedNames) {
                        Quota usedQuota = gwcFacade.getUsedQuota(layerName);
                        if (usedQuota == null) continue;
                        totalQuota.add(usedQuota);
                    }
                    String usedQuotaStr = totalQuota.toNiceString();
                    Integer selectedLayerCount = selectedNames.size();
                    StringResourceModel model = new StringResourceModel("CachedLayersPage.confirmSelectionRemoval", (Component)CachedLayerSelectionRemovalLink.this, null, new Object[]{selectedLayerCount.toString(), usedQuotaStr});
                    Label confirmLabel = new Label(id, (IModel)model);
                    confirmLabel.setEscapeModelStrings(false);
                    return confirmLabel;
                }

                protected boolean onSubmit(AjaxRequestTarget target, Component contents) {
                    GWC facade = GWC.get();
                    facade.removeTileLayers(selectedNames);
                    CachedLayersPage.this.table.clearSelection();
                    return true;
                }

                public void onClose(AjaxRequestTarget target) {
                    List selection = CachedLayersPage.this.table.getSelection();
                    if (selection.isEmpty()) {
                        CachedLayerSelectionRemovalLink.this.setEnabled(false);
                        target.addComponent((Component)CachedLayerSelectionRemovalLink.this);
                        target.addComponent((Component)CachedLayersPage.this.table);
                    }
                }
            });
        }
    }
}

